/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.deployment.Binding;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.deployment.ui.FileBrowseDialog;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.util.CoreUtility;
import org.eclipse.edt.ide.ui.internal.wizards.EGLBindingWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.ServiceBindingWizard;
import org.eclipse.edt.ide.ui.wizards.BindingBaseConfiguration;
import org.eclipse.edt.ide.ui.wizards.BindingEGLConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLWizardUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class ServiceBindingWizardPage
extends EGLBindingWizardPage {
    public static final String WIZPAGENAME_EGLServiceBindingWizardPage = "WIZPAGENAME_EGLServiceBindingWizardPage";
    private StatusInfo fEGLDDFileStatus;

    public ServiceBindingWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.EGLServiceBindingWizPageTitle);
        this.setDescription(NewWizardMessages.EGLServiceBindingWizPageDescription);
        this.nColumns = 5;
        this.fEGLDDFileStatus = new StatusInfo();
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.MODULE_EXTERNALSERVICE_WS1);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.createEGLDDFileControl(composite);
        this.createBindingControls(composite, this.getConfiguration(), null, true);
        this.createCheckBoxOverwriteFileControl(composite, NewWizardMessages.UpdateEGLBindingLabel);
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    @Override
    public void setVisible(boolean visible) {
        String eglddfileName;
        super.setVisible(visible);
        if (visible && ((eglddfileName = this.fEGLFileDialogField.getText()) == null || eglddfileName.trim().length() == 0)) {
            this.fEGLFileDialogField.setText(CoreUtility.getValidProjectName(this.getBindingEGLConfiguration().getProjectName()));
        }
    }

    private BindingEGLConfiguration getConfiguration() {
        return (BindingEGLConfiguration)((ServiceBindingWizard)this.getWizard()).getConfiguration(this.getName());
    }

    @Override
    protected BindingEGLConfiguration getBindingEGLConfiguration() {
        return (BindingEGLConfiguration)((ServiceBindingWizard)this.getWizard()).getConfiguration(WIZPAGENAME_EGLServiceBindingWizardPage);
    }

    @Override
    protected void createComponentNameControl(Composite parent, String labelName, BindingBaseConfiguration esConfig) {
        this.createComponentNameNoBrowseControl(parent, labelName, esConfig);
    }

    private void createEGLDDFileControl(Composite composite) {
        this.createContainerControls(composite, this.nColumns);
        this.createEGLFileWithBrowseControls(composite, NewWizardMessages.EGLDDLabel);
        this.createSeparator(composite, this.nColumns);
    }

    @Override
    protected void handleFileBrowseButtonSelected() {
        Object obj;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getBindingEGLConfiguration().getProjectName());
        ElementTreeSelectionDialog dialog = FileBrowseDialog.openBrowseFileDialog(this.getShell(), project, null, false, true, null, "egldd", NewWizardMessages.ChooseEGLDDDialogTitle, NewWizardMessages.ChooseEGLDDDialogDescription, NewWizardMessages.ChooseEGLDDDialogMsg);
        if (dialog.open() == 0 && (obj = dialog.getFirstResult()) instanceof IFile) {
            IFile eglddFile = (IFile)obj;
            String fullFileName = eglddFile.getName();
            int dot = fullFileName.indexOf(46);
            this.fEGLFileDialogField.setText(fullFileName.substring(0, dot));
        }
    }

    @Override
    protected void handleEGLFileDialogFieldChanged() {
        super.handleEGLFileDialogFieldChanged();
        IFile eglddFile = CoreUtility.getExistingEGLDDFileHandle(this.getBindingEGLConfiguration());
        if (eglddFile != null) {
            EGLDeploymentRoot deploymentRoot = null;
            try {
                if (eglddFile.exists()) {
                    deploymentRoot = EGLDDRootHelper.getEGLDDFileSharedWorkingModel(eglddFile, false);
                }
                this.getBindingEGLConfiguration().setEGLDeploymentDescriptor(eglddFile, deploymentRoot);
                this.validatePage();
            }
            finally {
                if (deploymentRoot != null) {
                    EGLDDRootHelper.releaseSharedWorkingModel(eglddFile, false);
                }
            }
        }
    }

    @Override
    protected void validateBindingName(StatusInfo statusinfo) {
        String currBindingName;
        Binding eglBinding;
        EGLDeploymentRoot deploymentRoot;
        if (!this.getBindingEGLConfiguration().isOverwrite() && (deploymentRoot = this.getBindingEGLConfiguration().getEGLDeploymentRoot()) != null && (eglBinding = EGLDDRootHelper.getBindingByName(deploymentRoot, currBindingName = this.getBindingEGLConfiguration().getBindingName())) != null) {
            statusinfo.setError(NewWizardMessages.bind((String)NewWizardMessages.WSDLBindingWizpageValidationQueryOverride, (Object)currBindingName, (Object)CoreUtility.getExistingEGLDDFileHandle(this.getBindingEGLConfiguration()).getName()));
        }
    }

    @Override
    protected boolean validatePage() {
        boolean ret = false;
        this.fEGLDDFileStatus.setOK();
        if (super.validatePage()) {
            String eglddFileName = this.getBindingEGLConfiguration().getFileName();
            if (eglddFileName == null || eglddFileName.trim().length() == 0) {
                this.fEGLDDFileStatus.setError(NewWizardMessages.WSDLBindingWizPageValidationSetEGLDD);
            } else {
                String projectName = this.getBindingEGLConfiguration().getProjectName();
                String containerName = this.getBindingEGLConfiguration().getContainerName();
                String fileName = this.getBindingEGLConfiguration().getFileName();
                String fileExtensionName = this.getBindingEGLConfiguration().getFileExtension();
                ret = EGLWizardUtilities.validateFile(projectName, containerName, "", fileName, fileExtensionName, this.fEGLDDFileStatus, (Object)this, false);
            }
            this.updateStatus(new IStatus[]{this.fEGLDDFileStatus});
        }
        return ret;
    }
}

