/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.ide.core.internal.builder.AbstractBuilder;
import org.eclipse.edt.ide.core.internal.builder.BuildManagerChange;
import org.eclipse.edt.ide.core.internal.builder.BuildManagerPackageChange;
import org.eclipse.edt.ide.core.internal.builder.BuildManagerPartChange;
import org.eclipse.edt.ide.core.internal.builder.Builder;
import org.eclipse.edt.ide.core.internal.builder.BuilderResources;
import org.eclipse.edt.ide.core.internal.builder.IncrementalProcessingQueue;

public class IncrementalBuilder
extends AbstractBuilder {
    public IncrementalBuilder(Builder builder, IBuildNotifier notifier) {
        super(builder, notifier);
        this.processingQueue = new IncrementalProcessingQueue(builder.getProject(), notifier);
    }

    @Override
    protected void build() {
        this.processRequiredProjectChanges();
    }

    protected void processRequiredProjectChanges() {
        this.notifier.subTask(BuilderResources.buildProcessingDependentChanges);
        BuildManagerChange[] changes = this.buildManager.getChanges(this.builder.getProject());
        int i = 0;
        while (i < changes.length) {
            if (changes[i].isPackage()) {
                this.addDependents(((BuildManagerPackageChange)changes[i]).getPackageName());
            } else {
                BuildManagerPartChange partChange = (BuildManagerPartChange)changes[i];
                if (partChange.getPartType() == 20) {
                    this.addDependents(partChange.getPartName());
                } else {
                    this.addDependents(partChange.getPackageName(), partChange.getPartName());
                }
            }
            ++i;
        }
    }
}

