/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class Mnemonics {
    public static final int EMBED_MNEMONICS = 1;
    public static final int APPEND_MNEMONICS = 2;
    public static final String APPEND_MNEMONICS_PATTERN_PREFERENCE = "APPEND_MNEMONICS_PATTERN";
    public static final String APPEND_MNEMONICS_PATTERN_DEFAULT = "zh.*|ja.*|ko.*";
    public static final String POLICY_PREFERENCE = "MNEMONICS_POLICY";
    public static final int POLICY_DEFAULT = 3;
    private static final char MNEMONIC_CHAR = '&';
    private static final String LC_GREEK = "el";
    private static final String LC_RUSSIAN = "ru";
    private static final String GREEK_MNEMONICS = "\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9";
    private static final String RUSSIAN_MNEMONICS = "\u0410\u0411\u0412\u0413\u0414\u0145\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f";
    private static final String LATIN_MNEMONICS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Pattern TRANSPARENT_ENDING_PATTERN = Pattern.compile("(\\s|\\.\\.\\.|>|<|:|\uff0e\uff0e\uff0e|\uff1e|\uff1c|\uff1a|\\t.*)+$");
    private boolean applyMnemonicsToPrecedingLabels = true;
    private Map usedCharacters = new HashMap();

    public static char getMnemonic(String text) {
        int idx = text.indexOf(38);
        if (idx >= 0 && idx < text.length() - 1) {
            return text.charAt(idx + 1);
        }
        return ' ';
    }

    public static String applyMnemonic(String label, char mnemonicChar) {
        int labelLen = label.length();
        if (labelLen == 0) {
            return label;
        }
        StringBuffer newLabel = new StringBuffer(label);
        int mcharPos = label.indexOf(mnemonicChar);
        if (mcharPos != -1) {
            newLabel.insert(mcharPos, '&');
        } else {
            String addedMnemonic = new String("(&" + mnemonicChar + ")");
            int p = Mnemonics.getEndingPosition(label);
            newLabel.insert(p, addedMnemonic);
        }
        return newLabel.toString();
    }

    public static String removeMnemonic(String text) {
        String[] parts = text.split("\\(\\&.\\)", 2);
        if (parts.length == 1) {
            parts = text.split("\\&", 2);
        }
        if (parts.length == 2) {
            text = String.valueOf(parts[0]) + parts[1];
        }
        return text;
    }

    private static int getEndingPosition(String label) {
        Matcher m = TRANSPARENT_ENDING_PATTERN.matcher(label);
        int result = m.find() ? m.start() : label.length();
        return result;
    }

    public void clear() {
        this.usedCharacters.clear();
    }

    public void clear(String usedMnemonics) {
        this.clear();
        this.makeUsed(usedMnemonics);
    }

    public String setUniqueMnemonic(String label) {
        String localePattern = APPEND_MNEMONICS_PATTERN_DEFAULT;
        String result = this.setUniqueMnemonic(label, 1, localePattern, false);
        return result;
    }

    private String setUniqueMnemonic(String label, int flags, String localePattern, boolean allowDuplicates) {
        int p;
        if (flags == 0 || label == null || label.trim().length() == 0 || label.equals("?")) {
            return label;
        }
        StringBuffer buffer = new StringBuffer(label);
        char mn = Mnemonics.getMnemonic(label);
        if (mn == ' ' && (flags & 1) > 0 && (p = this.findUniqueMnemonic(label)) >= 0) {
            mn = label.charAt(p);
            buffer.insert(p, '&');
        }
        if (mn == ' ' && allowDuplicates) {
            int n = Mnemonics.getEndingPosition(label);
            int m = 999;
            int p2 = -1;
            int i = 0;
            while (i < n) {
                char ch = label.charAt(i);
                if (this.isAcceptable(ch) && this.timesUsed(ch) < m) {
                    m = this.timesUsed(ch);
                    p2 = i;
                }
                ++i;
            }
            if (p2 >= 0) {
                mn = label.charAt(p2);
                buffer.insert(p2, '&');
            }
        }
        this.makeUsed(mn);
        return buffer.toString();
    }

    public boolean isUniqueMnemonic(char ch) {
        return this.timesUsed(ch) == 0;
    }

    private String getLocalePattern() {
        return APPEND_MNEMONICS_PATTERN_DEFAULT;
    }

    private int getPolicy() {
        return 1;
    }

    private boolean isEmbedding() {
        return (this.getPolicy() & 1) > 0;
    }

    private boolean isAppending() {
        return (this.getPolicy() & 2) > 0;
    }

    private String getCandidates() {
        return LATIN_MNEMONICS;
    }

    private int findUniqueMnemonic(String label) {
        int uniqueIndex = -1;
        char ch = label.charAt(0);
        int i = 0;
        while (i < label.length() && uniqueIndex == -1) {
            ch = label.charAt(i);
            if (ch == '\t') break;
            if (this.timesUsed(ch) == 0 && this.isAcceptable(ch)) {
                uniqueIndex = i;
            }
            ++i;
        }
        return uniqueIndex;
    }

    private boolean isAcceptable(char ch) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(ch);
        boolean result = this.isAcceptable(block) && Character.isLetter(ch);
        return result;
    }

    private boolean isAcceptable(Character.UnicodeBlock block) {
        if (block == Character.UnicodeBlock.BASIC_LATIN) {
            return true;
        }
        if (block == Character.UnicodeBlock.LATIN_1_SUPPLEMENT) {
            return true;
        }
        if (block == Character.UnicodeBlock.LATIN_EXTENDED_A) {
            return true;
        }
        if (block == Character.UnicodeBlock.LATIN_EXTENDED_B) {
            return true;
        }
        if (block == Character.UnicodeBlock.GREEK) {
            return true;
        }
        if (block == Character.UnicodeBlock.CYRILLIC) {
            return true;
        }
        if (block == Character.UnicodeBlock.HEBREW) {
            return true;
        }
        return block == Character.UnicodeBlock.ARABIC;
    }

    private int timesUsed(char ch) {
        int result = 0;
        Integer count = (Integer)this.usedCharacters.get(new Character(ch));
        if (count != null) {
            result = count;
        }
        return result;
    }

    private void makeUsed(char ch) {
        if (ch != ' ') {
            this.makeUsed(new Character(Character.toLowerCase(ch)));
            this.makeUsed(new Character(Character.toUpperCase(ch)));
        }
    }

    private void makeUsed(Character ch) {
        Integer count = (Integer)this.usedCharacters.get(ch);
        if (count == null) {
            count = new Integer(1);
        }
        this.usedCharacters.put(ch, count);
    }

    private void makeUsed(String s) {
        int i = 0;
        while (i < s.length()) {
            this.makeUsed(s.charAt(i));
            ++i;
        }
    }

    private String getMnemonicsFromStrings(String[] strings) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            int idx = strings[i].indexOf(38);
            if (idx != -1) {
                result.append(strings[i].charAt(idx + 1));
            }
            ++i;
        }
        return result.toString();
    }

    public Mnemonics setApplyMnemonicsToPrecedingLabels(boolean apply) {
        this.applyMnemonicsToPrecedingLabels = apply;
        return this;
    }

    public void setMnemonics(CTabFolder tabFolder) {
        CTabItem[] tabItems = tabFolder.getItems();
        int i = 0;
        while (i < tabItems.length) {
            String newText;
            String text = tabItems[i].getText();
            if (text != null && text.trim().length() > 0 && !text.equals(newText = this.setUniqueMnemonic(text))) {
                tabItems[i].setText(newText);
            }
            ++i;
        }
        i = 0;
        while (i < tabItems.length) {
            if (tabItems[i].getControl() instanceof Composite) {
                this.setMnemonics((Composite)tabItems[i].getControl());
            }
            ++i;
        }
    }

    public void setMnemonics(TabFolder tabFolder) {
        TabItem[] tabItems = tabFolder.getItems();
        int i = 0;
        while (i < tabItems.length) {
            String newText;
            String text = tabItems[i].getText();
            if (text != null && text.trim().length() > 0 && !text.equals(newText = this.setUniqueMnemonic(text))) {
                tabItems[i].setText(newText);
            }
            ++i;
        }
        i = 0;
        while (i < tabItems.length) {
            if (tabItems[i].getControl() instanceof Composite) {
                this.setMnemonics((Composite)tabItems[i].getControl());
            }
            ++i;
        }
    }

    public boolean setMnemonic(Button button) {
        String newText;
        boolean changed = false;
        String text = button.getText();
        if (text != null && text.trim().length() > 0 && !text.equals(newText = this.setUniqueMnemonic(text))) {
            button.setText(newText);
            changed = true;
        }
        return changed;
    }

    public void setMnemonics(Menu menu) {
        TreeSet<MenuItem> embeddingItems = new TreeSet<MenuItem>(new Comparator(){

            public int compare(Object o1, Object o2) {
                int l2;
                String t1 = ((MenuItem)o1).getText();
                String t2 = ((MenuItem)o2).getText();
                int l1 = Mnemonics.getEndingPosition(t1);
                if (l1 < (l2 = Mnemonics.getEndingPosition(t2))) {
                    return -1;
                }
                if (l1 > l2) {
                    return 1;
                }
                return t1.compareTo(t2);
            }
        });
        ArrayList<MenuItem> appendingItems = new ArrayList<MenuItem>(10);
        MenuItem[] menuItems = menu.getItems();
        int i = 0;
        while (i < menuItems.length) {
            String text;
            MenuItem menuItem = menuItems[i];
            Menu cascade = menuItem.getMenu();
            if (cascade != null) {
                Mnemonics context = new Mnemonics();
                context.setMnemonics(cascade);
            }
            if ((text = menuItem.getText()).length() > 0) {
                char ch = Mnemonics.getMnemonic(text);
                if (ch == ' ') {
                    embeddingItems.add(menuItem);
                    appendingItems.add(menuItem);
                } else {
                    this.makeUsed(ch);
                }
            }
            ++i;
        }
        String localePattern = this.getLocalePattern();
        if (this.isEmbedding()) {
            this.processMenuItems(embeddingItems, 1, localePattern);
        }
        if (this.isAppending()) {
            this.processMenuItems(appendingItems, 2, localePattern);
        }
    }

    private void processMenuItems(Collection collection, int flags, String localePattern) {
        for (MenuItem menuItem : collection) {
            String newText;
            String text = menuItem.getText();
            if (text.equals(newText = this.setUniqueMnemonic(text, flags, localePattern, true))) continue;
            Image image = menuItem.getImage();
            menuItem.setText(newText);
            if (image == null) continue;
            menuItem.setImage(image);
        }
    }

    public void setMnemonics(Composite parent) {
        this.setMnemonics(parent, new HashSet());
    }

    public void setMnemonics(Composite parent, Set ignoredControls) {
        this.gatherCompositeMnemonics(parent);
        boolean mustLayout = this.setCompositeMnemonics(parent, ignoredControls);
        if (mustLayout) {
            parent.layout(true);
        }
    }

    private boolean setCompositeMnemonics(Composite parent, Set ignoredControls) {
        Control[] children = parent.getChildren();
        Control currentChild = null;
        boolean mustLayout = false;
        int i = 0;
        while (i < children.length) {
            Control previousChild = currentChild;
            currentChild = children[i];
            if (!ignoredControls.contains(currentChild)) {
                if (currentChild instanceof Combo) {
                    String newText;
                    Label label;
                    String text;
                    if (this.applyMnemonicsToPrecedingLabels && previousChild instanceof Label && (text = (label = (Label)previousChild).getText()) != null && text.trim().length() > 0 && !text.equals(newText = this.setUniqueMnemonic(text))) {
                        label.setText(newText);
                        mustLayout = true;
                    }
                } else if (currentChild instanceof Button) {
                    mustLayout |= this.setMnemonic((Button)currentChild);
                } else if (currentChild instanceof Composite) {
                    mustLayout |= this.setCompositeMnemonics((Composite)currentChild, ignoredControls);
                }
            }
            ++i;
        }
        return mustLayout;
    }

    private void gatherCompositeMnemonics(Composite parent) {
        Control[] children = parent.getChildren();
        Control currentChild = null;
        int i = 0;
        while (i < children.length) {
            Control previousChild = currentChild;
            currentChild = children[i];
            String childText = null;
            if (currentChild instanceof Combo || currentChild instanceof Text) {
                if (this.applyMnemonicsToPrecedingLabels && previousChild instanceof Label) {
                    Label label = (Label)previousChild;
                    childText = label.getText();
                }
            } else if (currentChild instanceof Button) {
                childText = ((Button)currentChild).getText();
            } else if (currentChild instanceof Composite) {
                this.gatherCompositeMnemonics((Composite)currentChild);
            }
            if (childText != null) {
                char ch = Mnemonics.getMnemonic(childText);
                this.makeUsed(ch);
            }
            ++i;
        }
    }

    public Mnemonics setOnPreferencePage(boolean page) {
        if (page) {
            String[] labels = JFaceResources.getStrings((String[])new String[]{"defaults", "apply"});
            String used = this.getMnemonicsFromStrings(labels).toUpperCase();
            this.makeUsed(used);
        }
        return this;
    }

    public Mnemonics setOnWizardPage(boolean page) {
        if (page) {
            String[] labels = new String[]{IDialogConstants.BACK_LABEL, IDialogConstants.NEXT_LABEL, IDialogConstants.FINISH_LABEL};
            String used = this.getMnemonicsFromStrings(labels).toUpperCase();
            this.makeUsed(used);
        }
        return this;
    }
}

