/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal;

import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class EGLElementImageDescriptor
extends CompositeImageDescriptor {
    public static final int WARNING = 32;
    public static final int ERROR = 64;
    public static final int SERVICEREF = 128;
    public static final int WEBSERVICE = 256;
    public static final int TCPIP = 512;
    public static final int CICS = 1024;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;
    public static final Point SMALL_SIZE = new Point(16, 16);

    public EGLElementImageDescriptor(ImageDescriptor baseImage, int flags, Point size) {
        this.fBaseImage = baseImage;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = size;
        Assert.isNotNull((Object)this.fSize);
    }

    public void setAdornments(int adornments) {
        Assert.isTrue((adornments >= 0 ? 1 : 0) != 0);
        this.fFlags = adornments;
    }

    public int getAdronments() {
        return this.fFlags;
    }

    public void setImageSize(Point size) {
        Assert.isNotNull((Object)size);
        Assert.isTrue((size.x >= 0 && size.y >= 0 ? 1 : 0) != 0);
        this.fSize = size;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (object == null || !EGLElementImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        EGLElementImageDescriptor other = (EGLElementImageDescriptor)((Object)object);
        return this.fBaseImage.equals(other.fBaseImage) && this.fFlags == other.fFlags && this.fSize.equals((Object)other.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.fBaseImage.getImageData();
        if (bg == null) {
            bg = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private void drawTopRight() {
    }

    private void drawBottomRight() {
        Point size = this.getSize();
        int x = size.x;
        ImageData data = null;
        if ((this.fFlags & 0x80) != 0) {
            data = PluginImages.DESC_OVR_SERVICEREF.getImageData();
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
        if ((this.fFlags & 0x100) != 0) {
            data = PluginImages.DESC_OVR_WEBSERVICE.getImageData();
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
        if ((this.fFlags & 0x200) != 0) {
            data = PluginImages.DESC_OVR_TCPIP.getImageData();
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
        if ((this.fFlags & 0x400) != 0) {
            data = PluginImages.DESC_OVR_CICS.getImageData();
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
    }

    private void drawBottomLeft() {
        Point size = this.getSize();
        int x = 0;
        ImageData data = null;
        if ((this.fFlags & 0x40) != 0) {
            data = PluginImages.DESC_OVR_ERROR.getImageData();
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
        if ((this.fFlags & 0x20) != 0) {
            data = PluginImages.DESC_OVR_WARNING.getImageData();
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
    }
}

