/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal;

import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.ui.EDTUIPlugin;

public class EGLLogger {
    private static Logger msgLogger;
    private static final String ID = "org.eclipse.edt.ide.ui";
    private static boolean displayToConsole;

    static {
        displayToConsole = false;
    }

    private EGLLogger() {
    }

    public static void log(Object source, String message) {
        EGLLogger.doLog(source, message, null);
    }

    public static void log(Object source, String message, Throwable throwable) {
        EGLLogger.doLog(source, message, throwable);
    }

    public static void log(Object source, Throwable throwable) {
        EGLLogger.doLog(source, null, throwable);
    }

    public static void trace(Object source, String message) {
        EGLLogger.doTrace(Level.FINE, source, message);
    }

    public static void traceFiner(Object source, String message) {
        EGLLogger.doTrace(Level.FINER, source, message);
    }

    public static void traceFinest(Object source, String message) {
        EGLLogger.doTrace(Level.FINEST, source, message);
    }

    private static void doLog(Object source, String message, Throwable throwable) {
        Level level = EGLLogger.getLevelFor(throwable);
        message = EGLLogger.getMessageFor(source, message);
        try {
            try {
                Status s = new Status(EGLLogger.getStatusLevelFor(level), ID, 0, message, throwable);
                EGLLogger.getLog().log(level, s.getMessage());
            }
            catch (Exception exception) {
                if (displayToConsole) {
                    PrintStream out = EGLLogger.getPrintStreamFor(level);
                    out.println(message);
                    if (throwable != null) {
                        throwable.printStackTrace(out);
                    }
                }
            }
        }
        finally {
            if (displayToConsole) {
                PrintStream out = EGLLogger.getPrintStreamFor(level);
                out.println(message);
                if (throwable != null) {
                    throwable.printStackTrace(out);
                }
            }
        }
    }

    private static void doTrace(Level level, Object source, String message) {
        String bigMessage = String.valueOf(source.toString()) + ": " + " time: " + System.currentTimeMillis() + " " + Thread.currentThread().toString() + " " + message;
        try {
            try {
                EGLLogger.getLog().log(level, bigMessage);
            }
            catch (Exception exception) {
                if (displayToConsole) {
                    System.out.println(EGLLogger.getMessageFor(source, message));
                }
            }
        }
        finally {
            if (displayToConsole) {
                System.out.println(EGLLogger.getMessageFor(source, message));
            }
        }
    }

    private static Logger getLog() {
        if (msgLogger == null) {
            msgLogger = EDTUIPlugin.getDefault().getLogger();
        }
        return msgLogger;
    }

    private static String getMessageFor(Object source, String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(source);
        if (message != null) {
            buffer.append(": ");
            buffer.append(message);
        }
        return buffer.toString();
    }

    private static int getStatusLevelFor(Level level) {
        if (level.equals(Level.WARNING)) {
            return 2;
        }
        if (level.equals(Level.SEVERE)) {
            return 4;
        }
        return 1;
    }

    private static PrintStream getPrintStreamFor(Level level) {
        if (level.equals(Level.WARNING) || level.equals(Level.SEVERE)) {
            return System.err;
        }
        return System.out;
    }

    private static Level getLevelFor(Throwable throwable) {
        return throwable == null ? Level.WARNING : Level.SEVERE;
    }
}

