/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.EnumerationField;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLPartSearchProposalHandler;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class EGLPartSearchAnnotationProposalHandler
extends EGLPartSearchProposalHandler {
    private boolean addPrefix;
    private boolean addSuffix;
    private List<AnnotationType> exclude;
    private Node boundNode;
    private ProjectEnvironment env;

    public EGLPartSearchAnnotationProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor, boolean addPrefix, boolean addSuffix, List<AnnotationType> exclude, Node boundNode) {
        super(viewer, documentOffset, prefix, editor);
        this.addPrefix = addPrefix;
        this.addSuffix = addSuffix;
        this.exclude = exclude;
        this.boundNode = boundNode;
    }

    @Override
    protected String getProposalString(PartDeclarationInfo part, boolean includePackageName) {
        String partName = part.getPartName();
        if (this.addSuffix) {
            partName = String.valueOf(partName) + "{}";
        }
        if (this.addPrefix) {
            return "@" + partName;
        }
        return partName;
    }

    @Override
    protected String getPartTypeImgKeyStr(String partType) {
        if ("record" == partType) {
            return "org.eclipse.edt.ide.ui.annotation_obj.gif";
        }
        return super.getPartTypeImgKeyStr(partType);
    }

    @Override
    protected boolean shouldInclude(PartDeclarationInfo partDeclarationInfo) {
        IPartBinding part;
        ProjectEnvironment env;
        String qualifiedName = partDeclarationInfo.getPackageName().isEmpty() ? partDeclarationInfo.getPartName() : String.valueOf(partDeclarationInfo.getPackageName()) + "." + partDeclarationInfo.getPartName();
        for (AnnotationType annType : this.exclude) {
            if (!qualifiedName.equalsIgnoreCase(annType.getETypeSignature())) continue;
            return false;
        }
        Element elem = this.getElementForBoundNode(this.boundNode);
        if (elem != null && (env = this.getEnv()) != null && (part = env.getPartBinding(NameUtile.getAsName((String)partDeclarationInfo.getPackageName()), NameUtile.getAsName((String)partDeclarationInfo.getPartName()))) instanceof IRPartBinding && ((IRPartBinding)part).getIrPart() instanceof AnnotationType) {
            AnnotationType annType = (AnnotationType)((IRPartBinding)part).getIrPart();
            return BindingUtil.isApplicableFor((AnnotationType)annType, (Element)elem);
        }
        return true;
    }

    @Override
    protected int getCursorPosition(String proposalString) {
        if (this.addPrefix) {
            return proposalString.length() - 1;
        }
        return proposalString.length();
    }

    private Element getElementForBoundNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Part) {
            return ((Part)node).getName().resolveType();
        }
        if (node instanceof NestedFunction) {
            return ((NestedFunction)node).getName().resolveMember();
        }
        if (node instanceof Constructor) {
            return ((Constructor)node).getBinding();
        }
        if (node instanceof StructureItem) {
            return ((StructureItem)node).getName().resolveMember();
        }
        if (node instanceof ClassDataDeclaration) {
            return ((Name)((ClassDataDeclaration)node).getNames().get(0)).resolveMember();
        }
        if (node instanceof FunctionDataDeclaration) {
            return ((Name)((FunctionDataDeclaration)node).getNames().get(0)).resolveMember();
        }
        if (node instanceof EnumerationField) {
            return ((EnumerationField)node).getName().resolveMember();
        }
        return this.getElementForBoundNode(node.getParent());
    }

    private ProjectEnvironment getEnv() {
        IFileEditorInput editorInput;
        IProject project;
        if (this.env == null && (project = (editorInput = (IFileEditorInput)this.editor.getEditorInput()).getFile().getProject()) != null) {
            this.env = ProjectEnvironmentManager.getInstance().getProjectEnvironment(project);
            Environment.pushEnv((IEnvironment)this.env.getIREnvironment());
            this.env.initIREnvironments();
        }
        return this.env;
    }

    @Override
    protected List createProposals(List parts, boolean quoted) {
        try {
            List list = super.createProposals(parts, quoted);
            return list;
        }
        finally {
            if (this.env != null) {
                Environment.popEnv();
            }
        }
    }
}

