/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDeploymentDescriptorEditor;
import org.eclipse.edt.ide.ui.internal.deployment.ui.IEGLDDContributionToolbarProvider;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class EGLDDBaseFormPage
extends FormPage {
    private final Action[] actions = this.getToolbarActionContributions();
    private final Action helpAction = new HelpAction(this.getHelpID());
    public static final int DEFAULT_COLUMN_WIDTH = 70;

    public EGLDDBaseFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        IToolBarManager toolbar = form.getToolBarManager();
        if (this.actions != null) {
            int i = 0;
            while (i < this.actions.length) {
                toolbar.add((IAction)this.actions[i]);
                ++i;
            }
        }
        toolbar.add((IAction)this.helpAction);
        form.updateToolBar();
        FormToolkit toolkit = managedForm.getToolkit();
        if (toolkit != null) {
            toolkit.decorateFormHeading(form.getForm());
        }
    }

    private Action[] getToolbarActionContributions() {
        ArrayList<Action> allActions = new ArrayList<Action>();
        IEGLDDContributionToolbarProvider[] providers = EGLDeploymentDescriptorEditor.getToolbarProviders();
        int i = 0;
        while (i < providers.length) {
            Action[] actions = providers[i].getActions((EGLDeploymentDescriptorEditor)this.getEditor());
            if (actions != null) {
                int j = 0;
                while (j < actions.length) {
                    allActions.add(actions[j]);
                    ++j;
                }
            }
            ++i;
        }
        int size = allActions.size();
        if (size == 0) {
            return null;
        }
        return allActions.toArray(new Action[size]);
    }

    public static void updateTableViewerAfterRemove(int selectionIndex, TableViewer viewer, Button removeBtn) {
        viewer.refresh();
        int itemCnts = viewer.getTable().getItemCount();
        if (selectionIndex >= itemCnts) {
            selectionIndex = itemCnts - 1;
        }
        if (itemCnts > 0) {
            Object item = viewer.getElementAt(selectionIndex);
            StructuredSelection selection = new StructuredSelection(item);
            viewer.setSelection((ISelection)selection);
        } else {
            removeBtn.setEnabled(false);
        }
    }

    public static void updateTableViewerAfterAdd(TableViewer tableviewer, Object newElement) {
        tableviewer.refresh();
        StructuredSelection selection = new StructuredSelection(newElement);
        tableviewer.setSelection((ISelection)selection);
    }

    protected void openWizard(IWizard wizard) {
        WizardDialog dialog = new WizardDialog(this.getSite().getShell(), wizard);
        dialog.create();
        dialog.open();
    }

    public static Composite createNonExpandableSection(ScrolledForm form, FormToolkit toolkit, String title, String description, int gridLayoutColumns) {
        Section section = toolkit.createSection(form.getBody(), 384);
        Composite client = EGLDDBaseFormPage.createSectionLayout(toolkit, title, description, gridLayoutColumns, gridLayoutColumns, 768, section);
        return client;
    }

    public static Composite createNonExpandableSectionWithoutDesc(ScrolledForm form, FormToolkit toolkit, String title, int gridLayoutColumns) {
        Section section = toolkit.createSection(form.getBody(), 256);
        Composite client = EGLDDBaseFormPage.createSectionLayout(toolkit, title, null, gridLayoutColumns, gridLayoutColumns, 768, section);
        return client;
    }

    private static Composite createSectionLayout(FormToolkit toolkit, String title, String description, int gridLayoutColumns, int horizontalSpan, int gridDataStyle, Section section) {
        GridData gd = new GridData(gridDataStyle);
        gd.horizontalSpan = horizontalSpan;
        section.setLayoutData((Object)gd);
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        layout.numColumns = gridLayoutColumns;
        client.setLayout((Layout)layout);
        section.setText(title);
        section.setDescription(description);
        gd = new GridData(1808);
        gd.widthHint = 600;
        gd.heightHint = 300;
        client.setLayoutData((Object)gd);
        section.setClient((Control)client);
        return client;
    }

    public static Composite createExpandableSection(final ScrolledForm form, FormToolkit toolkit, String title, String description, int gridLayoutColumns, int horizontalSpan, boolean isExpanded) {
        Section section = toolkit.createSection(form.getBody(), 0x182 | (isExpanded ? 64 : 0));
        Composite client = EGLDDBaseFormPage.createSectionLayout(toolkit, title, description, gridLayoutColumns, horizontalSpan, 1808, section);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
            }
        });
        return client;
    }

    protected EGLDeploymentRoot getModelRoot() {
        EGLDeploymentDescriptorEditor EGLDDEditor = (EGLDeploymentDescriptorEditor)this.getEditor();
        return EGLDDEditor.getModelRoot();
    }

    public static int createTableColumn(Table t, TableLayout tableLayout, int maxWidth, String colLabel, int colIndex) {
        TableColumn col = new TableColumn(t, 16384, colIndex);
        col.setText(colLabel);
        col.pack();
        int tableColWidth = Math.max(70, col.getWidth());
        maxWidth = Math.max(maxWidth, tableColWidth);
        ColumnWeightData colData = new ColumnWeightData(tableColWidth, tableColWidth, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        return maxWidth;
    }

    public static void selectFristElementInTable(TableViewer tableViewer) {
        ISelection currSel = tableViewer.getSelection();
        if (currSel.isEmpty()) {
            int itemCnts = tableViewer.getTable().getItemCount();
            if (itemCnts > 0) {
                Object item = tableViewer.getElementAt(0);
                StructuredSelection firstSel = new StructuredSelection(item);
                tableViewer.setSelection((ISelection)firstSel);
            }
        } else {
            tableViewer.setSelection(currSel);
        }
    }

    protected IProject getEditorProject() {
        return ((EGLDeploymentDescriptorEditor)this.getEditor()).getProject();
    }

    protected abstract String getHelpID();

    private static class HelpAction
    extends Action {
        private final String helpID;

        public HelpAction(String helpID) {
            super(SOAMessages.DDEditorToolbarHelpText, PluginImages.DESC_TOOL_HELP);
            this.setToolTipText(SOAMessages.DDEditorToolbarHelpTooltip);
            this.helpID = helpID;
        }

        public void run() {
            if (this.helpID != null) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpID);
            }
        }
    }
}

