/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.packageexplorer.EGLElementContentProvider;
import org.eclipse.edt.ide.ui.internal.packageexplorer.EGLElementLabelProvider;
import org.eclipse.edt.ide.ui.internal.packageexplorer.EGLElementSorter;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.TypedElementSelectionValidator;
import org.eclipse.edt.ide.ui.internal.wizards.TypedViewerFilter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class MoveDialog
extends ElementTreeSelectionDialog {
    Class[] acceptedClasses;
    TypedElementSelectionValidator validator;
    ViewerFilter filter;
    IEGLElement finitElement;

    public MoveDialog(Shell parent, IEGLElement initElement) {
        super(parent, (ILabelProvider)new EGLElementLabelProvider(EGLElementLabelProvider.SHOW_DEFAULT), (ITreeContentProvider)new EGLElementContentProvider());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IUIHelpConstants.EGL_MOVE_DIALOG);
        this.finitElement = initElement;
        this.initAcceptedClasses(initElement);
        this.initFiltersValidators();
        this.setValidator(this.validator);
        this.setSorter(new EGLElementSorter());
        this.setTitle(NewWizardMessages.EGLMoveDialogTitle);
        this.setMessage(String.valueOf(NewWizardMessages.EGLMoveDialogMessage) + "  ");
        this.addFilter(this.filter);
        this.setInput(EGLCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        this.setInitialSelection(initElement.getParent());
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = super.createTreeViewer(parent);
        ArrayList<IEGLElement> elemlist = new ArrayList<IEGLElement>();
        IEGLElement elem = this.finitElement.getParent();
        while (!(elem instanceof IEGLModel)) {
            elemlist.add(0, elem);
            elem = elem.getParent();
        }
        viewer.setExpandedElements(elemlist.toArray());
        return viewer;
    }

    private void initAcceptedClasses(IEGLElement element) {
        if (element instanceof IPackageFragmentRoot) {
            this.acceptedClasses = new Class[]{IEGLProject.class};
        } else if (element instanceof IPackageFragment) {
            this.acceptedClasses = new Class[]{IEGLProject.class, IPackageFragmentRoot.class};
        } else if (element instanceof IEGLFile) {
            this.acceptedClasses = new Class[]{IEGLProject.class, IPackageFragmentRoot.class, IPackageFragment.class, IFolder.class};
        }
    }

    private void initFiltersValidators() {
        this.validator = new TypedElementSelectionValidator(this.acceptedClasses, false){

            @Override
            public IStatus validate(Object[] selection) {
                int nSelected = selection.length;
                String pluginId = EDTUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
                if (nSelected == 0) {
                    return new Status(4, pluginId, 4, UINlsStrings.MoveDialog_validateMsg_NoSelection, null);
                }
                if (nSelected > 1) {
                    return new Status(4, pluginId, 4, UINlsStrings.MoveDialog_validateMsg_MultiDestination, null);
                }
                Object element = selection[0];
                try {
                    IPath path;
                    IEGLProject eproject;
                    IEGLElement selectedElem;
                    if (element instanceof IEGLElement && (selectedElem = (IEGLElement)element).equals(MoveDialog.this.finitElement.getParent())) {
                        return new Status(4, pluginId, 4, UINlsStrings.MoveDialog_validateMsg_SameParent, null);
                    }
                    if (element instanceof IEGLProject && (MoveDialog.this.finitElement instanceof IEGLFile || MoveDialog.this.finitElement instanceof IPackageFragment) && (eproject = (IEGLProject)element).findPackageFragmentRoot(path = eproject.getProject().getFullPath()) == null) {
                        return new Status(4, pluginId, 4, "", null);
                    }
                    if (element instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)element).getKind() != 1) {
                        return new Status(4, pluginId, 4, "", null);
                    }
                    return super.validate(selection);
                }
                catch (EGLModelException e) {
                    EGLLogger.log((Object)this, e);
                    return new Status(4, pluginId, 4, "", null);
                }
            }
        };
        this.filter = new TypedViewerFilter(this.acceptedClasses, null){

            @Override
            public boolean select(Viewer viewer, Object parent, Object element) {
                return super.select(viewer, parent, element);
            }
        };
    }
}

