/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.StringTokenizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public abstract class AbstractAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    protected boolean appendTab(IDocument d, DocumentCommand c) throws BadLocationException {
        return false;
    }

    protected void autoIndentAfterNewLine(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            IRegion info = d.getLineInformationOfOffset(p);
            int start = info.getOffset();
            int end = this.findEndOfWhiteSpace(d, start, c.offset);
            StringBuffer buf = new StringBuffer(c.text);
            if (end > start) {
                buf.append(d.get(start, end - start));
            }
            if (this.appendTab(d, c)) {
                buf.append('\t');
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    protected boolean endsWithDelimiter(IDocument d, String txt) {
        String[] delimiters = d.getLegalLineDelimiters();
        int i = 0;
        while (i < delimiters.length) {
            if (txt.endsWith(delimiters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean endsWith(IDocument d, DocumentCommand c, String value) {
        try {
            int length = value.length();
            String value1 = value.substring(0, length - 1);
            String value2 = value.substring(length - 1, length);
            return c.offset > length && this.isMatch(d, c, value1) && c.text.equalsIgnoreCase(value2);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return false;
        }
    }

    protected String getIndentOfLine(IDocument d, int line) throws BadLocationException {
        if (line > -1) {
            int end;
            int start = d.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(d, start, end = start + d.getLineLength(line) - 1);
            int length = whiteend - start - 1;
            if (length < 0) {
                return "";
            }
            return d.get(start, whiteend - start - 1);
        }
        return "";
    }

    protected boolean isMatch(IDocument d, DocumentCommand c, String keyword) throws BadLocationException {
        return d.get(c.offset - keyword.length(), keyword.length()).equalsIgnoreCase(keyword);
    }

    protected void smartInsertAfterBlock(IDocument d, DocumentCommand c, int length) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            int start = d.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(d, start, c.offset);
            int whiteLength = whiteend - start;
            if (line > 0) {
                int previousStart = d.getLineOffset(line - 1);
                int previousWhiteend = this.findEndOfWhiteSpace(d, previousStart, c.offset);
                int previousWhiteLength = previousWhiteend - previousStart;
                if (whiteend + length == c.offset) {
                    boolean previousLineIsEndStart = this.previousLineIsEndStart(d, previousWhiteend);
                    if (whiteLength == previousWhiteLength && !previousLineIsEndStart || whiteLength == previousWhiteLength + 1 && previousLineIsEndStart) {
                        StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(d, line));
                        replaceText.append(d.get(whiteend, c.offset - whiteend));
                        replaceText.append(c.text);
                        c.length = c.offset - start;
                        c.offset = start;
                        c.text = replaceText.toString();
                    }
                }
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    private boolean previousLineIsEndStart(IDocument document, int previousWhiteend) {
        try {
            String restOfDocument = document.get(previousWhiteend, document.getLength() - previousWhiteend);
            UnicodeSet delimiters = new UnicodeSet("[ \t\n\r\f(]", false);
            StringTokenizer tokenizer = new StringTokenizer(restOfDocument, delimiters);
            String token = tokenizer.nextToken();
            if (token.equalsIgnoreCase("dataItem") || token.equalsIgnoreCase("dataTable") || token.equalsIgnoreCase("form") || token.equalsIgnoreCase("formGroup") || token.equalsIgnoreCase("private") || token.equalsIgnoreCase("function") || token.equalsIgnoreCase("handler") || token.equalsIgnoreCase("interface") || token.equalsIgnoreCase("library") || token.equalsIgnoreCase("program") || token.equalsIgnoreCase("record") || token.equalsIgnoreCase("service") || token.equalsIgnoreCase("delegate") || token.equalsIgnoreCase("externalType") || token.equalsIgnoreCase("case") || token.equalsIgnoreCase("else") || token.equalsIgnoreCase("for") || token.equalsIgnoreCase("forEach") || token.equalsIgnoreCase("if") || token.equalsIgnoreCase("onException") || token.equalsIgnoreCase("openUI") || token.equalsIgnoreCase("try") || token.equalsIgnoreCase("while")) {
                return true;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return false;
    }
}

