/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.ide.ui.internal.editor.AbstractEGLTextHover;
import org.eclipse.edt.ide.ui.internal.editor.HoverUtils;
import org.eclipse.edt.ide.ui.internal.editor.IAnnotation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;

public class EGLTextHover
extends AbstractEGLTextHover {
    protected List getEGLAnnotationsForPosition(ISourceViewer viewer, int pos) {
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<IAnnotation> exact = new ArrayList<IAnnotation>();
        ArrayList eglAnnotations = new ArrayList();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            eglAnnotations.add(e.next());
        }
        HoverUtils.sort(eglAnnotations);
        HashMap messagesAtPosition = new HashMap();
        for (Object o : eglAnnotations) {
            IAnnotation a;
            Position position;
            if (!(o instanceof IAnnotation) || (position = model.getPosition((Annotation)(a = (IAnnotation)o))) == null || a.getText() == null || HoverUtils.isDuplicateAnnotation(messagesAtPosition, position, a) || pos < position.offset || pos > position.offset + position.length) continue;
            exact.add(a);
        }
        return exact;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (hoverRegion != null) {
            try {
                if (hoverRegion.getLength() > -1) {
                    List annotationsForPosition = this.getEGLAnnotationsForPosition((ISourceViewer)textViewer, hoverRegion.getOffset());
                    if (annotationsForPosition != null && !annotationsForPosition.isEmpty()) {
                        if (annotationsForPosition.size() == 1) {
                            return HoverUtils.formatSingleMessage(((IAnnotation)annotationsForPosition.get(0)).getText());
                        }
                        ArrayList<String> messages = new ArrayList<String>();
                        for (IAnnotation eglAnnotation : annotationsForPosition) {
                            String message = eglAnnotation.getText();
                            if (message == null || message.trim().length() <= 0) continue;
                            messages.add(message.trim());
                        }
                        return HoverUtils.formatMultipleMessages(messages);
                    }
                    IDocument document = textViewer.getDocument();
                    if (document != null) {
                        return document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return "empty selection";
    }
}

