/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.edt.ide.ui.internal.editor.CodeScanner;
import org.eclipse.edt.ide.ui.internal.editor.MultilineCommentsScanner;
import org.eclipse.edt.ide.ui.internal.editor.PartitionScanner;
import org.eclipse.edt.ide.ui.internal.editor.Partitioner;
import org.eclipse.edt.ide.ui.internal.editor.SQLCodeScanner;
import org.eclipse.edt.ide.ui.internal.editor.SinglelineCommentScanner;
import org.eclipse.edt.ide.ui.internal.preferences.ColorProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class TextTools {
    private ColorProvider fgColorProvider = null;
    private MultilineCommentsScanner fgMultilineCommentsScanner = null;
    private SinglelineCommentScanner fgSinglelineCommentScanner = null;
    private CodeScanner fgCodeScanner = null;
    private SQLCodeScanner fgSQLCodeScanner = null;
    private PartitionScanner fgPartitionScanner = null;
    private PreferenceListener fPreferenceListener = null;
    private IPreferenceStore preferenceStore = null;

    public TextTools(IPreferenceStore store) {
        this.preferenceStore = store;
        this.fgColorProvider = new ColorProvider(this.preferenceStore);
        this.fgMultilineCommentsScanner = new MultilineCommentsScanner(this.fgColorProvider);
        this.fgSinglelineCommentScanner = new SinglelineCommentScanner(this.fgColorProvider);
        this.fgCodeScanner = new CodeScanner(this.fgColorProvider);
        this.fgSQLCodeScanner = new SQLCodeScanner(this.fgColorProvider);
        this.fgPartitionScanner = new PartitionScanner();
        this.fPreferenceListener = new PreferenceListener();
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
    }

    public ITokenScanner getEGLCodeScanner() {
        return this.fgCodeScanner;
    }

    public ITokenScanner getEGLMultilineCommentScanner() {
        return this.fgMultilineCommentsScanner;
    }

    public ITokenScanner getEGLSinglelineCommentScanner() {
        return this.fgSinglelineCommentScanner;
    }

    public ITokenScanner getEGLSQLCodeScanner() {
        return this.fgSQLCodeScanner;
    }

    public ColorProvider getEGLColorProvider() {
        return this.fgColorProvider;
    }

    public PartitionScanner getEGLPartitionScanner() {
        return this.fgPartitionScanner;
    }

    private void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fgCodeScanner.affectsBehavior(event)) {
            this.fgMultilineCommentsScanner.setRules();
            this.fgSinglelineCommentScanner.setRules();
            this.fgCodeScanner.setRules();
            this.fgSQLCodeScanner.setRules();
        }
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.fgCodeScanner.affectsBehavior(event);
    }

    public void dispose() {
        this.fgColorProvider.dispose();
        this.fgColorProvider = null;
        this.fgCodeScanner = null;
        this.fgMultilineCommentsScanner = null;
        this.fgSinglelineCommentScanner = null;
        this.fgSQLCodeScanner = null;
        this.fgPartitionScanner = null;
        if (this.fPreferenceListener != null) {
            if (this.preferenceStore != null) {
                this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
                this.preferenceStore = null;
            }
            this.fPreferenceListener = null;
        }
    }

    public void setupEGLDocumentPartitioner(IDocument document) {
        this.setupEGLDocumentPartitioner(document, "__dftl_partitioning");
    }

    public void setupEGLDocumentPartitioner(IDocument document, String partitioning) {
        String[] types = new String[]{"__dftl_partition_content_type", "__egl_multiline_comment", "__egl_singleline_comment", "__egl_sql", "__egl_sqlCondition"};
        Partitioner partitioner = new Partitioner((IPartitionTokenScanner)this.fgPartitionScanner, types);
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            extension3.setDocumentPartitioner(partitioning, (IDocumentPartitioner)partitioner);
        } else {
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        partitioner.connect(document);
    }

    private class PreferenceListener
    implements IPropertyChangeListener,
    Preferences.IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            TextTools.this.adaptToPreferenceChange(event);
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            TextTools.this.adaptToPreferenceChange(new PropertyChangeEvent(event.getSource(), event.getProperty(), event.getOldValue(), event.getNewValue()));
        }
    }
}

