/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.externaltype.conversion.javatype;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.gen.generator.eglsource.EglSourceContext;
import org.eclipse.edt.ide.ui.internal.externaltype.util.ReflectionUtil;
import org.eclipse.edt.mof.codegen.api.AbstractTemplate;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;

public class JavaTypeMethodTemplate
extends AbstractTemplate {
    public void genMethod(Method javaMethod, EglSourceContext ctx, TabbedWriter out) {
        if (Modifier.isStatic(javaMethod.getModifiers())) {
            out.print("   static function ");
        } else {
            out.print("   function ");
        }
        String methodName = javaMethod.getName();
        boolean isEGLKeyWord = EGLNameValidator.isKeyword((String)methodName);
        boolean isStartWithEze = methodName.toLowerCase().startsWith("eze");
        if (isEGLKeyWord || isStartWithEze) {
            methodName = "_" + methodName;
        }
        out.print(String.valueOf(methodName) + "(");
        Class<?>[] parameterTypes = javaMethod.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            out.print("arg" + i + " " + ReflectionUtil.getEGLTypeName(parameterTypes[i]) + " " + "IN");
            if (i != parameterTypes.length - 1) {
                out.print(',');
            }
            ++i;
        }
        out.print(')');
        Class<?> returnedType = javaMethod.getReturnType();
        if (!"void".equals(returnedType.getSimpleName())) {
            out.print("  returns(" + ReflectionUtil.getEGLTypeName(returnedType) + ')');
        }
        if (isEGLKeyWord || isStartWithEze) {
            out.print("   {@ExternalName{\"" + javaMethod.getName() + "\"}");
            if (javaMethod.getExceptionTypes().length > 0) {
                out.print(",@Throws");
            }
            out.print("}");
        } else if (javaMethod.getExceptionTypes().length > 0) {
            out.print("{@Throws}");
        }
        out.println(';');
    }
}

