/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.formatting;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.core.ast.AccumulatingSyntaxErrorMessageRequestor;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.SyntaxError;
import org.eclipse.edt.ide.ui.internal.CodeFormatterUtil;
import org.eclipse.edt.ide.ui.internal.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class FormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();
    private OrganizeImportsOperation.SyntaxErrorHelper fSyntaxError = null;

    public void format() {
        block14: {
            super.format();
            IDocument document = (IDocument)this.fDocuments.removeFirst();
            TypedPosition partition = (TypedPosition)this.fPartitions.removeFirst();
            if (document != null && partition != null) {
                Map partitioners = null;
                try {
                    Map syntaxErrs;
                    AccumulatingSyntaxErrorMessageRequestor syntaxErrRequestor = new AccumulatingSyntaxErrorMessageRequestor();
                    TextEdit edit = CodeFormatterUtil.format(document, partition.getOffset(), partition.getLength(), this.getPreferences(), (ISyntaxErrorRequestor)syntaxErrRequestor);
                    if (edit != null) {
                        if (edit.getChildrenSize() > 20) {
                            partitioners = TextUtilities.removeDocumentPartitioners((IDocument)document);
                        }
                        edit.apply(document);
                    } else if (syntaxErrRequestor != null && !(syntaxErrs = syntaxErrRequestor.getSyntaxErrors()).isEmpty()) {
                        Set keys = syntaxErrs.keySet();
                        Iterator it = keys.iterator();
                        SyntaxError SyntaxErr = (SyntaxError)it.next();
                        String errmsg = (String)syntaxErrs.get(SyntaxErr);
                        this.fSyntaxError = new OrganizeImportsOperation.SyntaxErrorHelper(SyntaxErr, errmsg);
                    }
                }
                catch (MalformedTreeException exception) {
                    exception.printStackTrace();
                    if (partitioners != null) {
                        TextUtilities.addDocumentPartitioners((IDocument)document, partitioners);
                    }
                    break block14;
                }
                catch (BadLocationException exception) {
                    try {
                        exception.printStackTrace();
                        break block14;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (partitioners != null) {
                            TextUtilities.addDocumentPartitioners((IDocument)document, partitioners);
                        }
                    }
                }
                if (partitioners == null) break block14;
                TextUtilities.addDocumentPartitioners((IDocument)document, (Map)partitioners);
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fPartitions.addLast(context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
    }

    public OrganizeImportsOperation.SyntaxErrorHelper get1stSyntaxErrorMsg() {
        return this.fSyntaxError;
    }
}

