/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.formatting.ui;

import com.ibm.icu.util.StringTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Category;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Control;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Controls;
import org.eclipse.edt.ide.ui.internal.formatting.profile.DefaultProfile;
import org.eclipse.edt.ide.ui.internal.formatting.profile.EGLFormatProfileRoot;
import org.eclipse.edt.ide.ui.internal.formatting.profile.FormatProfiles;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Group;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Preference;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Profile;
import org.eclipse.edt.ide.ui.internal.formatting.profile.ProfileFactory;
import org.eclipse.edt.ide.ui.internal.formatting.profile.ReferenceControl;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Setting;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class FormatProfileRootHelper {
    private static ResourceBundle bundleForConstructedKeys = ResourceBundle.getBundle("org.eclipse.edt.ide.ui.internal.formatting.ui.ConstructedFormattingMessages");
    private static final String PROFILE_VERSION = "1.0";
    public static final String DELIMITER_COMMA = ",";
    public static final String NLSKEY_LEADINGCHAR = "%";

    public static EGLFormatProfileRoot getEGLFormatProfileModel(IPath formatProfile) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        return FormatProfileRootHelper.getEGLFormatProfileModel(formatProfile, (ResourceSet)resourceSet);
    }

    private static EGLFormatProfileRoot getEGLFormatProfileModel(IPath formatProfile, ResourceSet resourceSet) {
        URI uri = null;
        if (formatProfile.toOSString().startsWith("jar:")) {
            String path = formatProfile.toOSString();
            path = path.replaceAll("\\\\", "/");
            uri = URI.createURI((String)path);
        } else {
            uri = URI.createFileURI((String)formatProfile.toOSString());
        }
        Resource resource = resourceSet.getResource(uri, true);
        return (EGLFormatProfileRoot)resource.getContents().get(0);
    }

    public static EGLFormatProfileRoot createNewEGLFormatProfileModel(IPath formatProfile) {
        String encodingName = EDTUIPlugin.getDefault().getPreferenceStore().getString("outputCodeset");
        return FormatProfileRootHelper.createNewEGLFormatProfileModel(formatProfile, encodingName);
    }

    private static EGLFormatProfileRoot createNewEGLFormatProfileModel(IPath formatProfile, String encoding) {
        EGLFormatProfileRoot docRoot = ProfileFactory.eINSTANCE.createEGLFormatProfileRoot();
        FormatProfiles root = ProfileFactory.eINSTANCE.createFormatProfiles();
        root.setVersion(PROFILE_VERSION);
        docRoot.setFormatProfiles(root);
        try {
            URI uri = URI.createFileURI((String)formatProfile.toOSString());
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(uri);
            resource.getContents().add((Object)docRoot);
            if (encoding != null && encoding.length() > 0) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("ENCODING", encoding);
                resource.save(options);
            } else {
                resource.save(null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            docRoot = null;
        }
        return docRoot;
    }

    public static void saveEGLFormatProfile(IPath formatFilePath, EGLFormatProfileRoot docRoot) {
        try {
            FormatProfileRootHelper.persisEGLFormatProfile(formatFilePath, docRoot);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void persisEGLFormatProfile(IPath formatFilePath, EGLFormatProfileRoot docRoot) throws IOException {
        Resource savedResource;
        URI uri = URI.createFileURI((String)formatFilePath.toOSString());
        Resource resource = savedResource = docRoot.eResource();
        HashMap<String, String> options = Collections.EMPTY_MAP;
        if (!savedResource.getURI().equals((Object)uri)) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resource = resourceSet.createResource(uri);
            String encoding = EDTUIPlugin.getDefault().getPreferenceStore().getString("outputCodeset");
            if (encoding != null && encoding.length() > 0) {
                options = new HashMap<String, String>();
                options.put("ENCODING", encoding);
            }
        }
        resource.getContents().add((Object)docRoot);
        resource.save((Map)options);
    }

    public static Profile findProfileByName(String profileName, FormatProfiles formatprofiles) {
        EList profiles = formatprofiles.getProfile();
        for (Profile profile : profiles) {
            if (!profileName.equals(profile.getName())) continue;
            return profile;
        }
        return null;
    }

    public static Control getReferencedControl(DefaultProfile defaultProfile, ReferenceControl refControl) {
        String refName = refControl.getRef();
        return FormatProfileRootHelper.getControlByName(defaultProfile, refName);
    }

    private static Control getControlByName(DefaultProfile defaultProfile, String controlName) {
        Controls controls = defaultProfile.getControls();
        EList cntrls = controls.getControl();
        for (Control control : cntrls) {
            String controlElemName = control.getName();
            if (controlElemName == null || !controlElemName.equals(controlName)) continue;
            return control;
        }
        return null;
    }

    public static String[] parseChoices(String strChoices) {
        return FormatProfileRootHelper.parseTokenizedString(strChoices, DELIMITER_COMMA);
    }

    public static String[] parseTokenizedString(String string2BeParsed, String demiliter) {
        StringTokenizer tokenizer = new StringTokenizer(string2BeParsed, demiliter);
        String[] choices = new String[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            choices[index] = tokenizer.nextToken();
            ++index;
        }
        return choices;
    }

    private static Category getCategoryByID(DefaultProfile defaultProfile, String categoryId) {
        EList cats = defaultProfile.getCategory();
        for (Category cat : cats) {
            if (!categoryId.equals(cat.getId())) continue;
            return cat;
        }
        return null;
    }

    public static Preference getPreferenceByID(DefaultProfile defaultProfile, String categoryId, String prefId) {
        Category cat = FormatProfileRootHelper.getCategoryByID(defaultProfile, categoryId);
        if (cat != null) {
            EList groups = cat.getGroup();
            for (Group group : groups) {
                EList prefs = group.getPref();
                for (Preference pref : prefs) {
                    if (!prefId.equals(pref.getId())) continue;
                    return pref;
                }
            }
        }
        return null;
    }

    public static Setting getPreferenceSettingByID(Profile profile, String categoryId, String prefId) {
        EList settings = profile.getSetting();
        if (settings != null) {
            for (Setting setting : settings) {
                if (!categoryId.equals(setting.getCategory()) || !prefId.equals(setting.getPref())) continue;
                return setting;
            }
        }
        return null;
    }

    public static List getProfilesWhoseBaseIs(String baseName, FormatProfiles profilesroot) {
        ArrayList<Profile> results = new ArrayList<Profile>();
        EList profiles = profilesroot.getProfile();
        for (Profile profile : profiles) {
            String profileBase = profile.getBase();
            if (profileBase == null || !profileBase.equals(baseName)) continue;
            results.add(profile);
        }
        return results;
    }

    public static String getFormattingProfileNLSString(String nlsKey, String delimiter) {
        String[] nlsKeys = FormatProfileRootHelper.parseTokenizedString(nlsKey, delimiter);
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < nlsKeys.length) {
            if (i > 0) {
                str.append(delimiter);
            }
            str.append(FormatProfileRootHelper.getFormattingProfileNLSString(nlsKeys[i]));
            ++i;
        }
        return str.toString();
    }

    public static String getFormattingProfileNLSString(String nlsKey) {
        if (nlsKey.startsWith(NLSKEY_LEADINGCHAR)) {
            nlsKey = nlsKey.substring(nlsKey.indexOf(NLSKEY_LEADINGCHAR) + 1);
        }
        if (nlsKey.length() > 0) {
            try {
                return bundleForConstructedKeys.getString(nlsKey);
            }
            catch (MissingResourceException e) {
                e.printStackTrace();
                return nlsKey;
            }
        }
        return nlsKey;
    }
}

