/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.formatting.ui;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.formatting.CodeFormatterConstants;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Category;
import org.eclipse.edt.ide.ui.internal.formatting.profile.DefaultProfile;
import org.eclipse.edt.ide.ui.internal.formatting.profile.EGLFormatProfileRoot;
import org.eclipse.edt.ide.ui.internal.formatting.profile.FormatProfiles;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Group;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Preference;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Profile;
import org.eclipse.edt.ide.ui.internal.formatting.profile.ProfileFactory;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Setting;
import org.eclipse.edt.ide.ui.internal.formatting.ui.FormatProfileRootHelper;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.Bundle;

public class ProfileManager
extends Observable {
    public static final String PROFILE_BUILDIN_PATH = "builtInPreference/format_builtin.profile";
    private static final String PROFILE_WORKSPACE_PATH = "format.profile";
    private static final String PROFILE_BUILDIN_DISPLAY_SUFFIX = NewWizardMessages.builtIn;
    private EGLFormatProfileRoot fBuildInProfileRoot = null;
    private EGLFormatProfileRoot fCustomWSProfileRoot = null;
    private Map fCurrentAllPreferenceSettingMap = new Hashtable();
    private static ProfileManager INSTANCE;
    public static final int SELECTION_CHANGED_EVENT = 1;
    public static final int PROFILE_DELETED_EVENT = 2;
    public static final int PROFILE_RENAMED_EVENT = 3;
    public static final int PROFILE_CREATED_EVENT = 4;
    public static final int SETTINGS_CHANGED_EVENT = 5;

    private ProfileManager() {
    }

    public static ProfileManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProfileManager();
        }
        return INSTANCE;
    }

    public Map getCurrentPreferenceSettingMap() {
        if (this.fCurrentAllPreferenceSettingMap.isEmpty()) {
            this.loadCurrentAllPreferenceSettingMap();
        }
        return this.fCurrentAllPreferenceSettingMap;
    }

    public EGLFormatProfileRoot getBuildInFormatProfileRoot() {
        IPath buildInPath;
        if (this.fBuildInProfileRoot == null && (buildInPath = ProfileManager.getBuildInPreferenceProfilePath()) != null) {
            this.fBuildInProfileRoot = FormatProfileRootHelper.getEGLFormatProfileModel(buildInPath);
        }
        return this.fBuildInProfileRoot;
    }

    public EGLFormatProfileRoot getCustomWorkspaceFormatProfileRoot(boolean createNew) {
        File wsPrefProfile;
        IPath wsPrefProfilePath = ProfileManager.getWorkspacePreferenceProfilePath();
        if (this.fCustomWSProfileRoot == null && (wsPrefProfile = wsPrefProfilePath.toFile()).exists()) {
            this.fCustomWSProfileRoot = FormatProfileRootHelper.getEGLFormatProfileModel(wsPrefProfilePath);
        }
        if (this.fCustomWSProfileRoot == null && createNew) {
            this.fCustomWSProfileRoot = FormatProfileRootHelper.createNewEGLFormatProfileModel(wsPrefProfilePath);
        }
        return this.fCustomWSProfileRoot;
    }

    private static IPath getWorkspacePreferenceProfilePath() {
        return EDTUIPlugin.getDefault().getStateLocation().append(PROFILE_WORKSPACE_PATH);
    }

    public void saveCustomWorkspaceFormatProfile(boolean clearCachedFormatProfileEMFModel) {
        EGLFormatProfileRoot root = this.getCustomWorkspaceFormatProfileRoot(true);
        if (root != null) {
            FormatProfileRootHelper.saveEGLFormatProfile(ProfileManager.getWorkspacePreferenceProfilePath(), root);
        }
        this.clearCachedModel(clearCachedFormatProfileEMFModel);
    }

    public void clearCachedModel(boolean clearCachedFormatProfileEMFModel) {
        if (clearCachedFormatProfileEMFModel) {
            this.fBuildInProfileRoot = null;
            this.fCustomWSProfileRoot = null;
            this.fCurrentAllPreferenceSettingMap.clear();
        }
    }

    private static IPath getBuildInPreferenceProfilePath() {
        Bundle eglResourcesBundle = Platform.getBundle((String)"org.eclipse.edt.ide.ui");
        URL url = FileLocator.find((Bundle)eglResourcesBundle, (IPath)new Path(PROFILE_BUILDIN_PATH), null);
        try {
            url = FileLocator.resolve((URL)url);
            String pathStr = null;
            pathStr = "file".equals(url.getProtocol()) ? url.getFile() : url.toString();
            if (url != null) {
                Path path = new Path(pathStr);
                return path;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getSelectedProfileDisplayName() {
        return this.getProfileName(this.getSelectedProfile(), true);
    }

    public String getProfileDisplayName(EObject profileOrDefautlProfile) {
        return this.getProfileName(profileOrDefautlProfile, true);
    }

    public boolean isSelectedProfileBuildIn() {
        EObject obj = this.getSelectedProfile();
        return this.isProfileBuildIn(obj);
    }

    public boolean isProfileBuildIn(EObject obj) {
        if (obj instanceof DefaultProfile) {
            return true;
        }
        if (obj instanceof Profile) {
            return ((Profile)obj).isIsBuildIn();
        }
        return false;
    }

    public EObject getSelectedProfile() {
        FormatProfiles profilesroot;
        String selectedProfileName = null;
        EObject selProfile = null;
        EGLFormatProfileRoot customWSProfileRoot = this.getCustomWorkspaceFormatProfileRoot(false);
        if (customWSProfileRoot != null && (selectedProfileName = (profilesroot = customWSProfileRoot.getFormatProfiles()).getSelection()) != null && selectedProfileName.length() > 0) {
            selProfile = this.getProfileByName(selectedProfileName, true);
        }
        if (selProfile == null) {
            selProfile = this.getProfileByName(null, true);
        }
        return selProfile;
    }

    public EObject getProfileByName(String profileName, boolean returnDefaultProfileIfNotFound) {
        EGLFormatProfileRoot buildInProfileRoot;
        Object selProfile = null;
        EGLFormatProfileRoot customWSProfileRoot = this.getCustomWorkspaceFormatProfileRoot(false);
        if (customWSProfileRoot != null) {
            FormatProfiles profilesroot = customWSProfileRoot.getFormatProfiles();
            if (profileName != null && profileName.length() > 0) {
                selProfile = FormatProfileRootHelper.findProfileByName(profileName, profilesroot);
            }
        }
        if ((customWSProfileRoot == null || selProfile == null) && (buildInProfileRoot = this.getBuildInFormatProfileRoot()) != null) {
            FormatProfiles buildInProfilesRoot = buildInProfileRoot.getFormatProfiles();
            if (profileName != null && profileName.length() > 0) {
                selProfile = FormatProfileRootHelper.findProfileByName(profileName, buildInProfilesRoot);
            }
            if (selProfile == null) {
                DefaultProfile defaultProfile = buildInProfilesRoot.getDefaultProfile();
                if (returnDefaultProfileIfNotFound || profileName.equals(defaultProfile.getName())) {
                    selProfile = defaultProfile;
                }
            }
        }
        return selProfile;
    }

    public boolean containsProfile(String profileName) {
        return this.getProfileByName(profileName, false) != null;
    }

    public void setSelectedProfile(int index) {
        List allProfiles = this.getAllProfiles();
        Object obj = allProfiles.get(index);
        this.setSelectedProfile(obj);
    }

    public void setSelectedProfile(Object obj) {
        String selName = "";
        if (obj instanceof DefaultProfile) {
            selName = ((DefaultProfile)obj).getName();
        } else if (obj instanceof Profile) {
            selName = ((Profile)obj).getName();
        }
        EGLFormatProfileRoot profileRoot = this.getCustomWorkspaceFormatProfileRoot(true);
        if (profileRoot != null) {
            FormatProfiles profilesroot = profileRoot.getFormatProfiles();
            profilesroot.setSelection(selName);
            this.updateCurrentAllPreferenceSettingMap((EObject)obj);
            this.notifyObservers(1);
        }
    }

    private void loadCurrentAllPreferenceSettingMap() {
        EGLFormatProfileRoot buildinformatRoot = this.getBuildInFormatProfileRoot();
        if (buildinformatRoot != null) {
            FormatProfiles profilesroot = buildinformatRoot.getFormatProfiles();
            DefaultProfile defaultprofile = profilesroot.getDefaultProfile();
            EList catList = defaultprofile.getCategory();
            for (Category category : catList) {
                String categoryID = category.getId();
                EList groupList = category.getGroup();
                for (Group group : groupList) {
                    EList prefList = group.getPref();
                    for (Preference pref : prefList) {
                        String prefId = pref.getId();
                        this.updateCurrentAllPreferenceSettingMap(categoryID, prefId, this.getSelectedProfile());
                    }
                }
            }
        }
    }

    private void updateCurrentAllPreferenceSettingMap(EObject profileOrDefaultProfile) {
        if (this.fCurrentAllPreferenceSettingMap.isEmpty()) {
            this.loadCurrentAllPreferenceSettingMap();
        } else {
            for (String key : this.fCurrentAllPreferenceSettingMap.keySet()) {
                String[] result = CodeFormatterConstants.getCategoryIDnPrefID(key);
                this.updateCurrentAllPreferenceSettingMap(result[0], result[1], profileOrDefaultProfile);
            }
        }
    }

    private void updateCurrentAllPreferenceSettingMap(String categoryID, String prefId, EObject profileOrDefaultProfile) {
        String valueAttribValue = this.getPreferenceValue(categoryID, prefId, profileOrDefaultProfile);
        String key = CodeFormatterConstants.getPreferenceSettingKey(categoryID, prefId);
        Object valObj = this.fCurrentAllPreferenceSettingMap.get(key);
        PreferenceSettingValue prefSettingVal = null;
        if (valObj == null) {
            prefSettingVal = new PreferenceSettingValue(valueAttribValue, valueAttribValue);
        } else {
            prefSettingVal = (PreferenceSettingValue)valObj;
            prefSettingVal.setInitialValue(valueAttribValue);
            prefSettingVal.setCurrValue(valueAttribValue);
        }
        this.fCurrentAllPreferenceSettingMap.put(key, prefSettingVal);
    }

    public boolean deleteProfile(int index, boolean updateSelection) {
        block6: {
            EObject obj;
            List allprofiles;
            block7: {
                allprofiles = this.getAllProfiles();
                obj = (EObject)allprofiles.get(index);
                if (obj == null) break block6;
                if (!this.isProfileBuildIn(obj)) break block7;
                return false;
            }
            try {
                FormatProfiles formatprofiles = (FormatProfiles)obj.eContainer();
                Profile profile2BeDeleted = (Profile)obj;
                String newBase = profile2BeDeleted.getBase();
                EList settings2BeDeleted = profile2BeDeleted.getSetting();
                List affectedProfiles = FormatProfileRootHelper.getProfilesWhoseBaseIs(profile2BeDeleted.getName(), formatprofiles);
                for (Profile affectedprofile : affectedProfiles) {
                    affectedprofile.setBase(newBase);
                    for (Setting setting2BeDeleted : settings2BeDeleted) {
                        Setting overideSetting = FormatProfileRootHelper.getPreferenceSettingByID(affectedprofile, setting2BeDeleted.getCategory(), setting2BeDeleted.getPref());
                        if (overideSetting != null) continue;
                        overideSetting = (Setting)EcoreUtil.copy((EObject)setting2BeDeleted);
                        affectedprofile.getSetting().add((Object)overideSetting);
                    }
                }
                if (!formatprofiles.getProfile().remove((Object)obj)) break block6;
                this.notifyObservers(2);
                if (updateSelection) {
                    Object newObj = allprofiles.get(index > 0 ? index - 1 : 0);
                    this.setSelectedProfile(newObj);
                }
                return true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
        }
        return false;
    }

    public Profile createNewProfile(String newProfileName, Object baseProfile, boolean useNewAsSelection) {
        String baseProfileName = this.getProfileName(baseProfile, false);
        return this.createNewProfile(newProfileName, baseProfileName, useNewAsSelection);
    }

    private Profile createNewProfile(String newProfileName, String base, boolean useNewAsSelection) {
        EGLFormatProfileRoot formatProfileRoot = this.getCustomWorkspaceFormatProfileRoot(true);
        if (formatProfileRoot != null) {
            return this.createNewProfile(newProfileName, base, useNewAsSelection, formatProfileRoot.getFormatProfiles());
        }
        return null;
    }

    private Profile createNewProfile(String newProfileName, String base, boolean useNewAsSelection, FormatProfiles profilesroot) {
        Profile newProfile = ProfileFactory.eINSTANCE.createProfile();
        newProfile.setName(newProfileName);
        newProfile.setBase(base);
        newProfile.setIsBuildIn(false);
        profilesroot.getProfile().add((Object)newProfile);
        this.notifyObservers(4);
        if (useNewAsSelection) {
            this.setSelectedProfile(newProfile);
        }
        return newProfile;
    }

    public String[] getAllProfileDisplayNames() {
        List profiles = this.getAllProfiles();
        int cnt = profiles.size();
        String[] profileDisplayNames = new String[cnt];
        int i = 0;
        for (Object obj : profiles) {
            profileDisplayNames[i] = this.getProfileName(obj, true);
            ++i;
        }
        return profileDisplayNames;
    }

    private String getProfileName(Object obj, boolean getDisplay) {
        String name = "";
        if (obj instanceof DefaultProfile) {
            name = ((DefaultProfile)obj).getName();
            if (getDisplay) {
                name = String.valueOf(name) + PROFILE_BUILDIN_DISPLAY_SUFFIX;
            }
        } else if (obj instanceof Profile) {
            Profile profile = (Profile)obj;
            name = profile.getName();
            if (profile.isIsBuildIn() && getDisplay) {
                name = String.valueOf(name) + PROFILE_BUILDIN_DISPLAY_SUFFIX;
            }
        }
        return name;
    }

    public List getAllProfiles() {
        FormatProfiles profilesroot;
        EList customOnes;
        EGLFormatProfileRoot customWSProfileRoot;
        ArrayList<DefaultProfile> profiles = new ArrayList<DefaultProfile>();
        EGLFormatProfileRoot buildinProfileRoot = this.getBuildInFormatProfileRoot();
        if (buildinProfileRoot != null) {
            EList otherbuildins;
            FormatProfiles profilesroot2 = buildinProfileRoot.getFormatProfiles();
            DefaultProfile defaultProfile = profilesroot2.getDefaultProfile();
            if (defaultProfile != null) {
                profiles.add(defaultProfile);
            }
            if ((otherbuildins = profilesroot2.getProfile()) != null && !otherbuildins.isEmpty()) {
                profiles.addAll((Collection<DefaultProfile>)otherbuildins);
            }
        }
        if ((customWSProfileRoot = this.getCustomWorkspaceFormatProfileRoot(false)) != null && (customOnes = (profilesroot = customWSProfileRoot.getFormatProfiles()).getProfile()) != null && !customOnes.isEmpty()) {
            profiles.addAll((Collection<DefaultProfile>)customOnes);
        }
        return profiles;
    }

    public int getProfileIndexByName(String profileName) {
        EObject fndProfile = this.getProfileByName(profileName, false);
        if (fndProfile != null) {
            return this.getProfileIndex(fndProfile);
        }
        return -1;
    }

    private int getProfileIndex(EObject defaultProfileOrProfile) {
        List allProfiles = this.getAllProfiles();
        int i = 0;
        Iterator it = allProfiles.iterator();
        while (it.hasNext()) {
            if (defaultProfileOrProfile == it.next()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getDefaultPreviewCode() {
        FormatProfiles profilesroot;
        DefaultProfile defaultProfile;
        EGLFormatProfileRoot buildinProfileRoot = this.getBuildInFormatProfileRoot();
        if (buildinProfileRoot != null && (defaultProfile = (profilesroot = buildinProfileRoot.getFormatProfiles()).getDefaultProfile()) != null) {
            return defaultProfile.getPreview().getCode();
        }
        return "";
    }

    public String getPreferenceValue(String categoryID, String prefID, EObject profileOrDefaultProfile) {
        String prefValue = "";
        if (profileOrDefaultProfile instanceof DefaultProfile) {
            DefaultProfile defaultProfile = (DefaultProfile)profileOrDefaultProfile;
            Preference pref = FormatProfileRootHelper.getPreferenceByID(defaultProfile, categoryID, prefID);
            if (pref != null) {
                prefValue = pref.getValue();
            }
        } else if (profileOrDefaultProfile instanceof Profile) {
            Profile profile = (Profile)profileOrDefaultProfile;
            Setting setting = FormatProfileRootHelper.getPreferenceSettingByID(profile, categoryID, prefID);
            if (setting != null) {
                prefValue = setting.getValue();
            } else {
                String baseProfileName = profile.getBase();
                EObject baseProfile = this.getProfileByName(baseProfileName, true);
                prefValue = this.getPreferenceValue(categoryID, prefID, baseProfile);
            }
        }
        return prefValue;
    }

    public void profileRenamed() {
        this.notifyObservers(3);
    }

    public void undoPreferenceSettings(Map preferenceSetting) {
        for (Object key : preferenceSetting.keySet()) {
            PreferenceSettingValue settingVal = (PreferenceSettingValue)preferenceSetting.get(key);
            if (!settingVal.hasSettingValueChanged()) continue;
            settingVal.setCurrValue(settingVal.getInitialValue());
        }
    }

    public Profile getFirstProfileByParsing(File eglFormattingProfileFile) {
        Path importedFilePath = new Path(eglFormattingProfileFile.getPath());
        EGLFormatProfileRoot importedFormatProfileRoot = FormatProfileRootHelper.getEGLFormatProfileModel((IPath)importedFilePath);
        FormatProfiles formatprofiles = importedFormatProfileRoot.getFormatProfiles();
        EList profiles = formatprofiles.getProfile();
        if (profiles != null && !profiles.isEmpty()) {
            return (Profile)profiles.get(0);
        }
        return null;
    }

    public void addProfile(Profile profile2Add, boolean useAsSelection) {
        EGLFormatProfileRoot formatProfileRoot = this.getCustomWorkspaceFormatProfileRoot(true);
        if (formatProfileRoot != null) {
            FormatProfiles formatprofiles = formatProfileRoot.getFormatProfiles();
            formatprofiles.getProfile().add((Object)profile2Add);
            this.notifyObservers(4);
            if (useAsSelection) {
                this.setSelectedProfile(profile2Add);
            }
        }
    }

    public void exportSelectedProfile(File exportedFile) {
        Path exportedFilePath = new Path(exportedFile.getPath());
        EGLFormatProfileRoot exportedFormatProfileRoot = FormatProfileRootHelper.createNewEGLFormatProfileModel((IPath)exportedFilePath);
        FormatProfiles formatprofiles = exportedFormatProfileRoot.getFormatProfiles();
        Profile exportProfile = ProfileFactory.eINSTANCE.createProfile();
        formatprofiles.getProfile().add((Object)exportProfile);
        DefaultProfile defaultProfile = this.getBuildInFormatProfileRoot().getFormatProfiles().getDefaultProfile();
        String defaultBuildInProfileName = defaultProfile.getName();
        EObject selProfile = this.getSelectedProfile();
        if (selProfile instanceof Profile) {
            exportProfile.setName(((Profile)selProfile).getName());
        } else if (selProfile instanceof DefaultProfile) {
            exportProfile.setName(String.valueOf(defaultBuildInProfileName) + "_exported");
        }
        exportProfile.setBase(defaultBuildInProfileName);
        exportProfile.setIsBuildIn(false);
        Map currPrefs = this.getCurrentPreferenceSettingMap();
        for (String key : currPrefs.keySet()) {
            String[] result = CodeFormatterConstants.getCategoryIDnPrefID(key);
            Setting setting = ProfileFactory.eINSTANCE.createSetting();
            setting.setCategory(result[0]);
            setting.setPref(result[1]);
            PreferenceSettingValue valObj = (PreferenceSettingValue)currPrefs.get(key);
            setting.setValue(valObj.getCurrentValue());
            exportProfile.getSetting().add((Object)setting);
        }
        FormatProfileRootHelper.saveEGLFormatProfile((IPath)exportedFilePath, exportedFormatProfileRoot);
    }

    public void updateProfileSettings(Profile profile, Map preferenceSetting) {
        boolean isSettingChanged = false;
        FormatProfiles formatprofiles = (FormatProfiles)profile.eContainer();
        for (Object key : preferenceSetting.keySet()) {
            PreferenceSettingValue settingVal = (PreferenceSettingValue)preferenceSetting.get(key);
            if (!settingVal.hasSettingValueChanged()) continue;
            isSettingChanged = true;
            String[] result = CodeFormatterConstants.getCategoryIDnPrefID((String)key);
            Setting setting = FormatProfileRootHelper.getPreferenceSettingByID(profile, result[0], result[1]);
            if (setting != null) {
                setting.setValue(settingVal.getCurrentValue());
            } else {
                setting = ProfileFactory.eINSTANCE.createSetting();
                setting.setCategory(result[0]);
                setting.setPref(result[1]);
                setting.setValue(settingVal.getCurrentValue());
                profile.getSetting().add((Object)setting);
            }
            List affectedProfiles = FormatProfileRootHelper.getProfilesWhoseBaseIs(profile.getName(), formatprofiles);
            for (Profile affectedprofile : affectedProfiles) {
                Setting settingaffected = FormatProfileRootHelper.getPreferenceSettingByID(affectedprofile, result[0], result[1]);
                if (settingaffected != null) continue;
                settingaffected = ProfileFactory.eINSTANCE.createSetting();
                settingaffected.setCategory(result[0]);
                settingaffected.setPref(result[1]);
                settingaffected.setValue(settingVal.getInitialValue());
                affectedprofile.getSetting().add((Object)settingaffected);
            }
        }
        if (isSettingChanged) {
            this.notifyObservers(5);
        }
    }

    protected void notifyObservers(int message) {
        this.setChanged();
        this.notifyObservers(new Integer(message));
    }

    public static class PreferenceSettingValue {
        private String fInitialValue;
        private String fCurrValue;

        public PreferenceSettingValue(String initValue, String currValue) {
            this.fInitialValue = initValue;
            this.fCurrValue = currValue;
        }

        public void setInitialValue(String initValue) {
            this.fInitialValue = initValue;
        }

        public void setCurrValue(String currValue) {
            this.fCurrValue = currValue;
        }

        public String getCurrentValue() {
            return this.fCurrValue;
        }

        public String getInitialValue() {
            return this.fInitialValue;
        }

        public boolean hasSettingValueChanged() {
            return !this.fInitialValue.equals(this.fCurrValue);
        }
    }
}

