/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTPartVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.EnumerationField;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.SuperExpression;
import org.eclipse.edt.compiler.core.ast.ThisExpression;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.ide.core.internal.utils.BoundNodeLocationUtility;
import org.eclipse.edt.ide.core.internal.utils.IBoundNodeAddress;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.utils.BinaryReadOnlyFile;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.editor.BinaryEditorInput;
import org.eclipse.edt.ide.ui.internal.editor.BinaryFileEditor;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.IEvEditor;
import org.eclipse.edt.ide.ui.internal.editor.util.BoundNodeModelUtility;
import org.eclipse.edt.ide.ui.internal.editor.util.IBoundNodeRequestor;
import org.eclipse.edt.ide.ui.internal.handlers.EGLHandler;
import org.eclipse.edt.ide.ui.internal.util.EditorUtility;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class OpenOnSelectionHandler
extends EGLHandler {
    private boolean beep;
    private IBinding targetBinding;

    @Override
    public void run() {
        Node boundNode;
        this.beep = true;
        ISelection selection = this.fEditor.getSelectionProvider().getSelection();
        Object currentFile = this.fEditor instanceof BinaryFileEditor ? (BinaryReadOnlyFile)((BinaryEditorInput)this.fEditor.getEditorInput()).getStorage() : ((FileEditorInput)this.fEditor.getEditorInput()).getFile();
        IProject currentProject = currentFile.getProject();
        int currentPosition = ((ITextSelection)selection).getOffset();
        IEGLDocument document = (IEGLDocument)this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        final int[][] localVariableDefinition = new int[1][];
        final IBoundNodeAddress[] address = new IBoundNodeAddress[1];
        String[] selectedNodeName = new String[1];
        BoundNodeModelUtility.getBoundNodeAtOffset(currentFile, currentPosition, new IBoundNodeRequestor((IFile)currentFile, selectedNodeName, currentProject){
            private final /* synthetic */ IFile val$currentFile;
            private final /* synthetic */ String[] val$selectedNodeName;
            private final /* synthetic */ IProject val$currentProject;
            {
                this.val$currentFile = iFile;
                this.val$selectedNodeName = stringArray;
                this.val$currentProject = iProject;
            }

            @Override
            public void acceptNode(final Node boundPart, Node selectedNode) {
                if (!(selectedNode instanceof Part) && !(selectedNode instanceof org.eclipse.edt.compiler.core.ast.Statement)) {
                    selectedNode.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

                        public boolean visit(File file) {
                            return false;
                        }

                        public boolean visitName(Name name) {
                            Member binding = name.resolveMember();
                            if (binding != null) {
                                if (this.isLocal(binding)) {
                                    localVariableDefinition[0] = this.findLocalVariableDeclaration(binding, boundPart);
                                } else {
                                    address[0] = BoundNodeLocationUtility.getInstance().createBoundNodeAddress((Element)binding, (Expression)name, val$currentFile.getProject());
                                    this.setProjectIfMissed(address[0]);
                                }
                                val$selectedNodeName[0] = name.getIdentifier();
                            } else if (name.resolveType() != null) {
                                address[0] = BoundNodeLocationUtility.getInstance().createBoundNodeAddress((Element)name.resolveType(), (Expression)name, val$currentFile.getProject());
                                this.setProjectIfMissed(address[0]);
                                val$selectedNodeName[0] = name.getIdentifier();
                            }
                            return false;
                        }

                        private boolean isLocal(Member m) {
                            Object parent = m.getContainer();
                            while (parent != null) {
                                if (parent instanceof FunctionMember) {
                                    return true;
                                }
                                parent = parent instanceof Member ? ((Member)parent).getContainer() : (parent instanceof Statement ? ((Statement)parent).getContainer() : null);
                            }
                            return false;
                        }

                        public boolean visit(SuperExpression superExpression) {
                            Node parent = superExpression.getParent();
                            if (parent instanceof FunctionInvocation && ((FunctionInvocation)parent).resolveElement() instanceof Constructor) {
                                Constructor binding = (Constructor)((FunctionInvocation)parent).resolveElement();
                                address[0] = BoundNodeLocationUtility.getInstance().createBoundNodeAddress((Element)binding, (Expression)superExpression, val$currentFile.getProject());
                                this.setProjectIfMissed(address[0]);
                                val$selectedNodeName[0] = binding.getName();
                                return false;
                            }
                            Type binding = superExpression.resolveType();
                            if (binding != null) {
                                address[0] = BoundNodeLocationUtility.getInstance().createBoundNodeAddress((Element)binding, (Expression)superExpression, val$currentFile.getProject());
                                this.setProjectIfMissed(address[0]);
                                val$selectedNodeName[0] = binding.getClassifier().getName();
                            }
                            return false;
                        }

                        public boolean visit(ThisExpression thisExpression) {
                            Node parent = thisExpression.getParent();
                            if (parent instanceof FunctionInvocation && ((FunctionInvocation)parent).resolveElement() instanceof Constructor) {
                                Constructor binding = (Constructor)((FunctionInvocation)parent).resolveElement();
                                address[0] = BoundNodeLocationUtility.getInstance().createBoundNodeAddress((Element)binding, (Expression)thisExpression, val$currentFile.getProject());
                                this.setProjectIfMissed(address[0]);
                                val$selectedNodeName[0] = binding.getName();
                                return false;
                            }
                            Type binding = thisExpression.resolveType();
                            if (binding != null) {
                                address[0] = BoundNodeLocationUtility.getInstance().createBoundNodeAddress((Element)binding, (Expression)thisExpression, val$currentFile.getProject());
                                this.setProjectIfMissed(address[0]);
                                val$selectedNodeName[0] = binding.getClassifier().getName();
                            }
                            return false;
                        }

                        public boolean visit(FieldAccess fieldAccess) {
                            Member binding = fieldAccess.resolveMember();
                            if (binding != null) {
                                if (this.isLocal(binding)) {
                                    localVariableDefinition[0] = this.findLocalVariableDeclaration(binding, boundPart);
                                } else {
                                    address[0] = BoundNodeLocationUtility.getInstance().createBoundNodeAddress((Element)binding, (Expression)fieldAccess, val$currentFile.getProject());
                                    this.setProjectIfMissed(address[0]);
                                }
                                val$selectedNodeName[0] = fieldAccess.getID();
                            }
                            return false;
                        }

                        public boolean visit(NestedFunction nestedFunction) {
                            return false;
                        }

                        public boolean visit(org.eclipse.edt.compiler.core.ast.Constructor constructor) {
                            return false;
                        }

                        private int[] findLocalVariableDeclaration(Member binding, Node boundPart2) {
                            int[][] result = new int[1][];
                            LocalVariableDeclarationFinder finder = new LocalVariableDeclarationFinder(binding);
                            boundPart2.accept((IASTVisitor)finder);
                            if (finder.localVariableDeclarationName != null) {
                                result[0] = new int[]{finder.localVariableDeclarationName.getOffset(), finder.localVariableDeclarationName.getLength()};
                            }
                            return result[0];
                        }

                        private void setProjectIfMissed(IBoundNodeAddress address2) {
                            IFile boundFile = null;
                            if (address2 != null) {
                                boundFile = address2.getDeclaringFile();
                            }
                            if (boundFile != null && boundFile.getProject() == null && boundFile instanceof BinaryReadOnlyFile) {
                                ((BinaryReadOnlyFile)boundFile).setProject(val$currentProject);
                            }
                        }
                    });
                }
            }
        });
        if (localVariableDefinition[0] != null) {
            this.fEditor.selectAndReveal(localVariableDefinition[0][0], localVariableDefinition[0][1]);
            this.beep = false;
        } else if (address[0] != null && (boundNode = BoundNodeLocationUtility.getInstance().getASTNodeForAddress(address[0], EGLUI.getSharedWorkingCopies())) != null) {
            NodeFinderASTPartVisitor nodeFinder = new NodeFinderASTPartVisitor(selectedNodeName, document, address, (IFile)currentFile);
            boundNode.accept((IASTVisitor)nodeFinder);
        }
        if (this.beep) {
            this.fEditor.getSite().getShell().getDisplay().beep();
        }
    }

    private IEditorPart openInEditor(IFile file) {
        try {
            return EditorUtility.openInEditor((Object)file, true);
        }
        catch (CoreException coreException) {
            EGLLogger.log((Object)this, UINlsStrings.OpenPartErrorMessage);
            return null;
        }
    }

    public IBinding getTargetBinding() {
        return this.targetBinding;
    }

    private static class LocalVariableDeclarationFinder
    extends AbstractASTVisitor {
        Name localVariableDeclarationName;
        Member referenceBinding;

        public LocalVariableDeclarationFinder(Member binding) {
            this.referenceBinding = binding;
        }

        private void handleName(Name name) {
            if (this.referenceBinding.equals(name.resolveMember())) {
                this.localVariableDeclarationName = name;
            }
        }

        public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
            Iterator iter = functionDataDeclaration.getNames().iterator();
            while (iter.hasNext()) {
                this.handleName((Name)iter.next());
            }
            return false;
        }

        public boolean visit(ForStatement forStatement) {
            if (forStatement.hasVariableDeclaration()) {
                this.handleName(forStatement.getVariableDeclarationName());
            }
            return true;
        }

        public boolean visit(ForEachStatement foreachStatement) {
            if (foreachStatement.hasVariableDeclaration()) {
                this.handleName((Name)foreachStatement.getVariableDeclarationName());
            }
            return true;
        }

        public boolean visit(OnExceptionBlock onExceptionBlock) {
            this.handleName(onExceptionBlock.getExceptionName());
            return true;
        }

        public boolean visit(FunctionParameter functionParameter) {
            this.handleName(functionParameter.getName());
            return true;
        }
    }

    class NodeFinderASTPartVisitor
    extends AbstractASTPartVisitor {
        final String[] selectedNodeName;
        final IEGLDocument document;
        final IBoundNodeAddress[] address;
        final IFile currentFile;

        public NodeFinderASTPartVisitor(String[] selectedNodeName, IEGLDocument document, IBoundNodeAddress[] address, IFile currentFile) {
            this.selectedNodeName = selectedNodeName;
            this.document = document;
            this.address = address;
            this.currentFile = currentFile;
        }

        public boolean visit(ClassDataDeclaration classDataDeclaration) {
            for (Name name : classDataDeclaration.getNames()) {
                if (!NameUtile.equals((String)name.getIdentifier(), (String)this.selectedNodeName[0])) continue;
                this.selectAndReveal(name);
            }
            return true;
        }

        public boolean visit(FunctionParameter functionParameter) {
            this.selectAndReveal(functionParameter.getName());
            return false;
        }

        public boolean visit(EnumerationField enumerationField) {
            this.selectAndReveal(enumerationField.getName());
            return false;
        }

        public boolean visit(NestedFunction nestedFunction) {
            this.selectAndReveal(nestedFunction.getName());
            return false;
        }

        public boolean visit(org.eclipse.edt.compiler.core.ast.Constructor constructor) {
            this.selectAndReveal(NameUtile.getAsName((String)"constructor"), constructor.getOffset(), "constructor".length());
            return false;
        }

        public boolean visit(StructureItem structureItem) {
            this.selectAndReveal(structureItem.getName());
            return false;
        }

        public void visitPart(Part part) {
            this.selectAndReveal(part.getName());
        }

        private void selectAndReveal(Name name) {
            this.selectAndReveal(name.getIdentifier(), name.getOffset(), name.getLength());
        }

        private void selectAndReveal(String identifier, int start, int length) {
            IFile file = this.address[0].getDeclaringFile();
            if (file.equals((Object)this.currentFile)) {
                this.document.reconcile();
                EditorUtility.revealInEditor((IEditorPart)OpenOnSelectionHandler.this.fEditor, start, length);
            } else if (file.isReadOnly()) {
                String irName = file instanceof BinaryReadOnlyFile ? ((BinaryReadOnlyFile)file).getIrName() : IRFileNameUtility.toIRFileName((String)identifier);
                IEditorPart part = EditorUtility.openSourceFromEglarInBinaryEditor(file.getProject(), file.getFullPath().toString(), file.getProjectRelativePath().toString(), irName, "org.eclipse.edt.ide.ui.BinaryFileEditor");
                if (part instanceof EGLEditor) {
                    ((EGLEditor)part).selectAndReveal(start, length);
                } else if (part instanceof IEvEditor) {
                    ((IEvEditor)part).selectAndReveal(start, length);
                }
            } else {
                EditorUtility.revealInEditor(OpenOnSelectionHandler.this.openInEditor(file), start, length);
            }
            OpenOnSelectionHandler.this.beep = false;
        }
    }
}

