/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.outline;

import java.util.ArrayList;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.outline.AbstractOutlineAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class ConstructorOutlineAdapter
extends AbstractOutlineAdapter {
    public ConstructorOutlineAdapter(EGLEditor editor) {
        super(editor);
        this.nodeIcon = PluginImages.DESC_OBJS_FUNCTION;
    }

    @Override
    public String getText(Object element) {
        Constructor ctor = (Constructor)element;
        StringBuffer buffer = new StringBuffer();
        buffer.append("constructor");
        buffer.append('(');
        final ArrayList parameters = new ArrayList();
        ctor.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(Constructor function) {
                return true;
            }

            public boolean visit(FunctionParameter functionParameter) {
                parameters.add(functionParameter);
                return false;
            }
        });
        int len = parameters.size();
        if (len > 0) {
            int i = 0;
            while (i < len) {
                if (i != 0) {
                    buffer.append(", ");
                }
                FunctionParameter param = (FunctionParameter)parameters.get(i);
                buffer.append(this.formatType(param.getType()));
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public IRegion getHighlightRange(Object element) {
        Constructor ctor = (Constructor)element;
        return new Region(ctor.getOffset(), ctor.getLength());
    }
}

