/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.packageexplorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.EGLElementTransfer;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.packageexplorer.PasteAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.ResourceTransfer;

public class CopyAction
extends SelectionListenerAction {
    private Shell shell;
    private Clipboard clipboard;
    private PasteAction pasteAction;

    public CopyAction(Shell shell, Clipboard clipboard, PasteAction pasteAction) {
        super(UINlsStrings.EGLCopyAction_Label);
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)clipboard);
        this.shell = shell;
        this.clipboard = clipboard;
        this.pasteAction = pasteAction;
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.updateSelection(this.getStructuredSelection());
    }

    protected static IEGLElement[] getEGLElements(List elements) {
        ArrayList eglelementslist = new ArrayList(elements.size());
        for (Object element : elements) {
            if (!(element instanceof IEGLElement)) continue;
            eglelementslist.add(element);
        }
        return eglelementslist.toArray(new IEGLElement[eglelementslist.size()]);
    }

    public void run() {
        List selectedResources = this.getSelectedResources();
        IResource[] resources = selectedResources.toArray(new IResource[selectedResources.size()]);
        IEGLElement[] eglelements = CopyAction.getEGLElements(this.getStructuredSelection().toList());
        int length = resources.length;
        int actualLength = 0;
        String[] fileNames = new String[length];
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < length) {
            IPath location = resources[i].getLocation();
            if (location != null) {
                fileNames[actualLength++] = location.toOSString();
            }
            if (i > 0) {
                buf.append("\n");
            }
            buf.append(resources[i].getName());
            ++i;
        }
        if (actualLength < length) {
            String[] tempFileNames = fileNames;
            fileNames = new String[actualLength];
            int i2 = 0;
            while (i2 < actualLength) {
                fileNames[i2] = tempFileNames[i2];
                ++i2;
            }
        }
        this.setClipboard(eglelements, resources, fileNames, buf.toString());
        if (this.pasteAction != null && this.pasteAction.getStructuredSelection() != null) {
            this.pasteAction.selectionChanged(this.pasteAction.getStructuredSelection());
        }
    }

    private void setClipboard(IEGLElement[] eglelements, IResource[] resources, String[] fileNames, String names) {
        block5: {
            try {
                if (fileNames.length > 0) {
                    this.clipboard.setContents(new Object[]{eglelements, resources, fileNames, names}, new Transfer[]{EGLElementTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                } else {
                    this.clipboard.setContents(new Object[]{eglelements, resources, names}, new Transfer[]{EGLElementTransfer.getInstance(), ResourceTransfer.getInstance(), TextTransfer.getInstance()});
                }
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.shell, (String)UINlsStrings.EGLCopyAction_CopyToClipboardProblemDialog_title, (String)UINlsStrings.EGLCopyAction_CopyToClipboardProblemDialog_message)) break block5;
                this.setClipboard(eglelements, resources, fileNames, names);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        List selectedResources = this.getSelectedResources();
        if (selectedResources.size() == 0) {
            return false;
        }
        for (Object element : selection.toList()) {
            if (element instanceof IEGLElement) {
                int egltype = ((IEGLElement)element).getElementType();
                if (egltype == 6 || egltype == 4) continue;
                return false;
            }
            return false;
        }
        boolean projSelected = this.selectionIsOfType(4);
        boolean fileFoldersSelected = this.selectionIsOfType(3);
        if (!projSelected && !fileFoldersSelected) {
            return false;
        }
        if (projSelected && fileFoldersSelected) {
            return false;
        }
        IContainer firstParent = ((IResource)selectedResources.get(0)).getParent();
        if (firstParent == null) {
            return false;
        }
        for (IResource currentResource : selectedResources) {
            if (!currentResource.getParent().equals((Object)firstParent)) {
                return false;
            }
            if (currentResource.getLocation() != null) continue;
            return false;
        }
        return true;
    }
}

