/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.packageexplorer;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.internal.model.EGLElementTransfer;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.packageexplorer.CopyResourceAndFilesFolderOperation;
import org.eclipse.edt.ide.ui.internal.refactoring.ReorgCopyStarter;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.ResourceTransfer;

public class PasteAction
extends SelectionListenerAction {
    private Shell shell;
    private Clipboard clipboard;

    public PasteAction(Shell shell, Clipboard clipboard) {
        super(UINlsStrings.EGLPasteAction_Label);
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)clipboard);
        this.shell = shell;
        this.clipboard = clipboard;
        this.setToolTipText("");
        ISharedImages workbenchImages = EDTUIPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.updateSelection(this.getStructuredSelection());
    }

    public void run() {
        block13: {
            EGLElementTransfer eglTransfer = EGLElementTransfer.getInstance();
            IEGLElement[] eglData = (IEGLElement[])this.clipboard.getContents((Transfer)eglTransfer);
            if (eglData != null && eglData.length > 0) {
                try {
                    IEGLElement target = this.getEGLTarget(this.getStructuredSelection());
                    if (target instanceof IPackageFragmentRoot && eglData[0] instanceof IEGLFile) {
                        IPackageFragment defaultpkg = ((IPackageFragmentRoot)target).getPackageFragment("");
                        target = defaultpkg;
                    }
                    if (this.startRefactoring(new IResource[0], eglData, target)) break block13;
                    CopyResourceAndFilesFolderOperation copyOp = new CopyResourceAndFilesFolderOperation(eglData, target, true, this.shell);
                    try {
                        copyOp.run(null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                catch (EGLModelException e) {
                    EGLLogger.log((Object)this, e);
                }
            } else if (eglData == null) {
                ResourceTransfer resTransfer = ResourceTransfer.getInstance();
                IResource[] resourceData = (IResource[])this.clipboard.getContents((Transfer)resTransfer);
                if (resourceData != null && resourceData.length > 0) {
                    if (resourceData[0].getType() == 4) {
                        int i = 0;
                        while (i < resourceData.length) {
                            CopyProjectOperation operation = new CopyProjectOperation(this.shell);
                            operation.copyProject((IProject)resourceData[i]);
                            ++i;
                        }
                    } else {
                        IContainer container = this.getContainer();
                        CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.shell);
                        operation.copyResources(resourceData, container);
                    }
                    return;
                }
                FileTransfer fileTransfer = FileTransfer.getInstance();
                String[] fileData = (String[])this.clipboard.getContents((Transfer)fileTransfer);
                if (fileData != null) {
                    IContainer container = this.getContainer();
                    CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.shell);
                    operation.copyFiles(fileData, container);
                }
            }
        }
    }

    private IEGLElement getEGLTarget(IStructuredSelection selection) {
        List selectedResources = selection.toList();
        for (Object element : selectedResources) {
            if (!(element instanceof IEGLElement)) continue;
            return (IEGLElement)element;
        }
        return null;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (selection.toList().size() > 1) {
            return false;
        }
        EGLElementTransfer eglTransfer = EGLElementTransfer.getInstance();
        IEGLElement[] clipboardData = (IEGLElement[])this.clipboard.getContents((Transfer)eglTransfer);
        if (clipboardData != null && clipboardData.length > 0) {
            IEGLElement eglTgt = this.getEGLTarget(selection);
            if (eglTgt == null) {
                return false;
            }
            int iTgtType = eglTgt.getElementType();
            int i = 0;
            while (i < clipboardData.length) {
                IEGLElement eglelem = clipboardData[i];
                int iSrcType = eglelem.getElementType();
                if (iSrcType == 6) {
                    if (iTgtType != 4 && iTgtType != 3) {
                        return false;
                    }
                } else if (iSrcType == 4) {
                    if (iTgtType != 3) {
                        return false;
                    }
                } else {
                    return false;
                }
                ++i;
            }
        } else if (clipboardData == null) {
            return this.canResourcePaste(selection);
        }
        return true;
    }

    private boolean canResourcePaste(IStructuredSelection selection) {
        int i;
        boolean isProjectRes;
        final IResource[][] clipboardData = new IResource[1][];
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ResourceTransfer resTransfer = ResourceTransfer.getInstance();
                clipboardData[0] = (IResource[])PasteAction.this.clipboard.getContents((Transfer)resTransfer);
            }
        });
        IResource[] resourceData = clipboardData[0];
        boolean bl = isProjectRes = resourceData != null && resourceData.length > 0 && resourceData[0].getType() == 4;
        if (isProjectRes) {
            int i2 = 0;
            while (i2 < resourceData.length) {
                if (resourceData[i2].getType() != 4 || !((IProject)resourceData[i2]).isOpen()) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        IResource targetResource = this.getTarget();
        if (targetResource == null) {
            return false;
        }
        List selectedResources = this.getSelectedResources();
        if (selectedResources.size() > 1) {
            i = 0;
            while (i < selectedResources.size()) {
                IResource resource = (IResource)selectedResources.get(i);
                if (resource.getType() != 1) {
                    return false;
                }
                if (!targetResource.equals((Object)resource.getParent())) {
                    return false;
                }
                ++i;
            }
        }
        if (resourceData != null) {
            if (this.isLinked(resourceData) && targetResource.getType() != 4) {
                return false;
            }
            if (targetResource.getType() == 2) {
                i = 0;
                while (i < resourceData.length) {
                    if (targetResource.equals((Object)resourceData[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        TransferData[] transfers = this.clipboard.getAvailableTypes();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        int i3 = 0;
        while (i3 < transfers.length) {
            if (fileTransfer.isSupportedType(transfers[i3])) {
                return true;
            }
            ++i3;
        }
        return false;
    }

    private IContainer getContainer() {
        List selection = this.getSelectedResources();
        if (selection.get(0) instanceof IFile) {
            return ((IFile)selection.get(0)).getParent();
        }
        return (IContainer)selection.get(0);
    }

    private IResource getTarget() {
        List selectedResources = this.getSelectedResources();
        int i = 0;
        while (i < selectedResources.size()) {
            IResource resource = (IResource)selectedResources.get(i);
            if (resource instanceof IProject && !((IProject)resource).isOpen()) {
                return null;
            }
            if (resource.getType() == 1) {
                resource = resource.getParent();
            }
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    private boolean isLinked(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i].isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean startRefactoring(IResource[] resources, IEGLElement[] eglElements, IEGLElement destination) throws EGLModelException {
        ReorgCopyStarter create;
        block4: {
            create = ReorgCopyStarter.create(eglElements, resources, destination);
            if (create != null) break block4;
            return false;
        }
        try {
            create.run(this.shell);
        }
        catch (InterruptedException e) {
            EGLLogger.log((Object)this, e);
        }
        catch (InvocationTargetException e) {
            EGLLogger.log((Object)this, e);
        }
        return true;
    }
}

