/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.preferences;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.edt.ide.ui.EDTUIPreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ColorProvider {
    public static final String DEFAULT = "DEFAULT";
    public static final String KEYWORD = "KEYWORD";
    public static final String SINGLE_LINE_COMMENT = "SINGLE_LINE_COMMENT";
    public static final String MULTI_LINE_COMMENT = "MULTI_LINE_COMMENT";
    public static final String LITERAL = "LITERAL";
    protected Map fColorTable = new HashMap(10);
    protected IPreferenceStore preferenceStore = null;

    public ColorProvider(IPreferenceStore prefs) {
        this.preferenceStore = prefs;
        if (!this.preferenceStore.contains("egl_default")) {
            EDTUIPreferenceConstants.initializeDefaultEGLColorPreferences(this.preferenceStore);
        }
    }

    public Color getColorForRGB(RGB rgb) {
        Color color = (Color)this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color(null, rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        Iterator e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            ((Color)e.next()).dispose();
        }
    }

    public TextAttribute getTextAttribute(String namedStyle) {
        String key = null;
        if (namedStyle == KEYWORD) {
            key = "egl_keyword";
        }
        if (namedStyle == DEFAULT) {
            key = "egl_default";
        }
        if (namedStyle == LITERAL) {
            key = "egl_string";
        }
        if (namedStyle == MULTI_LINE_COMMENT) {
            key = "egl_multi_line_comment";
        }
        if (namedStyle == SINGLE_LINE_COMMENT) {
            key = "egl_single_line_comment";
        }
        return new TextAttribute(this.getColorForRGB(PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)key)), null, this.preferenceStore.getBoolean(String.valueOf(key) + "_bold") ? 1 : 0);
    }
}

