/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.property.pages;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.internal.PartWrapper;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.utils.DefaultDeploymentDescriptorUtility;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.property.pages.DefaultDeploymentDescriptorComposite;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class DefaultDeploymentDescriptorPropertyPage
extends PropertyPage {
    private DefaultDeploymentDescriptorComposite[] dbdCmposites;
    private IResource thisResource;

    protected Control createContents(Composite parent) {
        this.initialize();
        this.createDescriptionLabel(parent);
        this.createResourceLabel(parent);
        Composite theComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        theComposite.setLayout((Layout)layout);
        this.dbdCmposites = new DefaultDeploymentDescriptorComposite[]{new DefaultDeploymentDescriptorComposite(theComposite, 0, this.thisResource)};
        this.initializeValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IUIHelpConstants.DEFAULT_DEPLOYMENT_DESCRIPTOR_CONTEXT);
        Dialog.applyDialogFont((Control)parent);
        return theComposite;
    }

    public boolean performOk() {
        if (this.thisResource != null) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    DefaultDeploymentDescriptorPropertyPage.this.performOkAsync();
                }
            };
            try {
                new ProgressMonitorDialog(this.getControl().getShell()).run(true, true, runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                this.handle(e);
            }
        }
        return true;
    }

    protected void handle(InvocationTargetException e) {
        IStatus error;
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            error = ((CoreException)target).getStatus();
        } else {
            String msg = target.getMessage();
            if (msg == null) {
                msg = "Internal error";
            }
            error = new Status(4, "org.eclipse.edt.ide.ui", 1, msg, target);
        }
        ErrorDialog.openError((Shell)this.getControl().getShell(), (String)"Problems Occurred", null, (IStatus)error);
    }

    private void performOkAsync() {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < DefaultDeploymentDescriptorPropertyPage.this.dbdCmposites.length) {
                        DefaultDeploymentDescriptorComposite dbdComposite = DefaultDeploymentDescriptorPropertyPage.this.dbdCmposites[i];
                        DefaultDeploymentDescriptorComposite.DDSettings defaultDD = dbdComposite.getDefaultDDSettings();
                        PartWrapper currentDD = defaultDD.getCurrentDD();
                        if (currentDD == null) {
                            DefaultDeploymentDescriptorUtility.setDefaultDeploymentDescriptor((IResource)DefaultDeploymentDescriptorPropertyPage.this.thisResource, null);
                        } else {
                            String name = currentDD.getPartName();
                            String file = currentDD.getPartPath();
                            PartWrapper wrapper = new PartWrapper();
                            wrapper.setPartName(name);
                            wrapper.setPartPath(file);
                            DefaultDeploymentDescriptorUtility.setDefaultDeploymentDescriptor((IResource)DefaultDeploymentDescriptorPropertyPage.this.thisResource, (PartWrapper)wrapper);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    private void initialize() {
        this.thisResource = this.getSelectedResource();
        this.noDefaultAndApplyButton();
        this.setDescription(UINlsStrings.DefaultDDPropertiesPageLabelText);
    }

    private IResource getSelectedResource() {
        IResource resource = null;
        IAdaptable adaptable = this.getElement();
        if (adaptable != null) {
            resource = (IResource)adaptable.getAdapter(IResource.class);
        }
        EGLProject eglProj = (EGLProject)EGLCore.create((IProject)resource.getProject());
        eglProj.isOnEGLPath(resource);
        return resource;
    }

    private void createResourceLabel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        Label resourceLabel = new Label(composite, 64);
        resourceLabel.setFont(parent.getFont());
        resourceLabel.setText(UINlsStrings.DefaultDDPropertiesPageResourceLabelText);
        Label resource = new Label(composite, 64);
        resource.setFont(parent.getFont());
        String resourceText = this.thisResource.getFullPath().toString();
        if (Locale.getDefault().toString().toLowerCase().indexOf("ar") != -1) {
            resourceText = TextProcessor.process((String)resourceText, (String)"/");
        }
        resource.setText(resourceText);
    }

    private void initializeValues() {
        int i = 0;
        while (i < this.dbdCmposites.length) {
            DefaultDeploymentDescriptorComposite dbdComposite = this.dbdCmposites[i];
            if (dbdComposite != null) {
                PartWrapper wrapper = this.getDefaultBuildDescriptor();
                DefaultDeploymentDescriptorComposite.DDSettings defaultDD = dbdComposite.getDefaultDDSettings();
                defaultDD.setInitialDD(wrapper);
            }
            ++i;
        }
    }

    private PartWrapper getDefaultBuildDescriptor() {
        if (this.thisResource != null) {
            return DefaultDeploymentDescriptorUtility.getDefaultDeploymentDescriptor((IResource)this.thisResource);
        }
        return null;
    }
}

