/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.quickfix.proposals.sql;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.sql.SQLIOStatementUtility;
import org.eclipse.edt.ide.ui.internal.quickfix.AssistContext;
import org.eclipse.edt.ide.ui.internal.quickfix.CorrectionMessages;
import org.eclipse.edt.ide.ui.internal.quickfix.IInvocationContext;
import org.eclipse.edt.ide.ui.internal.quickfix.proposals.AbstractSQLStatementProposal;
import org.eclipse.edt.ide.ui.internal.quickfix.proposals.sql.SQLStatementAddAssistProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IFileEditorInput;

public class SQLStatementResetAssistProposal
extends SQLStatementAddAssistProposal {
    private IInvocationContext fContext;

    public SQLStatementResetAssistProposal(String label, int relevance, Image image, IInvocationContext context) {
        super(label, context.getEGLFile(), relevance, image, context.getDocument());
        this.fContext = context;
        if (this.fContext instanceof AssistContext) {
            this.editor = (EGLEditor)((AssistContext)this.fContext).getEditor();
        }
    }

    @Override
    protected ASTRewrite getRewrite() {
        try {
            final ASTRewrite rewrite = ASTRewrite.create((File)this.fContext.getFileAST());
            Statement sqlNode = AbstractSQLStatementProposal.SQLStatementFinder(this.fContext);
            final IEGLDocument document = this.fContext.getDocument();
            this.info = SQLIOStatementUtility.getAddSQLIoStatementActionInfo(document, (Node)sqlNode);
            this.initialize();
            if (this.info.getSqlStatementNode() != null && this.info.getIntoClauseNode() == null) {
                rewrite.removeNode(this.info.getSqlStatementNode());
            }
            if (this.info.getIntoClauseNode() != null && this.info.getSqlStatementNode() == null) {
                rewrite.removeNode(this.info.getIntoClauseNode());
            }
            if (this.info.getIntoClauseNode() != null && this.info.getSqlStatementNode() != null) {
                rewrite.removeNode(this.info.getIntoClauseNode());
                rewrite.removeNode(this.info.getSqlStatementNode());
            }
            rewrite.completeIOStatement(sqlNode, "");
            if (sqlNode != null) {
                final Statement finalSqlNode = sqlNode;
                AbstractSQLStatementProposal.IBoundNodeProcessor processor = new AbstractSQLStatementProposal.IBoundNodeProcessor(){

                    @Override
                    public void processBoundNode(Node boundNode, Node containerNode) {
                        if (!(boundNode instanceof Statement)) {
                            return;
                        }
                        SQLStatementResetAssistProposal.this.info = SQLIOStatementUtility.getAddSQLIoStatementActionInfo(document, boundNode);
                        SQLStatementResetAssistProposal.this.initialize();
                        if (!SQLStatementResetAssistProposal.this.isEGLStatementValidForAction()) {
                            SQLStatementResetAssistProposal.this.sqlStatement = null;
                        }
                        SQLStatementResetAssistProposal.this.createDefault(SQLStatementResetAssistProposal.this.info.getStatement());
                        if (SQLStatementResetAssistProposal.this.sqlStatement != null) {
                            rewrite.completeIOStatement(finalSqlNode, SQLStatementResetAssistProposal.this.getStatementText());
                        } else {
                            SQLStatementResetAssistProposal.this.sqlStatement = CorrectionMessages.SQLExceptionMessage;
                            rewrite.completeIOStatement(finalSqlNode, SQLStatementResetAssistProposal.this.sqlStatement);
                        }
                    }
                };
                IFileEditorInput fileInput = (IFileEditorInput)this.editor.getEditorInput();
                this.bindASTNode(document, null, sqlNode.getOffset(), fileInput.getFile(), processor);
            }
            return rewrite;
        }
        catch (Exception e) {
            EDTUIPlugin.log((IStatus)new Status(4, "org.eclipse.edt.ide.ui", "Complete function: Error complete function", (Throwable)e));
            return null;
        }
    }

    @Override
    protected boolean isResetAction() {
        return true;
    }

    @Override
    protected boolean isEGLStatementValidForAction() {
        boolean isValid = true;
        isValid = this.hasEGLSQLStatementErrors();
        if (isValid) {
            this.ensureSQLStatementIsNotCloseOrDelete();
            if (!this.ensureExplicitSQLStatementAllowed()) {
                return false;
            }
            if (this.info.getSqlStatementNode() == null && this.info.getIntoClauseNode() == null) {
                return false;
            }
            if (this.ensureSQLRecordVariableIsSpecified()) {
                this.info.setSqlRecordBinding(this.getSQLRecordBindingFromTarget());
            } else {
                isValid = false;
            }
            if (!this.ensureIntoClauseNotSpecified()) {
                isValid = false;
            }
            if (this.isSQLRecordVariableSpecified() && !this.ensureDynamicArrayAllowed()) {
                return false;
            }
        }
        return isValid;
    }
}

