/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.record.NewRecordSummaryPage;
import org.eclipse.edt.ide.ui.internal.record.NewRecordWizard;
import org.eclipse.edt.ide.ui.internal.record.RecordConfiguration;
import org.eclipse.edt.ide.ui.internal.record.RecordOperation;
import org.eclipse.edt.ide.ui.internal.record.conversion.IMessageHandler;
import org.eclipse.edt.ide.ui.internal.record.conversion.PartsWrapper;
import org.eclipse.edt.ide.ui.internal.record.wizards.AbstractRecordFromStringInputPage;
import org.eclipse.edt.ide.ui.templates.parts.Part;
import org.eclipse.edt.ide.ui.templates.wizards.TemplateWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractRecordFromInputWizard
extends TemplateWizard
implements IPageChangingListener,
IMessageHandler {
    protected AbstractRecordFromStringInputPage inputPage;
    protected NewRecordSummaryPage summaryPage;
    protected IStructuredSelection selection;
    protected Part[] parts;
    protected List<String> messages = new ArrayList<String>();

    public AbstractRecordFromInputWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(EDTUIPlugin.getDefault().getDialogSettings());
    }

    public void addPages() {
        this.inputPage = this.createInputPage();
        this.addPage((IWizardPage)this.inputPage);
        List<String> urls = this.getSavedUrls();
        this.inputPage.setRecentUrls(urls.toArray(new String[urls.size()]));
        List<String> files = this.getSavedFilePaths();
        this.inputPage.setRecentFilePaths(files.toArray(new String[files.size()]));
        this.summaryPage = new NewRecordSummaryPage((ISelection)this.selection);
        this.addPage((IWizardPage)this.summaryPage);
    }

    protected abstract AbstractRecordFromStringInputPage createInputPage();

    protected abstract boolean processInput(Object var1);

    @Override
    public boolean performFinish() {
        if (this.inputPage.isInputNeedsProcessing()) {
            Object input = this.inputPage.getInput();
            if (input == null) {
                this.inputPage.setPageComplete(false);
            } else {
                if (!this.processInput(input)) {
                    this.inputPage.setPageComplete(false);
                    this.inputPage.setErrorMessage(this.buildMessageString());
                    return false;
                }
                this.inputPage.setInputNeedsProcessing(false);
            }
        }
        if (this.parts == null) {
            return false;
        }
        ((NewRecordWizard)this.getParentWizard()).setContentObj(new PartsWrapper(this.parts));
        if (this.inputPage.isUrlSource()) {
            String url = this.inputPage.getUrl();
            this.updateSavedUrls(url);
        } else if (this.inputPage.isFileSource()) {
            String filePath = this.inputPage.getFilePath();
            this.updateSavedFilePaths(filePath);
        }
        return true;
    }

    public void init(IWorkbench arg0, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void setParts(Part[] parts) {
        this.parts = parts;
        RecordOperation op = new RecordOperation(new RecordConfiguration(), null, new PartsWrapper(parts));
        try {
            this.summaryPage.setContent(op.getFileContents());
            this.summaryPage.setMessages(this.getFilteredMessages());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        if (wizardContainer != null) {
            ((WizardDialog)wizardContainer).addPageChangingListener((IPageChangingListener)this);
        }
    }

    public void handlePageChanging(PageChangingEvent event) {
        if (event.getCurrentPage() == this.inputPage && this.inputPage.isInputNeedsProcessing() && event.getTargetPage() == this.summaryPage) {
            Object input = this.inputPage.getInput();
            if (input == null) {
                this.inputPage.setPageComplete(false);
                event.doit = false;
            } else if (!this.processInput(input)) {
                event.doit = false;
                this.inputPage.setPageComplete(false);
                this.inputPage.setErrorMessage(this.buildMessageString());
            } else {
                this.inputPage.setInputNeedsProcessing(false);
            }
        }
    }

    @Override
    public List<String> getMessages() {
        return this.messages;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    @Override
    public void addMessage(String message) {
        if (this.messages == null) {
            this.messages = new ArrayList<String>();
        }
        this.messages.add(message);
    }

    private List<String> getFilteredMessages() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.messages != null) {
            for (String obj : this.messages) {
                if (ret.contains(obj.toString())) continue;
                ret.add(obj.toString());
            }
        }
        return ret;
    }

    private String buildMessageString() {
        String ret = "";
        if (this.messages != null) {
            Iterator<String> it = this.messages.iterator();
            while (it.hasNext()) {
                ret = String.valueOf(ret) + it.next() + "\n";
            }
        }
        return ret;
    }

    protected List<String> getSavedUrls() {
        ArrayList<String> savedUrls = new ArrayList<String>();
        IDialogSettings settings = this.getDialogSettings().getSection(this.getClass().getName());
        if (settings != null) {
            int i = 0;
            while (i < 10) {
                String url = settings.get(this.getClass() + ".url" + "_" + i);
                if (url != null && !url.trim().equals("")) {
                    savedUrls.add(url);
                }
                ++i;
            }
        }
        return savedUrls;
    }

    protected List<String> getSavedFilePaths() {
        ArrayList<String> savedFilePaths = new ArrayList<String>();
        IDialogSettings settings = this.getDialogSettings().getSection(this.getClass().getName());
        if (settings != null) {
            int i = 0;
            while (i < 10) {
                String filePath = settings.get(this.getClass() + ".file" + "_" + i);
                if (filePath != null && !filePath.trim().equals("")) {
                    savedFilePaths.add(filePath);
                }
                ++i;
            }
        }
        return savedFilePaths;
    }

    protected void updateSavedUrls(String url) {
        List<String> urls = this.getSavedUrls();
        if (urls.contains(url)) {
            urls.remove(url);
        }
        urls.add(0, url);
        IDialogSettings settings = this.getDialogSettings().getSection(this.getClass().getName());
        if (settings == null) {
            settings = this.getDialogSettings().addNewSection(this.getClass().getName());
        }
        int i = 0;
        while (i < 10) {
            settings.put(this.getClass() + ".url" + "_" + i, urls.size() > i ? urls.get(i).toString() : "");
            ++i;
        }
    }

    protected void updateSavedFilePaths(String filePath) {
        List<String> filePaths = this.getSavedFilePaths();
        if (filePaths.contains(filePath)) {
            filePaths.remove(filePath);
        }
        filePaths.add(0, filePath);
        IDialogSettings settings = this.getDialogSettings().getSection(this.getClass().getName());
        if (settings == null) {
            settings = this.getDialogSettings().addNewSection(this.getClass().getName());
        }
        int i = 0;
        while (i < 10) {
            settings.put(this.getClass() + ".file" + "_" + i, filePaths.size() > i ? filePaths.get(i).toString() : "");
            ++i;
        }
    }
}

