/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.rename;

import org.eclipse.edt.ide.ui.internal.RowLayouter;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.TextInputWizardPage;
import org.eclipse.edt.ide.ui.internal.refactoring.tagging.INameUpdating;
import org.eclipse.edt.ide.ui.internal.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class RenameInputWizardPage
extends TextInputWizardPage {
    private String fHelpContextID;
    private Button fUpdateReferences;

    public RenameInputWizardPage(String description, String contextHelpId, boolean isLastUserPage, String initialValue) {
        super(description, isLastUserPage, initialValue);
        this.fHelpContextID = contextHelpId;
    }

    public void createControl(Composite parent) {
        Composite superComposite = new Composite(parent, 0);
        this.setControl((Control)superComposite);
        this.initializeDialogUnits((Control)superComposite);
        superComposite.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(superComposite, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        RowLayouter layouter = new RowLayouter(2);
        Label label = new Label(composite, 0);
        label.setText(this.getLabelText());
        Text text = this.createTextInputField(composite);
        text.selectAll();
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(25);
        text.setLayoutData((Object)gd);
        layouter.perform((Control)label, (Control)text, 1);
        Label separator = new Label(composite, 0);
        GridData gridData = new GridData(4, 4, false, false);
        gridData.heightHint = 2;
        separator.setLayoutData((Object)gridData);
        this.convertWidthInCharsToPixels(2);
        this.addOptionalUpdateReferencesCheckbox(composite, layouter);
        this.addAdditionalOptions(composite, layouter);
        this.updateForcePreview();
        Dialog.applyDialogFont((Control)superComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.fHelpContextID);
    }

    protected void addAdditionalOptions(Composite composite, RowLayouter layouter) {
    }

    @Override
    public void setVisible(boolean visible) {
        String newName;
        INameUpdating nameUpdating;
        if (visible && (nameUpdating = (INameUpdating)this.getRefactoring().getAdapter(INameUpdating.class)) != null && (newName = this.getNewName(nameUpdating)) != null && newName.length() > 0 && !newName.equals(this.getInitialValue())) {
            Text textField = this.getTextField();
            textField.setText(newName);
            textField.setSelection(0, newName.length());
        }
        super.setVisible(visible);
    }

    protected String getNewName(INameUpdating nameUpdating) {
        return nameUpdating.getNewElementName();
    }

    protected boolean saveSettings() {
        if (this.getContainer() instanceof Dialog) {
            return ((Dialog)this.getContainer()).getReturnCode() == 0;
        }
        return true;
    }

    @Override
    public void dispose() {
        this.saveSettings();
        super.dispose();
    }

    private void addOptionalUpdateReferencesCheckbox(Composite result, RowLayouter layouter) {
        final IReferenceUpdating ref = (IReferenceUpdating)this.getRefactoring().getAdapter(IReferenceUpdating.class);
        if (ref == null || !ref.canEnableUpdateReferences()) {
            return;
        }
        String title = UINlsStrings.RenameInputWizardPage_update_references;
        boolean defaultValue = true;
        this.fUpdateReferences = RenameInputWizardPage.createCheckbox(result, title, defaultValue, layouter);
        ref.setUpdateReferences(this.fUpdateReferences.getSelection());
        this.fUpdateReferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ref.setUpdateReferences(RenameInputWizardPage.this.fUpdateReferences.getSelection());
            }
        });
    }

    protected String getLabelText() {
        return UINlsStrings.RenameInputWizardPage_new_name;
    }

    protected boolean getBooleanSetting(String key, boolean defaultValue) {
        String update = this.getRefactoringSettings().get(key);
        if (update != null) {
            return Boolean.valueOf(update);
        }
        return defaultValue;
    }

    protected void saveBooleanSetting(String key, Button checkBox) {
        if (checkBox != null) {
            this.getRefactoringSettings().put(key, checkBox.getSelection());
        }
    }

    private static Button createCheckbox(Composite parent, String title, boolean value, RowLayouter layouter) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(title);
        checkBox.setSelection(value);
        layouter.perform((Control)checkBox);
        return checkBox;
    }

    private void updateForcePreview() {
    }
}

