/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java_cup.runtime.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.core.ast.ErrorCorrectingParser;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Lexer;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.codemanipulation.ImportComparator;
import org.eclipse.edt.ide.ui.internal.editor.DocumentAdapter;
import org.eclipse.edt.ide.ui.internal.refactoring.changes.TextChangeCompatibility;
import org.eclipse.edt.ide.ui.internal.refactoring.util.TextChangeManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class ImportManager {
    IPackageFragment packageFragment;
    HashMap fileToImportInfoMap = new HashMap();

    public ImportManager(IPackageFragment packageFragment) {
        this.packageFragment = packageFragment;
    }

    public IPackageFragment getPackageFragment() {
        return this.packageFragment;
    }

    public ImportInfo getInfoFor(IEGLFile file) {
        ImportInfo info = (ImportInfo)this.fileToImportInfoMap.get(file);
        if (info == null) {
            info = new ImportInfo(file);
            this.fileToImportInfoMap.put(file, info);
        }
        return info;
    }

    public ImportInfo[] getImportInfos() {
        return this.fileToImportInfoMap.values().toArray(new ImportInfo[this.fileToImportInfoMap.keySet().size()]);
    }

    public void createChanges(TextChangeManager changeManager) {
        ImportInfo[] infos = this.getImportInfos();
        int i = 0;
        while (i < infos.length) {
            infos[i].createChanges(changeManager);
            ++i;
        }
    }

    class ImportInfo {
        IEGLFile eglFile;
        HashSet existingDecls;
        File fileAst;
        Set newImportStrings = new TreeSet(new ImportComparator());
        ImportDeclaration onDemandImport;

        public ImportInfo(IEGLFile eglFile) {
            this.eglFile = eglFile;
        }

        public File getFileAst() {
            if (this.fileAst == null) {
                this.fileAst = this.parseFile();
            }
            return this.fileAst;
        }

        private File parseFile() {
            try {
                IFile file = (IFile)this.getEglFile().getResource();
                BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents(true), file.getCharset()));
                ErrorCorrectingParser parser = new ErrorCorrectingParser((Scanner)new Lexer((Reader)reader));
                return (File)parser.parse().value;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public IEGLFile getEglFile() {
            return this.eglFile;
        }

        public ImportDeclaration[] getExistingDecls() {
            if (this.existingDecls == null) {
                this.existingDecls = new HashSet();
                if (this.getFileAst() != null) {
                    for (ImportDeclaration decl : this.getFileAst().getImportDeclarations()) {
                        if (decl.isOnDemand()) {
                            if (!decl.getName().getCanonicalName().equals(ImportManager.this.getPackageFragment().getElementName())) continue;
                            this.onDemandImport = decl;
                            continue;
                        }
                        String imp = this.getPackage(decl);
                        if (!imp.equals(ImportManager.this.getPackageFragment().getElementName())) continue;
                        this.existingDecls.add(decl);
                    }
                }
            }
            return this.existingDecls.toArray(new ImportDeclaration[this.existingDecls.size()]);
        }

        public void addImportForPart(String partName) {
            if (this.onDemandImport != null) {
                return;
            }
            String imp = ImportManager.this.getPackageFragment().getElementName();
            imp = imp.length() > 0 ? String.valueOf(imp) + "." + partName : partName;
            ImportDeclaration[] decls = this.getExistingDecls();
            int i = 0;
            while (i < decls.length) {
                if (this.getPackage(decls[i]).equals(ImportManager.this.getPackageFragment().getElementName()) && this.getPartName(decls[i]).equalsIgnoreCase(partName)) {
                    return;
                }
                ++i;
            }
            this.newImportStrings.add(imp);
        }

        private String getPackage(ImportDeclaration decl) {
            String pkg = decl.getName().getCanonicalName();
            if (decl.isOnDemand()) {
                return pkg;
            }
            int index = pkg.lastIndexOf(".");
            if (index > -1) {
                return pkg.substring(0, index);
            }
            return pkg;
        }

        private String getPartName(ImportDeclaration decl) {
            String pkg = decl.getName().getCanonicalName();
            if (decl.isOnDemand()) {
                return "*";
            }
            int index = pkg.lastIndexOf(".");
            if (index > -1) {
                return pkg.substring(index + 1, pkg.length());
            }
            return pkg;
        }

        public ImportDeclaration[] getDeclsToDelete() {
            if (this.newImportsOnDemand()) {
                return this.getExistingDecls();
            }
            return new ImportDeclaration[0];
        }

        public String[] getNewImports() {
            if (this.onDemandImport != null) {
                return new String[0];
            }
            if (this.newImportsOnDemand()) {
                return new String[]{ImportManager.this.getPackageFragment().getElementName()};
            }
            return this.newImportStrings.toArray(new String[this.newImportStrings.size()]);
        }

        public boolean newImportsOnDemand() {
            return ImportManager.this.getPackageFragment().getElementName().length() > 0 && this.getExistingDecls().length + this.newImportStrings.size() >= this.getOnDemandThreshold();
        }

        private int getOnDemandThreshold() {
            return EDTUIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.egl.ui.ondemandthreshold");
        }

        private void createChanges(TextChangeManager changeManager) {
            if (this.getFileAst() == null) {
                return;
            }
            boolean changedFile = false;
            ASTRewrite rewrite = ASTRewrite.create((File)this.getFileAst());
            ImportDeclaration[] decls = this.getDeclsToDelete();
            int i = 0;
            while (i < decls.length) {
                rewrite.removeNode((Node)decls[i]);
                changedFile = true;
                ++i;
            }
            String[] imps = this.getNewImports();
            int i2 = 0;
            while (i2 < imps.length) {
                rewrite.addImport(this.getFileAst(), imps[i2], this.newImportsOnDemand(), (Comparator)new ImportComparator());
                changedFile = true;
                ++i2;
            }
            if (!changedFile) {
                return;
            }
            IDocument doc = this.getDocument();
            if (doc != null) {
                TextEdit edit = rewrite.rewriteAST(doc);
                TextChangeCompatibility.addTextEdit(changeManager.get(this.getEglFile()), UINlsStrings.MoveRefactoring_updateImports, edit);
                return;
            }
        }

        private IDocument getDocument() {
            try {
                IEGLFile workingCopy = (IEGLFile)this.getEglFile().getWorkingCopy(null, EGLUI.getBufferFactory(), null);
                IBuffer buffer = workingCopy.getBuffer();
                if (buffer instanceof DocumentAdapter) {
                    return ((DocumentAdapter)buffer).getDocument();
                }
            }
            catch (EGLModelException e) {
                e.printStackTrace();
                EDTUIPlugin.log(e);
                return null;
            }
            return null;
        }
    }
}

