/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IReorgPolicy;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IReorgQueries;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ParentChecker;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ReorgUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public final class MoveProcessor
extends org.eclipse.ltk.core.refactoring.participants.MoveProcessor
implements IReorgDestinationValidator {
    private IReorgQueries fReorgQueries;
    private IReorgPolicy.IEGLMovePolicy fMovePolicy;
    private ICreateTargetQueries fCreateTargetQueries;
    private boolean fWasCanceled;
    private String fComment;

    public MoveProcessor(IReorgPolicy.IEGLMovePolicy policy) {
        this.fMovePolicy = policy;
    }

    protected Object getDestination() {
        IEGLElement je = this.fMovePolicy.getEGLElementDestination();
        if (je != null) {
            return je;
        }
        return this.fMovePolicy.getResourceDestination();
    }

    public Object[] getElements() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(Arrays.asList(this.fMovePolicy.getEGLElements()));
        result.addAll(Arrays.asList(this.fMovePolicy.getResources()));
        return result.toArray();
    }

    public String getIdentifier() {
        return this.getClass().getName();
    }

    public boolean isApplicable() throws CoreException {
        return this.fMovePolicy.canEnable();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return this.fMovePolicy.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), shared);
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return new String[]{"com.ibm.etools.egl.model.eglnature"};
    }

    public boolean wasCanceled() {
        return this.fWasCanceled;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus result = new RefactoringStatus();
            result.merge(RefactoringStatus.create((IStatus)MoveProcessor.checkInSync(ReorgUtils.getNotNulls(this.fMovePolicy.getResources()))));
            IResource[] eglResources = ReorgUtils.getResources(this.fMovePolicy.getEGLElements());
            result.merge(RefactoringStatus.create((IStatus)MoveProcessor.checkInSync(ReorgUtils.getNotNulls(eglResources))));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Object getCommonParentForInputElements() {
        return new ParentChecker(this.fMovePolicy.getResources(), this.fMovePolicy.getEGLElements()).getCommonParent();
    }

    public IEGLElement[] getEGLElements() {
        return this.fMovePolicy.getEGLElements();
    }

    public IResource[] getResources() {
        return this.fMovePolicy.getResources();
    }

    public RefactoringStatus setDestination(IEGLElement destination) throws EGLModelException {
        return this.fMovePolicy.setDestination(destination);
    }

    public RefactoringStatus setDestination(IResource destination) throws EGLModelException {
        return this.fMovePolicy.setDestination(destination);
    }

    @Override
    public boolean canChildrenBeDestinations(IEGLElement eglElement) {
        return this.fMovePolicy.canChildrenBeDestinations(eglElement);
    }

    @Override
    public boolean canChildrenBeDestinations(IResource resource) {
        return this.fMovePolicy.canChildrenBeDestinations(resource);
    }

    @Override
    public boolean canElementBeDestination(IEGLElement eglElement) {
        return this.fMovePolicy.canElementBeDestination(eglElement);
    }

    @Override
    public boolean canElementBeDestination(IResource resource) {
        return this.fMovePolicy.canElementBeDestination(resource);
    }

    public void setReorgQueries(IReorgQueries queries) {
        Assert.isNotNull((Object)queries);
        this.fReorgQueries = queries;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            Assert.isNotNull((Object)this.fReorgQueries);
            this.fWasCanceled = false;
            return this.fMovePolicy.checkFinalConditions(pm, context, this.fReorgQueries);
        }
        catch (OperationCanceledException e) {
            this.fWasCanceled = true;
            throw e;
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        Assert.isTrue((this.fMovePolicy.getEGLElementDestination() == null || this.fMovePolicy.getResourceDestination() == null ? 1 : 0) != 0);
        Assert.isTrue((this.fMovePolicy.getEGLElementDestination() != null || this.fMovePolicy.getResourceDestination() != null ? 1 : 0) != 0);
        try {
            CompositeChange result = new CompositeChange(UINlsStrings.EGLMoveProcessor_change_name);
            Change change = this.fMovePolicy.createChange(pm);
            if (change instanceof CompositeChange) {
                CompositeChange subComposite = (CompositeChange)change;
                result.merge(subComposite);
            } else {
                result.add(change);
            }
            CompositeChange compositeChange = result;
            return compositeChange;
        }
        finally {
            pm.done();
        }
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        return this.fMovePolicy.postCreateChange(participantChanges, pm);
    }

    public String getProcessorName() {
        return UINlsStrings.MoveRefactoring_0;
    }

    public boolean canUpdateReferences() {
        return this.fMovePolicy.canUpdateReferences();
    }

    public void setUpdateReferences(boolean update) {
        this.fMovePolicy.setUpdateReferences(update);
    }

    public boolean getUpdateReferences() {
        if (!this.canUpdateReferences()) {
            return false;
        }
        return this.fMovePolicy.getUpdateReferences();
    }

    public boolean canUpdateQualifiedNames() {
        return this.fMovePolicy.canUpdateQualifiedNames();
    }

    public boolean hasAllInputSet() {
        return this.fMovePolicy.hasAllInputSet();
    }

    public boolean hasDestinationSet() {
        return this.fMovePolicy.getEGLElementDestination() != null || this.fMovePolicy.getResourceDestination() != null;
    }

    public void setCreateTargetQueries(ICreateTargetQueries queries) {
        Assert.isNotNull((Object)queries);
        this.fCreateTargetQueries = queries;
    }

    public ICreateTargetQuery getCreateTargetQuery() {
        return this.fMovePolicy.getCreateTargetQuery(this.fCreateTargetQueries);
    }

    public boolean isTextualMove() {
        return this.fMovePolicy.isTextualMove();
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        return null;
    }

    public boolean canEnableComment() {
        return true;
    }

    public String getComment() {
        return this.fComment;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }

    public static IStatus checkInSync(IResource resource) {
        return MoveProcessor.checkInSync(new IResource[]{resource});
    }

    public static IStatus checkInSync(IResource[] resources) {
        IStatus result = null;
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!resource.isSynchronized(2)) {
                result = MoveProcessor.addOutOfSync(result, resource);
            }
            ++i;
        }
        if (result != null) {
            return result;
        }
        return new Status(0, EDTUIPlugin.getPluginId(), 0, "", null);
    }

    private static IStatus addOutOfSync(IStatus status, IResource resource) {
        Status entry = new Status(4, "org.eclipse.core.resources", 274, MessageFormat.format((String)UINlsStrings.Resources_outOfSync, (Object[])new String[]{resource.getFullPath().toString()}), null);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add((IStatus)entry);
            return status;
        }
        MultiStatus result = new MultiStatus("org.eclipse.core.resources", 274, UINlsStrings.Resources_outOfSyncResources, null);
        result.add(status);
        result.add((IStatus)entry);
        return result;
    }
}

