/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IConfirmQuery;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IReorgQueries;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ReorgUtils;

class ReadOnlyResourceFinder {
    private ReadOnlyResourceFinder() {
    }

    static boolean confirmDeleteOfReadOnlyElements(IEGLElement[] eglElements, IResource[] resources, IReorgQueries queries) throws CoreException {
        String queryTitle = UINlsStrings.ReadOnlyResourceFinder_0;
        String question = UINlsStrings.ReadOnlyResourceFinder_1;
        return ReadOnlyResourceFinder.confirmOperationOnReadOnlyElements(queryTitle, question, eglElements, resources, queries);
    }

    static boolean confirmMoveOfReadOnlyElements(IEGLElement[] eglElements, IResource[] resources, IReorgQueries queries) throws CoreException {
        String queryTitle = UINlsStrings.ReadOnlyResourceFinder_2;
        String question = UINlsStrings.ReadOnlyResourceFinder_3;
        return ReadOnlyResourceFinder.confirmOperationOnReadOnlyElements(queryTitle, question, eglElements, resources, queries);
    }

    private static boolean confirmOperationOnReadOnlyElements(String queryTitle, String question, IEGLElement[] eglElements, IResource[] resources, IReorgQueries queries) throws CoreException {
        boolean hasReadOnlyResources = ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(eglElements, resources);
        if (hasReadOnlyResources) {
            IConfirmQuery query = queries.createYesNoQuery(queryTitle, false, 5);
            return query.confirm(question);
        }
        return true;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IEGLElement[] eglElements, IResource[] resources) throws CoreException {
        return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(resources) || ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(eglElements);
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IEGLElement[] eglElements) throws CoreException {
        int i = 0;
        while (i < eglElements.length) {
            if (ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(eglElements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IEGLElement eglElement) throws CoreException {
        switch (eglElement.getElementType()) {
            case 6: {
                IResource resource = ReorgUtils.getResource((Object)eglElement);
                return resource != null && ReorgUtils.isReadOnly(resource);
            }
            case 4: {
                IResource packResource = ReorgUtils.getResource((Object)eglElement);
                if (packResource == null) {
                    return false;
                }
                IPackageFragment pack = (IPackageFragment)eglElement;
                if (ReorgUtils.isReadOnly(packResource)) {
                    return true;
                }
                return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(pack.getChildren());
            }
            case 3: {
                IPackageFragmentRoot root = (IPackageFragmentRoot)eglElement;
                if (root.isArchive()) {
                    return false;
                }
                IResource pfrResource = ReorgUtils.getResource((Object)eglElement);
                if (pfrResource == null) {
                    return false;
                }
                if (ReorgUtils.isReadOnly(pfrResource)) {
                    return true;
                }
                return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(root.getChildren());
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return false;
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IResource[] resources) throws CoreException {
        int i = 0;
        while (i < resources.length) {
            if (ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(resources[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IResource resource) throws CoreException {
        if (resource.isLinked()) {
            return false;
        }
        if (ReorgUtils.isReadOnly(resource)) {
            return true;
        }
        if (resource instanceof IContainer) {
            return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(((IContainer)resource).members());
        }
        return false;
    }
}

