/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PackageDeclaration;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.ide.core.ast.GetNodeAtOffsetVisitor;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompiler;
import org.eclipse.edt.ide.core.internal.model.IEGLDocumentAdapter;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IField;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IImportContainer;
import org.eclipse.edt.ide.core.model.IImportDeclaration;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IOpenable;
import org.eclipse.edt.ide.core.model.IPackageDeclaration;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.ISourceReference;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.Strings;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.codemanipulation.OrganizeImportsOperation;
import org.eclipse.edt.ide.ui.internal.codemanipulation.OrganizeImportsVisitor;
import org.eclipse.edt.ide.ui.internal.editor.DocumentAdapter;
import org.eclipse.edt.ide.ui.internal.refactoring.Checks;
import org.eclipse.edt.ide.ui.internal.refactoring.changes.CopyEGLFileChange;
import org.eclipse.edt.ide.ui.internal.refactoring.changes.CopyResourceChange;
import org.eclipse.edt.ide.ui.internal.refactoring.changes.CreateCopyOfEGLFileChange;
import org.eclipse.edt.ide.ui.internal.refactoring.changes.EGLFileChange;
import org.eclipse.edt.ide.ui.internal.refactoring.changes.MoveEGLFileChange;
import org.eclipse.edt.ide.ui.internal.refactoring.changes.TextChangeCompatibility;
import org.eclipse.edt.ide.ui.internal.refactoring.rename.RenamePartProcessor;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ArrayTypeConverter;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.CopyModifications;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.INewNameQueries;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.INewNameQuery;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IReorgPolicy;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IReorgQueries;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.MoveEGLFileUpdateCreator;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.MoveModifications;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.MoveReferenceUpdater;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.OverwriteHelper;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ParentChecker;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ReadOnlyResourceFinder;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.RefactoringModifications;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ReorgUtils;
import org.eclipse.edt.ide.ui.internal.refactoring.util.TextChangeManager;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.TextEdit;

public class ReorgPolicyFactory {
    private ReorgPolicyFactory() {
    }

    public static IReorgPolicy.IEGLCopyPolicy createCopyPolicy(IResource[] resources, IEGLElement[] eglElements) throws EGLModelException {
        return (IReorgPolicy.IEGLCopyPolicy)ReorgPolicyFactory.createReorgPolicy(true, resources, eglElements);
    }

    public static IReorgPolicy.IEGLMovePolicy createMovePolicy(IResource[] resources, IEGLElement[] eglElements) throws EGLModelException {
        return (IReorgPolicy.IEGLMovePolicy)ReorgPolicyFactory.createReorgPolicy(false, resources, eglElements);
    }

    private static IReorgPolicy createReorgPolicy(boolean copy, IResource[] selectedResources, IEGLElement[] selectedEGLElements) throws EGLModelException {
        Object[] eglElements;
        ReorgPolicy NO = copy ? new NoCopyPolicy() : new NoMovePolicy();
        ActualSelectionComputer selectionComputer = new ActualSelectionComputer(selectedEGLElements, selectedResources);
        Object[] resources = selectionComputer.getActualResourcesToReorg();
        if (ReorgPolicyFactory.isNothingToReorg((IResource[])resources, (IEGLElement[])(eglElements = selectionComputer.getActualEGLElementsToReorg())) || ReorgPolicyFactory.containsNull(resources) || ReorgPolicyFactory.containsNull(eglElements) || ReorgUtils.isArchiveMember((IEGLElement[])eglElements) || ReorgUtils.hasElementsOfType((IEGLElement[])eglElements, 2) || ReorgUtils.hasElementsOfType((IEGLElement[])eglElements, 1) || ReorgUtils.hasElementsOfType((IResource[])resources, 12) || !ReorgPolicyFactory.haveCommonParent((IResource[])resources, (IEGLElement[])eglElements)) {
            return NO;
        }
        if (ReorgUtils.hasElementsOfType((IEGLElement[])eglElements, 6)) {
            if (ReorgUtils.hasElementsNotOfType((IEGLElement[])eglElements, 6)) {
                return NO;
            }
            if (ReorgUtils.hasElementsNotOfType((IResource[])resources, 3)) {
                return NO;
            }
            if (copy) {
                return new CopyEGLFilesPolicy(ReorgUtils.getFiles((IResource[])resources), ReorgUtils.getFolders((IResource[])resources), ArrayTypeConverter.toEGLFileArray(eglElements));
            }
            return new MoveEGLFilesPolicy(ReorgUtils.getFiles((IResource[])resources), ReorgUtils.getFolders((IResource[])resources), ArrayTypeConverter.toEGLFileArray(eglElements));
        }
        if (ReorgPolicyFactory.hasElementsSmallerThanCuOrClassFile((IEGLElement[])eglElements)) {
            Assert.isTrue((resources.length == 0 ? 1 : 0) != 0);
            Assert.isTrue((!ReorgUtils.hasElementsOfType((IEGLElement[])eglElements, 6) ? 1 : 0) != 0);
            Assert.isTrue((!ReorgUtils.hasElementsOfType((IEGLElement[])eglElements, 7) ? 1 : 0) != 0);
            Assert.isTrue((!ReorgPolicyFactory.hasElementsLargerThanCuOrClassFile((IEGLElement[])eglElements) ? 1 : 0) != 0);
            if (copy) {
                return NO;
            }
            return new MovePartsPolicy((IEGLElement[])eglElements);
        }
        return NO;
    }

    private static boolean containsNull(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasElementsSmallerThanCuOrClassFile(IEGLElement[] eglElements) {
        int i = 0;
        while (i < eglElements.length) {
            if (ReorgUtils.isInsideEGLFile(eglElements[i])) {
                return true;
            }
            if (ReorgUtils.isInsideIRFile(eglElements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasElementsLargerThanCuOrClassFile(IEGLElement[] eglElements) {
        int i = 0;
        while (i < eglElements.length) {
            if (!ReorgUtils.isInsideEGLFile(eglElements[i]) && !ReorgUtils.isInsideIRFile(eglElements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean haveCommonParent(IResource[] resources, IEGLElement[] eglElements) {
        return new ParentChecker(resources, eglElements).haveCommonParent();
    }

    private static boolean isNothingToReorg(IResource[] resources, IEGLElement[] eglElements) {
        return resources.length + eglElements.length == 0;
    }

    private static class ActualSelectionComputer {
        private final IResource[] fResources;
        private final IEGLElement[] fEGLElements;

        public ActualSelectionComputer(IEGLElement[] eglElements, IResource[] resources) {
            this.fEGLElements = eglElements;
            this.fResources = resources;
        }

        public IEGLElement[] getActualEGLElementsToReorg() throws EGLModelException {
            ArrayList<IEGLElement> result = new ArrayList<IEGLElement>();
            int i = 0;
            while (i < this.fEGLElements.length) {
                IEGLElement element = this.fEGLElements[i];
                if (element != null && !ReorgUtils.isDeletedFromEditor(element) && !result.contains(element)) {
                    result.add(element);
                }
                ++i;
            }
            return result.toArray(new IEGLElement[result.size()]);
        }

        public IResource[] getActualResourcesToReorg() {
            HashSet<IEGLElement> eglElementSet = new HashSet<IEGLElement>(Arrays.asList(this.fEGLElements));
            ArrayList<IResource> result = new ArrayList<IResource>();
            int i = 0;
            while (i < this.fResources.length) {
                IEGLElement element;
                if (!(this.fResources[i] == null || (element = EGLCore.create((IResource)this.fResources[i])) != null && element.exists() && eglElementSet.contains(element) || result.contains(this.fResources[i]))) {
                    result.add(this.fResources[i]);
                }
                ++i;
            }
            return result.toArray(new IResource[result.size()]);
        }
    }

    private static class CopyEGLFilesPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.IEGLCopyPolicy {
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        CopyEGLFilesPolicy(IFile[] files, IFolder[] folders, IEGLFile[] cus) {
            super(files, folders, cus);
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments jArgs = new CopyArguments(this.getDestination(), this.fReorgExecutionLog);
            CopyArguments rArgs = new CopyArguments((Object)this.getDestinationAsContainer(), this.fReorgExecutionLog);
            IEGLFile[] cus = this.getCus();
            int i = 0;
            while (i < cus.length) {
                this.fModifications.copy(cus[i], jArgs, rArgs);
                ++i;
            }
            IResource[] resources = ReorgUtils.union((IResource[])this.getFiles(), (IResource[])this.getFolders());
            int i2 = 0;
            while (i2 < resources.length) {
                this.fModifications.copy(resources[i2], rArgs);
                ++i2;
            }
            return this.fModifications;
        }

        private Object getDestination() throws EGLModelException {
            IPackageFragment result = this.getDestinationAsPackageFragment();
            if (result != null) {
                return result;
            }
            return this.getDestinationAsContainer();
        }

        @Override
        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) throws EGLModelException {
            IFile[] file = this.getFiles();
            IFolder[] folders = this.getFolders();
            IEGLFile[] cus = this.getCus();
            pm.beginTask("", cus.length + file.length + folders.length);
            NewNameProposer nameProposer = new NewNameProposer();
            CompositeChange composite = new CompositeChange(UINlsStrings.ReorgPolicy_copy);
            composite.markAsSynthetic();
            int i = 0;
            while (i < cus.length) {
                composite.add(this.createChange(cus[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < file.length) {
                composite.add(this.createChange((IResource)file[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < folders.length) {
                composite.add(this.createChange((IResource)folders[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        private Change createChange(IEGLFile unit, NewNameProposer nameProposer, INewNameQueries copyQueries) throws EGLModelException {
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack != null) {
                return this.copyCuToPackage(unit, pack, nameProposer, copyQueries);
            }
            IContainer container = this.getDestinationAsContainer();
            return CopyEGLFilesPolicy.copyFileToContainer(unit, container, nameProposer, copyQueries);
        }

        private static Change copyFileToContainer(IEGLFile cu, IContainer dest, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IResource resource = ReorgUtils.getResource(cu);
            return CopyEGLFilesPolicy.createCopyResourceChange(resource, nameProposer, copyQueries, dest);
        }

        private Change createChange(IResource resource, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IContainer dest = this.getDestinationAsContainer();
            return CopyEGLFilesPolicy.createCopyResourceChange(resource, nameProposer, copyQueries, dest);
        }

        private static Change createCopyResourceChange(IResource resource, NewNameProposer nameProposer, INewNameQueries copyQueries, IContainer destination) {
            if (resource == null || destination == null) {
                return new NullChange();
            }
            String name = nameProposer.createNewName(resource, destination);
            INewNameQuery nameQuery = name == null ? copyQueries.createNullQuery() : copyQueries.createNewResourceNameQuery(resource, name);
            return new CopyResourceChange(resource, destination, nameQuery);
        }

        private Change copyCuToPackage(IEGLFile cu, IPackageFragment dest, NewNameProposer nameProposer, INewNameQueries copyQueries) throws EGLModelException {
            IResource res = ReorgUtils.getResource(cu);
            if (res != null && res.isLinked() && dest.getResource() instanceof IContainer) {
                return CopyEGLFilesPolicy.copyFileToContainer(cu, (IContainer)dest.getResource(), nameProposer, copyQueries);
            }
            String newName = nameProposer.createNewName(cu, dest);
            CopyEGLFileChange simpleCopy = new CopyEGLFileChange(cu, dest, copyQueries.createStaticQuery(newName));
            if (newName == null || newName.equals(cu.getElementName())) {
                return simpleCopy;
            }
            try {
                IPath newPath = cu.getResource().getParent().getFullPath().append(newName);
                INewNameQuery nameQuery = copyQueries.createNewEGLFileNameQuery(cu, newName);
                return new CreateCopyOfEGLFileChange(newPath, cu.getSource(), cu, nameQuery);
            }
            catch (CoreException coreException) {
                return simpleCopy;
            }
        }
    }

    private static abstract class FilesFoldersAndCusReorgPolicy
    extends ReorgPolicy {
        private IEGLFile[] fCus;
        private IFolder[] fFolders;
        private IFile[] fFiles;
        private HashMap documentandRewriteMap = new HashMap();

        public FilesFoldersAndCusReorgPolicy(IFile[] files, IFolder[] folders, IEGLFile[] cus) {
            this.fFiles = files;
            this.fFolders = folders;
            this.fCus = cus;
        }

        @Override
        protected RefactoringStatus verifyDestination(IEGLElement eglElement) throws EGLModelException {
            IOpenable openable;
            Assert.isNotNull((Object)eglElement);
            if (!eglElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_doesnotexist0);
            }
            if (eglElement instanceof IEGLModel) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_jmodel);
            }
            if (eglElement.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_readonly);
            }
            if (!eglElement.isStructureKnown()) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_structure);
            }
            if (eglElement instanceof IOpenable && !(openable = (IOpenable)eglElement).isConsistent()) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_inconsistent);
            }
            if (eglElement instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)eglElement;
                if (root.isArchive()) {
                    return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_archive);
                }
                if (root.isExternal()) {
                    return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_external);
                }
            }
            if (ReorgUtils.isInsideEGLFile(eglElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_cannot);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null || this.isChildOfOrEqualToAnyFolder((IResource)destinationAsContainer)) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(eglElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource resource) throws EGLModelException {
            Assert.isNotNull((Object)resource);
            if (!resource.exists() || resource.isPhantom()) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_phantom);
            }
            if (!resource.isAccessible()) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_inaccessible);
            }
            Assert.isTrue((resource.getType() != 8 ? 1 : 0) != 0);
            if (this.isChildOfOrEqualToAnyFolder(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }

        private boolean isChildOfOrEqualToAnyFolder(IResource resource) {
            int i = 0;
            while (i < this.fFolders.length) {
                IFolder folder = this.fFolders[i];
                if (folder.equals((Object)resource) || ParentChecker.isDescendantOf(resource, (IResource)folder)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean canChildrenBeDestinations(IEGLElement eglElement) {
            switch (eglElement.getElementType()) {
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canChildrenBeDestinations(IResource resource) {
            return resource instanceof IContainer;
        }

        @Override
        public boolean canElementBeDestination(IEGLElement eglElement) {
            switch (eglElement.getElementType()) {
                case 4: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canElementBeDestination(IResource resource) {
            return resource instanceof IContainer;
        }

        private static IContainer getAsContainer(IResource resDest) {
            if (resDest instanceof IContainer) {
                return (IContainer)resDest;
            }
            if (resDest instanceof IFile) {
                return ((IFile)resDest).getParent();
            }
            return null;
        }

        protected final IContainer getDestinationAsContainer() {
            IResource resDest = this.getResourceDestination();
            if (resDest != null) {
                return FilesFoldersAndCusReorgPolicy.getAsContainer(resDest);
            }
            IEGLElement jelDest = this.getEGLElementDestination();
            Assert.isNotNull((Object)jelDest);
            return FilesFoldersAndCusReorgPolicy.getAsContainer(ReorgUtils.getResource((Object)jelDest));
        }

        protected final IEGLElement getDestinationContainerAsEGLElement() {
            if (this.getEGLElementDestination() != null) {
                return this.getEGLElementDestination();
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null) {
                return null;
            }
            IEGLElement je = EGLCore.create((IResource)destinationAsContainer);
            if (je != null && je.exists()) {
                return je;
            }
            return null;
        }

        protected final IPackageFragment getDestinationAsPackageFragment() throws EGLModelException {
            IPackageFragment EGLAsPackage = FilesFoldersAndCusReorgPolicy.getEGLDestinationAsPackageFragment(this.getEGLElementDestination());
            if (EGLAsPackage != null) {
                return EGLAsPackage;
            }
            return FilesFoldersAndCusReorgPolicy.getResourceDestinationAsPackageFragment(this.getResourceDestination());
        }

        private static IPackageFragment getEGLDestinationAsPackageFragment(IEGLElement eglDest) throws EGLModelException {
            if (eglDest == null || !eglDest.exists()) {
                return null;
            }
            if (eglDest instanceof IPackageFragment) {
                return (IPackageFragment)eglDest;
            }
            if (eglDest instanceof IPackageFragmentRoot) {
                return ((IPackageFragmentRoot)eglDest).getPackageFragment("");
            }
            if (eglDest instanceof IEGLProject) {
                try {
                    IPackageFragmentRoot root = ReorgUtils.getCorrespondingPackageFragmentRoot((IEGLProject)eglDest);
                    if (root != null) {
                        return root.getPackageFragment("");
                    }
                }
                catch (EGLModelException eGLModelException) {}
            }
            return (IPackageFragment)eglDest.getAncestor(4);
        }

        private static IPackageFragment getResourceDestinationAsPackageFragment(IResource resource) throws EGLModelException {
            if (resource instanceof IFile) {
                return FilesFoldersAndCusReorgPolicy.getEGLDestinationAsPackageFragment(EGLCore.create((IResource)resource.getParent()));
            }
            return null;
        }

        @Override
        public final IEGLElement[] getEGLElements() {
            return this.fCus;
        }

        @Override
        public final IResource[] getResources() {
            return ReorgUtils.union((IResource[])this.fFiles, (IResource[])this.fFolders);
        }

        protected boolean containsLinkedResources() {
            return ReorgUtils.containsLinkedResources((IResource[])this.fFiles) || ReorgUtils.containsLinkedResources((IResource[])this.fFolders) || ReorgUtils.containsLinkedResources((IEGLElement[])this.fCus);
        }

        protected final IFolder[] getFolders() {
            return this.fFolders;
        }

        protected final IFile[] getFiles() {
            return this.fFiles;
        }

        protected final IEGLFile[] getCus() {
            return this.fCus;
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
            this.confirmOverwritting(reorgQueries);
            return status;
        }

        private void confirmOverwritting(IReorgQueries reorgQueries) throws EGLModelException {
            OverwriteHelper oh = new OverwriteHelper();
            oh.setFiles(this.fFiles);
            oh.setFolders(this.fFolders);
            oh.setCus(this.fCus);
            IPackageFragment destPack = this.getDestinationAsPackageFragment();
            if (destPack != null) {
                oh.confirmOverwritting(reorgQueries, (IEGLElement)destPack);
            } else {
                IContainer destinationAsContainer = this.getDestinationAsContainer();
                if (destinationAsContainer != null) {
                    oh.confirmOverwritting(reorgQueries, (IResource)destinationAsContainer);
                }
            }
            this.fFiles = oh.getFilesWithoutUnconfirmedOnes();
            this.fFolders = oh.getFoldersWithoutUnconfirmedOnes();
            this.fCus = oh.getCusWithoutUnconfirmedOnes();
        }

        protected DocumentAndRewrite getDocumentAndRewrite(IEGLFile file) {
            IEGLDocument doc;
            DocumentAndRewrite dnr = (DocumentAndRewrite)this.documentandRewriteMap.get(file);
            if (dnr == null && (doc = this.getDocument(file)) != null) {
                dnr = new DocumentAndRewrite(this.getDocument(file));
                this.documentandRewriteMap.put(file, dnr);
            }
            return dnr;
        }

        protected void createUpdatePackageChange(IEGLFile cu, IPackageFragment pack, TextChangeManager changeManager) {
            DocumentAndRewrite dnr = this.getDocumentAndRewrite(cu);
            if (dnr == null) {
                return;
            }
            File ast = dnr.getDocument().getNewModelEGLFile();
            if (ast == null) {
                return;
            }
            boolean defaultPkg = pack.getElementName().length() == 0;
            PackageDeclaration pkgNode = FilesFoldersAndCusReorgPolicy.getPackageNode(ast);
            if (defaultPkg) {
                if (pkgNode == null) {
                    return;
                }
                dnr.getRewrite().removeNode((Node)pkgNode);
            } else if (pkgNode == null) {
                dnr.getRewrite().addPackage(ast, pack.getElementName());
            } else {
                if (pkgNode.getName().getCanonicalName().equals(pack.getElementName())) {
                    return;
                }
                dnr.getRewrite().rename(pkgNode.getName(), pack.getElementName());
            }
            TextEdit edit = dnr.getRewrite().rewriteAST((IDocument)dnr.getDocument());
            TextChangeCompatibility.addTextEdit(changeManager.get(cu), UINlsStrings.MoveRefactoring_updatePackage, edit);
            dnr.setRewrite(null);
        }

        protected IEGLDocument getDocument(IEGLFile cu) {
            try {
                IEGLFile workingCopy = (IEGLFile)cu.getWorkingCopy(null, EGLUI.getBufferFactory(), null);
                IBuffer buffer = workingCopy.getBuffer();
                if (buffer instanceof DocumentAdapter) {
                    return (IEGLDocument)((DocumentAdapter)buffer).getDocument();
                }
            }
            catch (EGLModelException e) {
                e.printStackTrace();
                EDTUIPlugin.log(e);
                return null;
            }
            return null;
        }

        protected static PackageDeclaration getPackageNode(File fileAst) {
            if (fileAst.hasPackageDeclaration()) {
                return fileAst.getPackageDeclaration();
            }
            return null;
        }

        protected static class DocumentAndRewrite {
            IEGLDocument document;
            ASTRewrite rewrite;

            public DocumentAndRewrite(IEGLDocument document) {
                this.document = document;
            }

            public IEGLDocument getDocument() {
                return this.document;
            }

            public ASTRewrite getRewrite() {
                if (this.rewrite == null) {
                    this.rewrite = ASTRewrite.create((File)this.document.getNewModelEGLFile());
                }
                return this.rewrite;
            }

            public void setRewrite(ASTRewrite rw) {
                this.rewrite = rw;
            }
        }
    }

    private static class MoveEGLFilesPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.IEGLMovePolicy {
        private boolean fUpdateReferences = true;
        private String fFilePatterns;
        private TextChangeManager fChangeManager;
        private MoveModifications fModifications;
        private IPart[] fParts;

        MoveEGLFilesPolicy(IFile[] files, IFolder[] folders, IEGLFile[] cus) {
            super(files, folders, cus);
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            int i;
            boolean updateReferenes;
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            IContainer container = this.getDestinationAsContainer();
            Object unitDestination = null;
            unitDestination = pack != null ? pack : container;
            boolean bl = updateReferenes = this.canUpdateReferences() && this.getUpdateReferences();
            if (unitDestination != null) {
                IEGLFile[] units = this.getCus();
                i = 0;
                while (i < units.length) {
                    this.fModifications.move(units[i], new MoveArguments(unitDestination, updateReferenes));
                    ++i;
                }
            }
            if (container != null) {
                IFile[] files = this.getFiles();
                i = 0;
                while (i < files.length) {
                    this.fModifications.move((IResource)files[i], new MoveArguments((Object)container, updateReferenes));
                    ++i;
                }
                IFolder[] folders = this.getFolders();
                int i2 = 0;
                while (i2 < folders.length) {
                    this.fModifications.move((IResource)folders[i2], new MoveArguments((Object)container, updateReferenes));
                    ++i2;
                }
            }
            return this.fModifications;
        }

        @Override
        protected RefactoringStatus verifyDestination(IEGLElement destination) throws EGLModelException {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = new ParentChecker(this.getResources(), this.getEGLElements()).getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_parent);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer != null && destinationAsContainer.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_parent);
            }
            IPackageFragment destinationAsPackage = this.getDestinationAsPackageFragment();
            if (destinationAsPackage != null && destinationAsPackage.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_parent);
            }
            return superStatus;
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource destination) throws EGLModelException {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = this.getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_parent);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer != null && destinationAsContainer.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_parent);
            }
            IEGLElement destinationContainerAsPackage = this.getDestinationContainerAsEGLElement();
            if (destinationContainerAsPackage != null && destinationContainerAsPackage.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_parent);
            }
            return superStatus;
        }

        private Object getCommonParent() {
            return new ParentChecker(this.getResources(), this.getEGLElements()).getCommonParent();
        }

        @Override
        public Change createChange(IProgressMonitor pm) throws EGLModelException {
            if (!this.fUpdateReferences) {
                if (this.fChangeManager == null) {
                    this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), new RefactoringStatus());
                }
                CompositeChange composite = new CompositeChange(UINlsStrings.ReorgPolicy_move);
                CompositeChange fileMove = this.createSimpleMoveChange(pm, this.fChangeManager);
                composite.merge(new CompositeChange(UINlsStrings.MoveRefactoring_reorganize_elements, (Change[])this.fChangeManager.getAllChanges()));
                composite.merge(fileMove);
                return composite;
            }
            return this.createReferenceUpdatingMoveChange(pm);
        }

        @Override
        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        private Change createReferenceUpdatingMoveChange(IProgressMonitor pm) throws EGLModelException {
            pm.beginTask("", 2);
            try {
                CompositeChange composite = new CompositeChange(UINlsStrings.ReorgPolicy_move);
                composite.markAsSynthetic();
                if (this.fChangeManager == null) {
                    this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), new RefactoringStatus());
                }
                this.createReferenceChanges(pm, this.fChangeManager);
                this.createAddImportsChanges(pm, this.fChangeManager);
                RefactoringStatus status = Checks.validateModifiedFiles(this.getAllModifiedFiles(), null);
                if (status.hasFatalError()) {
                    this.fChangeManager = new TextChangeManager();
                }
                CompositeChange fileMove = this.createSimpleMoveChange((IProgressMonitor)new SubProgressMonitor(pm, 1), this.fChangeManager);
                composite.merge(new CompositeChange(UINlsStrings.MoveRefactoring_reorganize_elements, (Change[])this.fChangeManager.getAllChanges()));
                composite.merge(fileMove);
                CompositeChange compositeChange = composite;
                return compositeChange;
            }
            finally {
                pm.done();
            }
        }

        private void createAddImportsChanges(IProgressMonitor pm, TextChangeManager changeManager) throws EGLModelException {
            IEGLFile[] files = this.getCus();
            int i = 0;
            while (i < files.length) {
                FilesFoldersAndCusReorgPolicy.DocumentAndRewrite dnr = this.getDocumentAndRewrite(files[i]);
                if (dnr != null) {
                    ASTRewrite rewrite = dnr.getRewrite();
                    OrganizeImportsOperation.OrganizedImportSection importSection = this.createImportSection(files[i]);
                    if (importSection != null) {
                        IPart[] parts = files[i].getParts();
                        int j = 0;
                        while (j < parts.length) {
                            this.addImportsToReferencedTypes(parts[j].getElementName(), files[i], importSection, pm);
                            ++j;
                        }
                        importSection.addImportsToASTRewrite(rewrite, dnr.getDocument().getNewModelEGLFile());
                    }
                    this.removeImportsForNewPackage(files[i]);
                    TextEdit edit = rewrite.rewriteAST((IDocument)dnr.getDocument());
                    TextChangeCompatibility.addTextEdit(changeManager.get(files[i]), UINlsStrings.MoveRefactoring_updateImports, edit);
                    dnr.setRewrite(null);
                }
                ++i;
            }
        }

        private void addImportsToReferencedTypes(String partName, final IEGLFile sourceCu, final OrganizeImportsOperation.OrganizedImportSection importSection, IProgressMonitor pm) throws EGLModelException {
            IPackageFragment packageFragment = (IPackageFragment)sourceCu.getAncestor(4);
            String packageName = packageFragment.isDefaultPackage() ? "" : packageFragment.getElementName();
            WorkingCopyCompiler.getInstance().compilePart(sourceCu.getEGLProject().getProject(), packageName, (IFile)sourceCu.getResource(), new IWorkingCopy[]{(IWorkingCopy)sourceCu.getWorkingCopy(pm, EGLUI.getBufferFactory(), null)}, partName, new IWorkingCopyCompileRequestor(){

                public void acceptResult(WorkingCopyCompilationResult result) {
                    Part boundPart = (Part)result.getBoundPart();
                    OrganizeImportsVisitor organizeImportsVisitor = new OrganizeImportsVisitor(importSection, new HashMap(), new HashSet(), null, sourceCu.getEGLProject().getProject());
                    organizeImportsVisitor.setCurrentPartName(boundPart.getName());
                    boundPart.accept((IASTVisitor)organizeImportsVisitor);
                    MoveEGLFilesPolicy.this.removeReferencesToNewPackage(boundPart, sourceCu);
                }
            });
        }

        private void removeReferencesToNewPackage(Part boundPart, IEGLFile sourceCU) {
            final FilesFoldersAndCusReorgPolicy.DocumentAndRewrite dnr = this.getDocumentAndRewrite(sourceCU);
            if (dnr == null) {
                return;
            }
            String temp = null;
            try {
                temp = this.getDestinationAsPackageFragment().getElementName();
            }
            catch (EGLModelException eGLModelException) {
                return;
            }
            if (temp.length() == 0) {
                return;
            }
            final String newPkg = temp;
            boundPart.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(QualifiedName qualifiedName) {
                    if (newPkg.equalsIgnoreCase(qualifiedName.getQualifier().getCanonicalName())) {
                        Object qualBinding = qualifiedName.getQualifier().resolveElement();
                        if (!(qualBinding instanceof IPackageBinding)) {
                            return false;
                        }
                        Object nameBinding = qualifiedName.resolveElement();
                        if (nameBinding == null || !(nameBinding instanceof IPackageBinding)) {
                            GetNodeAtOffsetVisitor visitor = new GetNodeAtOffsetVisitor(qualifiedName.getOffset(), qualifiedName.getLength());
                            dnr.getDocument().getNewModelEGLFile().accept((IASTVisitor)visitor);
                            Node node = visitor.getNode();
                            if (node instanceof QualifiedName) {
                                QualifiedName foundName = (QualifiedName)node;
                                dnr.getRewrite().rename((Name)foundName, qualifiedName.getCaseSensitiveIdentifier());
                            }
                        }
                        return false;
                    }
                    return true;
                }
            });
        }

        private void removeImportsForNewPackage(IEGLFile sourceCu) {
            FilesFoldersAndCusReorgPolicy.DocumentAndRewrite dnr = this.getDocumentAndRewrite(sourceCu);
            if (dnr == null) {
                return;
            }
            String newPkg = null;
            try {
                IPackageFragment destinationAsPackageFragment = this.getDestinationAsPackageFragment();
                if (destinationAsPackageFragment != null) {
                    newPkg = destinationAsPackageFragment.getElementName();
                }
            }
            catch (EGLModelException eGLModelException) {
                return;
            }
            if (newPkg != null) {
                Iterator i = dnr.getDocument().getNewModelEGLFile().getImportDeclarations().iterator();
                while (i.hasNext()) {
                    String pkgName = "";
                    ImportDeclaration importDeclaration = (ImportDeclaration)i.next();
                    if (importDeclaration.isOnDemand()) {
                        pkgName = importDeclaration.getName().getCanonicalName();
                    } else {
                        int index = importDeclaration.getName().getCanonicalName().lastIndexOf(".");
                        if (index > -1) {
                            pkgName = importDeclaration.getName().getCanonicalName().substring(0, index);
                        }
                    }
                    if (!pkgName.equalsIgnoreCase(newPkg)) continue;
                    dnr.getRewrite().removeNode((Node)importDeclaration);
                }
            }
        }

        private OrganizeImportsOperation.OrganizedImportSection createImportSection(IEGLFile eglFile) throws EGLModelException {
            OrganizeImportsOperation.OrganizedImportSection importSection = null;
            IPackageFragment destinationAsPackageFragment = this.getDestinationAsPackageFragment();
            if (destinationAsPackageFragment != null) {
                importSection = new OrganizeImportsOperation.OrganizedImportSection(destinationAsPackageFragment.getElementName());
                FilesFoldersAndCusReorgPolicy.DocumentAndRewrite dnr = this.getDocumentAndRewrite(eglFile);
                if (dnr == null) {
                    return importSection;
                }
                File file = dnr.getDocument().getNewModelEGLFile();
                for (ImportDeclaration decl : file.getImportDeclarations()) {
                    String canonicalName = decl.getName().getCanonicalName();
                    if (decl.isOnDemand()) {
                        importSection.ignoreImport(canonicalName, "*");
                        continue;
                    }
                    int lastDot = canonicalName.lastIndexOf(46);
                    if (lastDot != -1) {
                        importSection.ignoreImport(canonicalName.substring(0, lastDot), canonicalName.substring(lastDot + 1));
                        continue;
                    }
                    importSection.ignoreImport("", canonicalName);
                }
                IPart[] parts = this.getParts();
                int i = 0;
                while (i < parts.length) {
                    IPackageDeclaration[] packageDeclarations = parts[i].getEGLFile().getPackageDeclarations();
                    String sourcePackageName = packageDeclarations.length == 0 ? "" : packageDeclarations[0].getElementName();
                    importSection.ignoreImport(sourcePackageName, parts[i].getElementName());
                    ++i;
                }
            }
            return importSection;
        }

        private IPart[] getParts() {
            if (this.fParts == null) {
                ArrayList list = new ArrayList();
                IEGLFile[] files = this.getCus();
                int i = 0;
                while (i < files.length) {
                    try {
                        this.addAll(files[i].getParts(), list);
                    }
                    catch (EGLModelException e) {
                        e.printStackTrace();
                        EDTUIPlugin.log(e);
                        return null;
                    }
                    ++i;
                }
                this.fParts = list.toArray(new IPart[list.size()]);
            }
            return this.fParts;
        }

        private void addAll(Object[] arr, List list) {
            if (arr == null) {
                return;
            }
            int i = 0;
            while (i < arr.length) {
                list.add(arr[i]);
                ++i;
            }
        }

        private void createReferenceChanges(IProgressMonitor pm, TextChangeManager changeManager) throws EGLModelException {
            MoveReferenceUpdater updater = new MoveReferenceUpdater(changeManager, pm, this.getDestinationAsPackageFragment(), this.getCus());
            updater.run();
        }

        private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws EGLModelException {
            pm.beginTask("", 1);
            try {
                if (!this.fUpdateReferences) {
                    TextChangeManager textChangeManager = new TextChangeManager();
                    return textChangeManager;
                }
                IPackageFragment packageDest = this.getDestinationAsPackageFragment();
                if (packageDest != null) {
                    MoveEGLFileUpdateCreator creator = new MoveEGLFileUpdateCreator(packageDest);
                    TextChangeManager textChangeManager = creator.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), status);
                    return textChangeManager;
                }
                TextChangeManager textChangeManager = new TextChangeManager();
                return textChangeManager;
            }
            finally {
                pm.done();
            }
        }

        private CompositeChange createSimpleMoveChange(IProgressMonitor pm, TextChangeManager changeManager) throws EGLModelException {
            CompositeChange result = new CompositeChange(UINlsStrings.ReorgPolicy_move);
            result.markAsSynthetic();
            IEGLFile[] cus = this.getCus();
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            int i = 0;
            while (i < cus.length) {
                Change c = this.createChange(cus[i], changeManager);
                if (c != null) {
                    result.add(c);
                }
                pm.worked(1);
                ++i;
            }
            pm.done();
            return result;
        }

        private Change createChange(IEGLFile cu, TextChangeManager changeManager) throws EGLModelException {
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack != null) {
                this.createUpdatePackageChange(cu, pack, changeManager);
                return MoveEGLFilesPolicy.moveCuToPackage(cu, pack);
            }
            IContainer container = this.getDestinationAsContainer();
            if (container == null) {
                return new NullChange();
            }
            return null;
        }

        private static Change moveCuToPackage(IEGLFile cu, IPackageFragment dest) {
            return new MoveEGLFileChange(cu, dest);
        }

        private void handlePart(IPart type, IPackageFragment destination, IProgressMonitor pm) {
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            try {
                pm.beginTask("", 3);
                RefactoringStatus result = new RefactoringStatus();
                this.confirmMovingReadOnly(reorgQueries);
                this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 2), result);
                result.merge(super.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 1), context, reorgQueries));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            catch (EGLModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new EGLModelException(e);
            }
            finally {
                pm.done();
            }
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getEGLElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        @Override
        public IFile[] getAllModifiedFiles() {
            HashSet<IFile> result = new HashSet<IFile>();
            result.addAll(Arrays.asList(ReorgUtils.getFiles(this.fChangeManager.getAllCompilationUnits())));
            try {
                if (this.getDestinationAsPackageFragment() != null && this.getUpdateReferences()) {
                    result.addAll(Arrays.asList(ReorgUtils.getFiles(this.getCus())));
                }
            }
            catch (EGLModelException eGLModelException) {}
            return result.toArray(new IFile[result.size()]);
        }

        @Override
        public boolean hasAllInputSet() {
            return super.hasAllInputSet() && !this.canUpdateReferences() && !this.canUpdateQualifiedNames();
        }

        @Override
        public boolean canUpdateReferences() {
            return this.getCus().length != 0;
        }

        @Override
        public boolean getUpdateReferences() {
            return this.fUpdateReferences;
        }

        @Override
        public void setUpdateReferences(boolean update) {
            this.fUpdateReferences = update;
        }

        @Override
        public String getFilePatterns() {
            return this.fFilePatterns;
        }

        @Override
        public void setFilePatterns(String patterns) {
            Assert.isNotNull((Object)patterns);
            this.fFilePatterns = patterns;
        }

        @Override
        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return createQueries.createNewPackageQuery();
        }

        @Override
        public boolean isTextualMove() {
            return false;
        }
    }

    private static class MovePartsPolicy
    extends PartReorgPolicy
    implements IReorgPolicy.IEGLMovePolicy {
        private boolean fUpdateReferences = true;
        private TextChangeManager fChangeManager;

        MovePartsPolicy(IEGLElement[] javaElements) {
            super(javaElements);
        }

        @Override
        protected RefactoringStatus verifyDestination(IEGLElement destination) throws EGLModelException {
            IEGLElement[] elements = this.getEGLElements();
            int i = 0;
            while (i < elements.length) {
                IEGLElement parent = destination.getParent();
                while (parent != null) {
                    if (parent.equals(elements[i])) {
                        return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_cannot);
                    }
                    parent = parent.getParent();
                }
                ++i;
            }
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = new ParentChecker(new IResource[0], this.getEGLElements()).getCommonParent();
            if (destination.equals(commonParent) || Arrays.asList(this.getEGLElements()).contains(destination)) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_element2parent);
            }
            return superStatus;
        }

        @Override
        public Change createChange(IProgressMonitor pm) throws EGLModelException {
            pm.beginTask("", 3);
            if (this.fChangeManager == null) {
                this.fChangeManager = new TextChangeManager();
            }
            try {
                File sourceFile = this.sourceEGLDocument.getNewModelEGLFile();
                ASTRewrite sourceRewrite = ASTRewrite.create((File)sourceFile);
                IEGLElement[] elements = this.getEGLElements();
                int i = 0;
                while (i < elements.length) {
                    if (8 == elements[i].getElementType()) {
                        sourceRewrite.removeNode(this.sourceEGLDocument.getNewModelNodeAtOffset(((IPart)elements[i]).getSourceRange().getOffset()));
                    }
                    ++i;
                }
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IEGLFile sourceCu = this.getSourceCu();
                EGLFileChange sourceFileChange = MovePartsPolicy.createEGLEGLFileChange(sourceCu, this.sourceEGLDocument, sourceRewrite);
                this.fChangeManager.manage(sourceCu, (TextChange)sourceFileChange);
                File destinationFile = this.destinationEGLDocument.getNewModelEGLFile();
                ASTRewrite destinationRewrite = ASTRewrite.create((File)destinationFile);
                this.removeAddContentsCommentFromDestinationFile(this.destinationEGLDocument, destinationRewrite);
                String[] deletions = this.getDeletedSections(sourceFileChange.getEdit(), this.sourceEGLDocument);
                int i2 = 0;
                while (i2 < deletions.length) {
                    destinationRewrite.addPart(destinationFile, deletions[i2]);
                    ++i2;
                }
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                OrganizeImportsOperation.OrganizedImportSection importSection = this.createImportSection(destinationFile);
                int i3 = 0;
                while (i3 < elements.length) {
                    if (8 == elements[i3].getElementType()) {
                        this.addImportsToReferencedTypes(elements[i3].getElementName(), sourceCu, importSection, pm);
                    }
                    ++i3;
                }
                importSection.addImportsToASTRewrite(destinationRewrite, destinationFile);
                IEGLFile destinationCu = this.getDestinationCu();
                EGLFileChange destinationCuChange = MovePartsPolicy.createEGLEGLFileChange(destinationCu, this.destinationEGLDocument, destinationRewrite);
                this.fChangeManager.manage(destinationCu, (TextChange)destinationCuChange);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (this.fUpdateReferences) {
                    this.createReferenceChanges(pm, this.fChangeManager);
                }
                CompositeChange result = new CompositeChange(UINlsStrings.ReorgPolicy_move_members);
                result.markAsSynthetic();
                result.merge(new CompositeChange(UINlsStrings.MoveRefactoring_reorganize_elements, (Change[])this.fChangeManager.getAllChanges()));
                CompositeChange compositeChange = result;
                return compositeChange;
            }
            catch (CoreException e) {
                throw new EGLModelException(e);
            }
            finally {
                pm.done();
            }
        }

        private void addImportsToReferencedTypes(String partName, final IEGLFile sourceCu, final OrganizeImportsOperation.OrganizedImportSection importSection, IProgressMonitor pm) throws EGLModelException {
            IPackageFragment packageFragment = (IPackageFragment)sourceCu.getAncestor(4);
            String packageName = packageFragment.isDefaultPackage() ? "" : packageFragment.getElementName();
            WorkingCopyCompiler.getInstance().compilePart(sourceCu.getEGLProject().getProject(), packageName, (IFile)sourceCu.getResource(), new IWorkingCopy[]{(IWorkingCopy)sourceCu.getWorkingCopy(pm, EGLUI.getBufferFactory(), null)}, partName, new IWorkingCopyCompileRequestor(){

                public void acceptResult(WorkingCopyCompilationResult result) {
                    Part boundPart = (Part)result.getBoundPart();
                    OrganizeImportsVisitor organizeImportsVisitor = new OrganizeImportsVisitor(importSection, new HashMap(), new HashSet(), null, sourceCu.getEGLProject().getProject());
                    organizeImportsVisitor.setCurrentPartName(boundPart.getName());
                    boundPart.accept((IASTVisitor)organizeImportsVisitor);
                }
            });
        }

        private OrganizeImportsOperation.OrganizedImportSection createImportSection(File destinationFile) throws EGLModelException {
            String destinationPackageName = destinationFile.hasPackageDeclaration() ? destinationFile.getPackageDeclaration().getName().getCanonicalName() : "";
            OrganizeImportsOperation.OrganizedImportSection importSection = new OrganizeImportsOperation.OrganizedImportSection(destinationPackageName);
            for (ImportDeclaration decl : destinationFile.getImportDeclarations()) {
                String canonicalName = decl.getName().getCanonicalName();
                if (decl.isOnDemand()) {
                    importSection.ignoreImport(canonicalName, "*");
                    continue;
                }
                int lastDot = canonicalName.lastIndexOf(46);
                if (lastDot != -1) {
                    importSection.ignoreImport(canonicalName.substring(0, lastDot), canonicalName.substring(lastDot + 1));
                    continue;
                }
                importSection.ignoreImport("", canonicalName);
            }
            IEGLElement[] elements = this.getEGLElements();
            IPackageDeclaration[] packageDeclarations = this.getSourceCu().getPackageDeclarations();
            String sourcePackageName = packageDeclarations.length == 0 ? "" : packageDeclarations[0].getElementName();
            int i = 0;
            while (i < elements.length) {
                importSection.ignoreImport(sourcePackageName, elements[i].getElementName());
                ++i;
            }
            return importSection;
        }

        private void removeAddContentsCommentFromDestinationFile(IEGLDocument destinationEGLDocument, ASTRewrite destinationRewrite) {
            int numberOfLines = destinationEGLDocument.getNumberOfLines();
            if (numberOfLines == 1 || numberOfLines == 3) {
                String addContentsString = NewWizardMessages.NewEGLFileWizardPageFilecontents;
                int i = destinationEGLDocument.get().indexOf(addContentsString);
                if (i != -1) {
                    try {
                        int startOffset = numberOfLines == 1 ? 0 : destinationEGLDocument.getLineLength(0);
                        int length = numberOfLines == 1 ? addContentsString.length() : i - startOffset + addContentsString.length();
                        destinationRewrite.removeText(startOffset, length);
                    }
                    catch (BadLocationException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        private String[] getDeletedSections(TextEdit edit, IEGLDocument eglDocument) {
            ArrayList<String> result = new ArrayList<String>();
            TextEdit[] children = edit.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof DeleteEdit) {
                    try {
                        result.add(eglDocument.get(children[i].getOffset(), children[i].getLength()).trim());
                    }
                    catch (BadLocationException e) {
                        throw new RuntimeException(e);
                    }
                }
                ++i;
            }
            return result.toArray(new String[0]);
        }

        private void createReferenceChanges(IProgressMonitor pm, TextChangeManager changeManager) throws EGLModelException {
            MoveReferenceUpdater updater = new MoveReferenceUpdater(changeManager, pm, (IPackageFragment)this.getDestinationCu().getAncestor(4), this.getMovingParts());
            updater.run();
        }

        private IPart[] getMovingParts() {
            ArrayList<IEGLElement> parts = new ArrayList<IEGLElement>();
            IEGLElement[] elements = this.getEGLElements();
            int i = 0;
            while (i < elements.length) {
                if (8 == elements[i].getElementType()) {
                    parts.add(elements[i]);
                }
                ++i;
            }
            return parts.toArray(new IPart[0]);
        }

        @Override
        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        @Override
        public boolean canEnable() throws EGLModelException {
            return super.canEnable() && this.getSourceCu() != null;
        }

        @Override
        public IFile[] getAllModifiedFiles() {
            return ReorgUtils.getFiles(new IResource[]{ReorgUtils.getResource(this.getSourceCu()), ReorgUtils.getResource(this.getDestinationCu())});
        }

        @Override
        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return createQueries.createNewEGLFileQuery();
        }

        @Override
        public boolean isTextualMove() {
            return true;
        }

        @Override
        public boolean canUpdateReferences() {
            return true;
        }

        @Override
        public boolean getUpdateReferences() {
            return this.fUpdateReferences;
        }

        @Override
        public void setUpdateReferences(boolean update) {
            this.fUpdateReferences = update;
        }
    }

    private static class NewNameProposer {
        private final Set fAutoGeneratedNewNames = new HashSet(2);

        private NewNameProposer() {
        }

        public String createNewName(IEGLFile cu, IPackageFragment destination) {
            if (NewNameProposer.isNewNameOk(destination, cu.getElementName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(cu, destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? MessageFormat.format((String)UINlsStrings.CopyRefactoring_cu_copyOf1, (Object[])new String[]{cu.getElementName()}) : MessageFormat.format((String)UINlsStrings.CopyRefactoring_cu_copyOfMore, (Object[])new String[]{String.valueOf(i), cu.getElementName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return NewNameProposer.removeTrailingEGL(newName);
                }
                ++i;
            }
        }

        private static String removeTrailingEGL(String name) {
            int index = name.indexOf(".egl");
            if (index == -1) {
                return name;
            }
            return name.substring(0, index);
        }

        public String createNewName(IResource res, IContainer destination) {
            if (NewNameProposer.isNewNameOk(destination, res.getName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(res, (IResource)destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? MessageFormat.format((String)UINlsStrings.CopyRefactoring_resource_copyOf1, (Object[])new String[]{res.getName()}) : MessageFormat.format((String)UINlsStrings.CopyRefactoring_resource_copyOfMore, (Object[])new String[]{String.valueOf(i), res.getName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return newName;
                }
                ++i;
            }
        }

        public String createNewName(IPackageFragment pack, IPackageFragmentRoot destination) {
            if (NewNameProposer.isNewNameOk(destination, pack.getElementName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(pack, destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? MessageFormat.format((String)UINlsStrings.CopyRefactoring_package_copyOf1, (Object[])new String[]{pack.getElementName()}) : MessageFormat.format((String)UINlsStrings.CopyRefactoring_package_copyOfMore, (Object[])new String[]{String.valueOf(i), pack.getElementName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return newName;
                }
                ++i;
            }
        }

        private static boolean isNewNameOk(IPackageFragment dest, String newName) {
            return !dest.getEGLFile(newName).exists();
        }

        private static boolean isNewNameOk(IContainer container, String newName) {
            return container.findMember(newName) == null;
        }

        private static boolean isNewNameOk(IPackageFragmentRoot root, String newName) {
            return !root.getPackageFragment(newName).exists();
        }
    }

    private static class NoCopyPolicy
    extends ReorgPolicy
    implements IReorgPolicy.IEGLCopyPolicy {
        private NoCopyPolicy() {
        }

        @Override
        public boolean canEnable() throws EGLModelException {
            return false;
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return null;
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource resource) throws EGLModelException {
            return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_noCopying);
        }

        @Override
        protected RefactoringStatus verifyDestination(IEGLElement javaElement) throws EGLModelException {
            return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_noCopying);
        }

        @Override
        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            return new NullChange();
        }

        @Override
        public IResource[] getResources() {
            return new IResource[0];
        }

        @Override
        public IEGLElement[] getEGLElements() {
            return new IEGLElement[0];
        }
    }

    private static class NoMovePolicy
    extends ReorgPolicy
    implements IReorgPolicy.IEGLMovePolicy {
        private NoMovePolicy() {
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource resource) throws EGLModelException {
            return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_noMoving);
        }

        @Override
        protected RefactoringStatus verifyDestination(IEGLElement javaElement) throws EGLModelException {
            return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_noMoving);
        }

        @Override
        public Change createChange(IProgressMonitor pm) {
            return new NullChange();
        }

        @Override
        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        @Override
        public boolean canEnable() throws EGLModelException {
            return false;
        }

        @Override
        public IResource[] getResources() {
            return new IResource[0];
        }

        @Override
        public IEGLElement[] getEGLElements() {
            return new IEGLElement[0];
        }

        @Override
        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        @Override
        public boolean isTextualMove() {
            return true;
        }
    }

    private static abstract class PartReorgPolicy
    extends ReorgPolicy {
        private final IEGLElement[] fEGLElements;
        protected IEGLDocument sourceEGLDocument;
        protected IEGLDocument destinationEGLDocument;

        PartReorgPolicy(IEGLElement[] eglElements) {
            Assert.isNotNull((Object)eglElements);
            this.fEGLElements = eglElements;
            try {
                IEGLFile sourceCu = this.getSourceCu();
                IEGLFile sharedWorkingCopy = (IEGLFile)sourceCu.getWorkingCopy(null, EGLUI.getBufferFactory(), null);
                IBuffer buffer = sharedWorkingCopy.getBuffer();
                if (buffer instanceof IEGLDocumentAdapter) {
                    IEGLDocumentAdapter adapter = (IEGLDocumentAdapter)buffer;
                    this.sourceEGLDocument = (IEGLDocument)adapter.getDocument();
                }
            }
            catch (EGLModelException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public RefactoringStatus setDestination(IEGLElement destination) throws EGLModelException {
            IEGLFile workingCopy;
            IBuffer buffer;
            RefactoringStatus status = super.setDestination(destination);
            IEGLFile destinationFile = destination instanceof IEGLFile ? (IEGLFile)destination : (IEGLFile)destination.getAncestor(6);
            if (destinationFile != null && (buffer = (workingCopy = (IEGLFile)destinationFile.getWorkingCopy(null, EGLUI.getBufferFactory(), null)).getBuffer()) instanceof IEGLDocumentAdapter) {
                IEGLDocumentAdapter adapter = (IEGLDocumentAdapter)buffer;
                this.destinationEGLDocument = (IEGLDocument)adapter.getDocument();
            }
            return status;
        }

        @Override
        protected final RefactoringStatus verifyDestination(IResource destination) throws EGLModelException {
            return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_no_resource);
        }

        protected final IEGLFile getSourceCu() {
            return (IEGLFile)this.fEGLElements[0].getAncestor(6);
        }

        @Override
        public final IEGLElement[] getEGLElements() {
            return this.fEGLElements;
        }

        @Override
        public final IResource[] getResources() {
            return new IResource[0];
        }

        protected final IEGLFile getDestinationCu() {
            return PartReorgPolicy.getDestinationCu(this.getEGLElementDestination());
        }

        protected static final IEGLFile getDestinationCu(IEGLElement destination) {
            if (destination instanceof IEGLFile) {
                return (IEGLFile)destination;
            }
            return (IEGLFile)destination.getAncestor(6);
        }

        protected static EGLFileChange createEGLEGLFileChange(IEGLFile cu, IEGLDocument eglDocument, ASTRewrite rewrite) throws CoreException {
            EGLFileChange eglFileChange = new EGLFileChange(cu.getElementName(), cu);
            eglFileChange.setEdit(rewrite.rewriteAST((IDocument)eglDocument));
            if (eglFileChange != null && cu.isWorkingCopy()) {
                eglFileChange.setSaveMode(4);
            }
            return eglFileChange;
        }

        protected void copyToDestination(IEGLElement element, ASTRewrite targetRewriter, File sourceCuNode, File targetCuNode) throws CoreException {
        }

        private ClassDataDeclaration createNewFieldDeclarationNode(IField field, ASTRewrite rewrite, File sourceCuNode) throws CoreException {
            return null;
        }

        private void copyImportsToDestination(IImportContainer container, ASTRewrite rewrite, Node sourceCuNode, Node destinationCuNode) throws EGLModelException {
        }

        private void copyImportToDestination(IImportDeclaration declaration, ASTRewrite targetRewrite, Node sourceCuNode, Node destinationCuNode) throws EGLModelException {
        }

        private void copyPackageDeclarationToDestination(IPackageDeclaration declaration, ASTRewrite targetRewrite, File sourceCuNode, File destinationCuNode) throws EGLModelException {
        }

        private void copyTypeToDestination(IPart type, ASTRewrite targetRewriter, File sourceCuNode, File targetCuNode) throws EGLModelException {
        }

        private void copyMethodToDestination(IFunction method, ASTRewrite targetRewriter, File sourceCuNode, File targetCuNode) throws EGLModelException {
        }

        private void copyMemberToDestination(IMember member, ASTRewrite targetRewriter, File sourceCuNode, File targetCuNode, Node newMember) throws EGLModelException {
        }

        private static String getUnindentedSource(ISourceReference sourceReference) throws EGLModelException {
            Assert.isTrue((boolean)(sourceReference instanceof IEGLElement));
            String[] lines = Strings.convertIntoLines(sourceReference.getSource());
            IEGLProject project = ((IEGLElement)sourceReference).getEGLProject();
            Strings.trimIndentation(lines, JavaCore.create((IProject)project.getProject()), false);
            return Strings.concatenate(lines, ReorgUtils.getLineDelimiterUsed((IEGLElement)sourceReference));
        }

        private IPart getDestinationAsType() throws EGLModelException {
            IEGLElement destination = this.getEGLElementDestination();
            IPart enclosingType = PartReorgPolicy.getEnclosingType(destination);
            if (enclosingType != null) {
                return enclosingType;
            }
            IEGLFile enclosingCu = PartReorgPolicy.getEnclosingCu(destination);
            Assert.isNotNull((Object)enclosingCu);
            IPart mainType = ReorgUtils.getMainPart(enclosingCu);
            Assert.isNotNull((Object)mainType);
            return mainType;
        }

        private static IEGLFile getEnclosingCu(IEGLElement destination) {
            if (destination instanceof IEGLFile) {
                return (IEGLFile)destination;
            }
            return (IEGLFile)destination.getAncestor(6);
        }

        private static IPart getEnclosingType(IEGLElement destination) {
            if (destination instanceof IPart) {
                return (IPart)destination;
            }
            return (IPart)destination.getAncestor(8);
        }

        @Override
        public boolean canEnable() throws EGLModelException {
            if (!super.canEnable()) {
                return false;
            }
            int i = 0;
            while (i < this.fEGLElements.length) {
                IMember member;
                if (this.fEGLElements[i] instanceof IMember && (member = (IMember)this.fEGLElements[i]).getSourceRange() == null) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        protected RefactoringStatus verifyDestination(IEGLElement destination) throws EGLModelException {
            return this.recursiveVerifyDestination(destination);
        }

        private RefactoringStatus recursiveVerifyDestination(IEGLElement destination) throws EGLModelException {
            Assert.isNotNull((Object)destination);
            if (!destination.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_doesnotexist1);
            }
            if (destination instanceof IEGLModel) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_jmodel);
            }
            if (!(destination instanceof IEGLFile) && !ReorgUtils.isInsideEGLFile(destination)) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_cannot);
            }
            IEGLFile destinationCu = PartReorgPolicy.getDestinationCu(destination);
            Assert.isNotNull((Object)destinationCu);
            if (destinationCu.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_cannot_modify);
            }
            switch (destination.getElementType()) {
                case 6: {
                    int[] types0 = new int[]{9, 11, 10};
                    if (!ReorgUtils.hasElementsOfType(this.getEGLElements(), types0)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_cannot);
                }
                case 12: {
                    return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_package_decl);
                }
                case 13: {
                    if (!ReorgUtils.hasElementsNotOfType(this.getEGLElements(), 14)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_cannot);
                }
                case 14: {
                    if (!ReorgUtils.hasElementsNotOfType(this.getEGLElements(), 14)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgPolicyFactory_cannot);
                }
                case 9: 
                case 10: 
                case 11: {
                    return this.recursiveVerifyDestination(destination.getParent());
                }
                case 8: {
                    int[] types1 = new int[]{14, 13, 12};
                    if (!ReorgUtils.hasElementsOfType(this.getEGLElements(), types1)) break;
                    return this.recursiveVerifyDestination(destination.getParent());
                }
            }
            return new RefactoringStatus();
        }

        @Override
        public boolean canChildrenBeDestinations(IResource resource) {
            return false;
        }

        @Override
        public boolean canElementBeDestination(IResource resource) {
            return false;
        }

        @Override
        public boolean canElementBeDestination(IEGLElement eglElement) {
            return 6 == eglElement.getElementType();
        }

        @Override
        public boolean canChildrenBeDestinations(IEGLElement eglElement) {
            switch (eglElement.getElementType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
            if (status.isOK()) {
                IEGLFile destinationCu = this.getDestinationCu();
                IPackageFragment pkg = (IPackageFragment)destinationCu.getAncestor(4);
                IEGLElement[] elements = this.getEGLElements();
                if (elements.length != 0) {
                    IPackageFragment sourcePkg = (IPackageFragment)elements[0].getAncestor(4);
                    if (!pkg.getElementName().equals(sourcePkg.getElementName())) {
                        int i = 0;
                        while (i < elements.length) {
                            if (RenamePartProcessor.findPartInPackage(pkg, elements[i].getElementName()) != null) {
                                String msg = MessageFormat.format((String)UINlsStrings.RenamePartRefactoring_exists, (Object[])new String[]{elements[i].getElementName(), pkg.getElementName()});
                                status.merge(RefactoringStatus.createErrorStatus((String)msg));
                            }
                            ++i;
                        }
                    }
                }
            }
            return status;
        }
    }

    private static abstract class ReorgPolicy
    implements IReorgPolicy {
        private IResource fResourceDestination;
        private IEGLElement fEGLElementDestination;

        private ReorgPolicy() {
        }

        @Override
        public final RefactoringStatus setDestination(IResource destination) throws EGLModelException {
            Assert.isNotNull((Object)destination);
            this.resetDestinations();
            this.fResourceDestination = destination;
            return this.verifyDestination(destination);
        }

        @Override
        public RefactoringStatus setDestination(IEGLElement destination) throws EGLModelException {
            Assert.isNotNull((Object)destination);
            this.resetDestinations();
            this.fEGLElementDestination = destination;
            return this.verifyDestination(destination);
        }

        protected abstract RefactoringStatus verifyDestination(IEGLElement var1) throws EGLModelException;

        protected abstract RefactoringStatus verifyDestination(IResource var1) throws EGLModelException;

        @Override
        public boolean canChildrenBeDestinations(IEGLElement eglElement) {
            return true;
        }

        @Override
        public boolean canChildrenBeDestinations(IResource resource) {
            return true;
        }

        @Override
        public boolean canElementBeDestination(IEGLElement eglElement) {
            return true;
        }

        @Override
        public boolean canElementBeDestination(IResource resource) {
            return true;
        }

        private void resetDestinations() {
            this.fEGLElementDestination = null;
            this.fResourceDestination = null;
        }

        @Override
        public final IResource getResourceDestination() {
            return this.fResourceDestination;
        }

        @Override
        public final IEGLElement getEGLElementDestination() {
            return this.fEGLElementDestination;
        }

        public IFile[] getAllModifiedFiles() {
            return new IFile[0];
        }

        protected RefactoringModifications getModifications() throws CoreException {
            return null;
        }

        @Override
        public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor processor, String[] natures, SharableParticipants shared) throws CoreException {
            RefactoringModifications modifications = this.getModifications();
            if (modifications != null) {
                return modifications.loadParticipants(status, processor, natures, shared);
            }
            return new RefactoringParticipant[0];
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            Assert.isNotNull((Object)reorgQueries);
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            IFile[] allModifiedFiles = this.getAllModifiedFiles();
            RefactoringModifications modifications = this.getModifications();
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            int i = 0;
            while (i < allModifiedFiles.length) {
                deltaFactory.change(allModifiedFiles[i]);
                ++i;
            }
            if (modifications != null) {
                modifications.buildDelta(deltaFactory);
                modifications.buildValidateEdits((ValidateEditChecker)context.getChecker(ValidateEditChecker.class));
            }
            return new RefactoringStatus();
        }

        @Override
        public boolean hasAllInputSet() {
            return this.fEGLElementDestination != null || this.fResourceDestination != null;
        }

        @Override
        public boolean canUpdateReferences() {
            return false;
        }

        @Override
        public boolean getUpdateReferences() {
            Assert.isTrue((boolean)false);
            return false;
        }

        @Override
        public void setUpdateReferences(boolean update) {
            Assert.isTrue((boolean)false);
        }

        public boolean canEnableQualifiedNameUpdating() {
            return false;
        }

        @Override
        public boolean canUpdateQualifiedNames() {
            Assert.isTrue((boolean)false);
            return false;
        }

        public String getFilePatterns() {
            Assert.isTrue((boolean)false);
            return null;
        }

        public boolean getUpdateQualifiedNames() {
            Assert.isTrue((boolean)false);
            return false;
        }

        public void setFilePatterns(String patterns) {
            Assert.isTrue((boolean)false);
        }

        public void setUpdateQualifiedNames(boolean update) {
            Assert.isTrue((boolean)false);
        }

        @Override
        public boolean canEnable() throws EGLModelException {
            IResource[] resources = this.getResources();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (!resource.exists() || resource.isPhantom() || !resource.isAccessible()) {
                    return false;
                }
                ++i;
            }
            IEGLElement[] eglElements = this.getEGLElements();
            int i2 = 0;
            while (i2 < eglElements.length) {
                IEGLElement element = eglElements[i2];
                if (!element.exists()) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
    }
}

