/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class EGLSearchScopeFactory {
    private static EGLSearchScopeFactory fgInstance;
    private static IEGLSearchScope EMPTY_SCOPE;
    private static final Set EMPTY_SET;

    static {
        EMPTY_SCOPE = SearchEngine.createEGLSearchScope((IEGLElement[])new IEGLElement[0]);
        EMPTY_SET = new HashSet(0);
    }

    public static EGLSearchScopeFactory getInstance() {
        if (fgInstance == null) {
            fgInstance = new EGLSearchScopeFactory();
        }
        return fgInstance;
    }

    public IWorkingSet[] queryWorkingSets() {
        IWorkingSet[] workingSets;
        Shell shell = EDTUIPlugin.getActiveWorkbenchShell();
        if (shell == null) {
            return null;
        }
        IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(shell, true);
        if (dialog.open() == 0 && (workingSets = dialog.getSelection()).length > 0) {
            return workingSets;
        }
        return null;
    }

    private IEGLSearchScope createEGLSearchScope(Set eglElements) {
        return SearchEngine.createEGLSearchScope((IEGLElement[])eglElements.toArray(new IEGLElement[eglElements.size()]));
    }

    public IEGLSearchScope createEGLSearchScope(IWorkingSet[] sets) {
        if (sets == null || sets.length < 1) {
            return EMPTY_SCOPE;
        }
        HashSet eglElements = new HashSet(sets.length * 10);
        int i = 0;
        while (i < sets.length) {
            this.addEGLElements(eglElements, sets[i]);
            ++i;
        }
        return SearchEngine.createEGLSearchScope((IEGLElement[])eglElements.toArray(new IEGLElement[eglElements.size()]), (boolean)false);
    }

    private void addEGLElements(Set eglElements, IWorkingSet set) {
        if (set == null) {
            return;
        }
        IAdaptable[] elements = set.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IEGLElement) {
                this.addEGLElements(eglElements, (IEGLElement)elements[i]);
            } else {
                this.addEGLElements(eglElements, elements[i]);
            }
            ++i;
        }
    }

    private void addEGLElements(Set eglElements, IAdaptable resource) {
        IEGLElement eglElement = (IEGLElement)resource.getAdapter(IEGLElement.class);
        if (eglElement == null) {
            return;
        }
        this.addEGLElements(eglElements, eglElement);
    }

    private void addEGLElements(Set eglElements, IEGLElement element) {
        eglElements.add(element);
    }

    public IEGLSearchScope createEGLSearchScope(IStructuredSelection fStructuredSelection) {
        HashSet eglElements = new HashSet(fStructuredSelection.size());
        Iterator iter = fStructuredSelection.iterator();
        while (iter.hasNext()) {
            this.addEGLElements(eglElements, (IAdaptable)iter.next());
        }
        return this.createEGLSearchScope(eglElements);
    }

    public IEGLSearchScope createEGLProjectSearchScope(IEGLElement selection) {
        return this.createEGLProjectSearchScope((ISelection)new StructuredSelection((Object)selection));
    }

    public IEGLSearchScope createEGLProjectSearchScope(ISelection selection) {
        IEditorInput input = this.getActiveEditorInput();
        if (input != null && selection.isEmpty()) {
            return EGLSearchScopeFactory.getInstance().internalCreateProjectScope(input);
        }
        return this.internalCreateProjectScope(selection);
    }

    private IEditorInput getActiveEditorInput() {
        IEditorPart editor;
        IWorkbenchPage page = EDTUIPlugin.getActivePage();
        if (page != null && (editor = page.getActiveEditor()) != null) {
            return editor.getEditorInput();
        }
        return null;
    }

    private IEGLSearchScope internalCreateProjectScope(IEditorInput editorInput) {
        IAdaptable inputElement = this.getEditorInputElement(editorInput);
        StructuredSelection selection = inputElement != null ? new StructuredSelection((Object)inputElement) : StructuredSelection.EMPTY;
        return this.internalCreateProjectScope((ISelection)selection);
    }

    private IAdaptable getEditorInputElement(IEditorInput editorInput) {
        IFile inputElement = null;
        if (editorInput instanceof IFileEditorInput) {
            inputElement = ((IFileEditorInput)editorInput).getFile();
        }
        return inputElement;
    }

    private IEGLSearchScope internalCreateProjectScope(ISelection selection) {
        Set eglProjects = this.getEGLProjects(selection);
        return this.createEGLSearchScope(eglProjects);
    }

    private Set getEGLProjects(ISelection selection) {
        HashSet<IEGLProject> eglProjects;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            eglProjects = new HashSet<IEGLProject>(((IStructuredSelection)selection).size());
            while (iter.hasNext()) {
                IEGLProject eglProject;
                Object selectedElement = iter.next();
                if (selectedElement instanceof ISearchResultViewEntry) {
                    selectedElement = ((ISearchResultViewEntry)selectedElement).getGroupByKey();
                }
                if (!(selectedElement instanceof IAdaptable) || (eglProject = this.getEGLProject((IAdaptable)selectedElement)) == null) continue;
                eglProjects.add(eglProject);
            }
        } else {
            eglProjects = EMPTY_SET;
        }
        return eglProjects;
    }

    private IEGLProject getEGLProject(IAdaptable selectedElement) {
        IEGLProject eglProject = (IEGLProject)selectedElement.getAdapter(IEGLProject.class);
        if (eglProject != null) {
            return eglProject;
        }
        IEGLElement eglElement = (IEGLElement)selectedElement.getAdapter(IEGLElement.class);
        if (eglElement != null && (eglProject = eglElement.getEGLProject()) != null) {
            return eglProject;
        }
        IResource resource = (IResource)selectedElement.getAdapter(IResource.class);
        if (resource != null) {
            IProject project = resource.getProject();
            try {
                if (project != null && project.isAccessible() && project.hasNature(EGLCore.NATURE_ID)) {
                    return EGLCore.create((IProject)project);
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public IProject[] getProjects(IEGLSearchScope scope) {
        IPath[] paths = scope.enclosingProjects();
        HashSet<IResource> temp = new HashSet<IResource>();
        int i = 0;
        while (i < paths.length) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(paths[i]);
            if (resource != null && resource.getType() == 4) {
                temp.add(resource);
            }
            ++i;
        }
        return temp.toArray(new IProject[temp.size()]);
    }
}

