/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.services.wizards;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.dialogs.InterfaceSelectionDialog;
import org.eclipse.edt.ide.ui.internal.services.wizards.BasicServiceWizard;
import org.eclipse.edt.ide.ui.internal.services.wizards.ServiceConfiguration;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class BasicServiceInterfaceSelectionPage
extends WizardPage {
    private int nColumns = 5;
    protected ListDialogField fSuperInterfacesDialogField;
    private Button fGenAsRestService;
    private InterfaceFieldAdapter adapter = new InterfaceFieldAdapter();

    private void handleInterfaceDialogFieldChanged() {
    }

    protected InterfaceSelectionDialog getInterfaceSelectionDialog(IEGLProject project) {
        InterfaceSelectionDialog dialog = new InterfaceSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), this.fSuperInterfacesDialogField, 2048, null, this.getConfiguration(), project);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPageInterfacesDialogClassTitle);
        return dialog;
    }

    protected BasicServiceInterfaceSelectionPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.NewBasicEGLServiceWizardPageTitle);
        this.setDescription(NewWizardMessages.NewBasicEGLServiceWizardPageDescription);
        this.initSuperInterfacesControl(this.adapter);
    }

    protected void initSuperInterfacesControl(IListAdapter listadapter) {
        String[] stringArray = new String[3];
        stringArray[0] = NewWizardMessages.NewTypeWizardPageInterfacesAdd;
        stringArray[2] = NewWizardMessages.NewTypeWizardPageInterfacesRemove;
        String[] addButtons = stringArray;
        this.fSuperInterfacesDialogField = new ListDialogField(listadapter, addButtons, (ILabelProvider)new InterfacesListLabelProvider());
        this.fSuperInterfacesDialogField.setRemoveButtonIndex(2);
    }

    protected void createGenAsRestServiceChkbox(Composite parent, int nColumns) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns;
        this.fGenAsRestService = new Button(parent, 32);
        this.fGenAsRestService.setLayoutData((Object)gd);
        this.fGenAsRestService.setText(NewWizardMessages.CreateAsRestService);
        this.fGenAsRestService.setSelection(this.getConfiguration().isGenAsRestService());
        this.fGenAsRestService.addSelectionListener(new SelectionListener(){

            private void setOverwriteSelection(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    Button btn = (Button)e.getSource();
                    BasicServiceInterfaceSelectionPage.this.getConfiguration().setGenAsRestService(btn.getSelection());
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.setOverwriteSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.setOverwriteSelection(e);
            }
        });
    }

    private ServiceConfiguration getConfiguration() {
        return ((BasicServiceWizard)this.getWizard()).getConfiguration();
    }

    protected void createEGLInterfacesControls(Composite composite, int nColumns, String InterfaceLabel) {
        this.fSuperInterfacesDialogField.setLabelText(InterfaceLabel);
        this.fSuperInterfacesDialogField.doFillIntoGrid(composite, nColumns);
        GridData gd = (GridData)this.fSuperInterfacesDialogField.getListControl(null).getLayoutData();
        gd.heightHint = this.convertHeightInCharsToPixels(6);
        gd.grabExcessVerticalSpace = false;
    }

    protected void typePageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fSuperInterfacesDialogField) {
            this.chooseSuperInterfaces();
        }
    }

    private void chooseSuperInterfaces() {
        IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject theProject = fWorkspaceRoot.getProject(this.getConfiguration().getProjectName());
        IEGLProject project = EGLCore.create((IProject)theProject);
        InterfaceSelectionDialog dialog = this.getInterfaceSelectionDialog(project);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPageInterfacesDialogMessage);
        dialog.open();
    }

    public List getSuperInterfaces() {
        return this.fSuperInterfacesDialogField.getElements();
    }

    public void setSuperInterfaces(List interfacesNames, boolean canBeModified) {
        this.fSuperInterfacesDialogField.setElements(interfacesNames);
        this.fSuperInterfacesDialogField.setEnabled(canBeModified);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, IUIHelpConstants.EGL_SERVICE_DEFINITION);
        GridLayout layout = new GridLayout(5, false);
        container.setLayout((Layout)layout);
        String interfaceLabel = NewWizardMessages.NewTypeWizardPageInterfacesClassLabel;
        this.createEGLInterfacesControls(container, this.nColumns, interfaceLabel);
        this.createGenAsRestServiceChkbox(container, this.nColumns);
        this.setControl((Control)container);
    }

    private class InterfaceFieldAdapter
    extends InterfaceListFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private InterfaceFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            BasicServiceInterfaceSelectionPage.this.handleInterfaceDialogFieldChanged();
        }
    }

    protected class InterfaceListFieldAdapter
    implements IListAdapter {
        protected InterfaceListFieldAdapter() {
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
            BasicServiceInterfaceSelectionPage.this.typePageCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(ListDialogField field) {
        }

        @Override
        public void doubleClicked(ListDialogField field) {
        }
    }

    private class InterfacesListLabelProvider
    extends LabelProvider {
        private Image fInterfaceImage = PluginImages.DESC_OBJS_INTERFACE.createImage();

        public Image getImage(Object element) {
            return this.fInterfaceImage;
        }
    }
}

