/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.templates;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.edt.ide.core.internal.errors.ErrorLexer;
import org.eclipse.edt.ide.core.internal.errors.IErrorLexer;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.CodeFormatterUtil;
import org.eclipse.edt.ide.ui.internal.Strings;
import org.eclipse.edt.ide.ui.internal.templates.MultiVariable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;

public class EGLTemplateContext
extends DocumentTemplateContext {
    private static final String PLATFORM_LINE_DELIMITER = System.getProperty("line.separator");
    private static IErrorLexer lexer = new ErrorLexer((Reader)new StringReader(""));
    private ParseStack parseStack;
    private String prefix;

    public EGLTemplateContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ParseStack parseStack, String prefix) {
        super(type, document, completionOffset, completionLength);
        this.parseStack = parseStack;
        this.prefix = prefix;
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        String lineDelimiter = null;
        int numtabs = 0;
        try {
            lineDelimiter = this.getDocument().getLineDelimiter(0);
            numtabs = this.getIndentation();
        }
        catch (BadLocationException badLocationException) {}
        if (lineDelimiter == null) {
            lineDelimiter = PLATFORM_LINE_DELIMITER;
        }
        TemplateTranslator translator = new TemplateTranslator(){

            protected TemplateVariable createVariable(String type, String name, int[] offsets) {
                return new MultiVariable(type, name, offsets);
            }
        };
        TemplateBuffer buffer = translator.translate(this.formatString(template.getPattern(), lineDelimiter, numtabs));
        this.getContextType().resolve(buffer, (TemplateContext)this);
        return buffer;
    }

    public boolean canEvaluate(Template template) {
        if (this.prefix == "") {
            return false;
        }
        if (!template.getName().toUpperCase().startsWith(this.prefix.toUpperCase())) {
            return false;
        }
        TemplateTranslator translator = new TemplateTranslator(){

            protected TemplateVariable createVariable(String type, String name, int[] offsets) {
                return new MultiVariable(type, name, offsets);
            }
        };
        try {
            TemplateBuffer templateBuffer = translator.translate(template);
            lexer.yyreset((Reader)new StringReader(templateBuffer.getString()));
            int nodeType = lexer.yylex();
            while (nodeType == 4) {
                nodeType = lexer.yylex();
            }
            return this.isKeywordAllowed(nodeType, this.parseStack);
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean isKeywordAllowed(int type, ParseStack parseStack) {
        return parseStack.isTerminalShiftable(type);
    }

    private int getIndentation() {
        int start = this.getStart();
        IDocument document = this.getDocument();
        try {
            IRegion region = document.getLineInformationOfOffset(start);
            String lineContent = document.get(region.getOffset(), region.getLength());
            int tabWidth = CodeFormatterUtil.getTabWidth(null);
            return Strings.computeIndentUnits(lineContent, tabWidth, tabWidth);
        }
        catch (BadLocationException e) {
            EDTUIPlugin.log(e);
            return 0;
        }
    }

    private String formatString(String pattern, String lineDelimiter, int numtabs) {
        String result = "";
        char[] temp = pattern.toCharArray();
        int i = 0;
        while (i < temp.length) {
            if (temp[i] != '\r') {
                if (temp[i] != '\n') {
                    result = String.valueOf(result) + temp[i];
                } else {
                    result = String.valueOf(result) + lineDelimiter;
                    int k = 0;
                    while (k < numtabs) {
                        result = String.valueOf(result) + '\t';
                        ++k;
                    }
                }
            }
            ++i;
        }
        return result;
    }
}

