/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.util;

import java.util.Comparator;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.PackageDeclaration;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.codemanipulation.ImportComparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ImportUtility {
    private IEGLDocument document;
    private String packageName;
    private String partName;

    public static boolean addImportStatement(IEGLDocument document, String packageName, String partName) {
        return new ImportUtility(document, packageName, partName).addImportStatement();
    }

    public ImportUtility(IEGLDocument document, String packageName, String partName) {
        this.document = document;
        this.packageName = packageName;
        this.partName = partName;
    }

    public boolean addImportStatement() {
        if (!this.containsImport()) {
            return this.addImport();
        }
        return false;
    }

    private boolean containsImport() {
        File eglFile = this.document.getNewModelEGLFile();
        PackageDeclaration packageDeclaration = eglFile.getPackageDeclaration();
        String currentPackageName = this.getCurrentPackageName(packageDeclaration);
        if (currentPackageName.equalsIgnoreCase(this.packageName)) {
            return true;
        }
        List importStatements = eglFile.getImportDeclarations();
        String importSpecification = "";
        for (ImportDeclaration importStatement : importStatements) {
            importSpecification = importStatement.getName().getCanonicalString();
            if (importSpecification.equalsIgnoreCase(String.valueOf(this.packageName) + "." + this.partName)) {
                return true;
            }
            if (!importStatement.isOnDemand() || !importSpecification.equalsIgnoreCase(this.packageName)) continue;
            return true;
        }
        return false;
    }

    private String getCurrentPackageName(PackageDeclaration packageDeclaration) {
        if (packageDeclaration != null) {
            return packageDeclaration.getName().getCanonicalName();
        }
        return "";
    }

    private boolean addImport() {
        try {
            File fileAST = this.document.getNewModelEGLFile();
            ASTRewrite rewrite = ASTRewrite.create((File)fileAST);
            rewrite.addImport(fileAST, this.getImportString(), false, (Comparator)new ImportComparator());
            rewrite.rewriteAST((IDocument)this.document).apply((IDocument)this.document);
        }
        catch (BadLocationException e) {
            EGLLogger.log((Object)this, e);
            return false;
        }
        return true;
    }

    private String getImportString() {
        StringBuffer buffer = new StringBuffer(this.packageName);
        buffer.append(".");
        buffer.append(this.partName);
        return buffer.toString();
    }
}

