/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.dse.dialogs.ConnectionDisplayProperty;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLUtility;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;

public class DTOConfiguration {
    private IConnectionProfile databaseConnection;
    private List selectedTables;
    private boolean useDelimitedIdentifiers;
    private boolean qualifiedTableNames;
    private boolean saveConnectionToDeploymentDescriptor;
    private HashMap tableFieldHashMap;
    private HashMap tablePageDataHashMap;

    public DTOConfiguration() {
        this.setDefaultValues();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDefaultValues();
    }

    protected void setDefaultValues() {
        this.databaseConnection = null;
        this.selectedTables = new ArrayList();
        this.qualifiedTableNames = false;
        this.tableFieldHashMap = new HashMap();
        this.tablePageDataHashMap = new HashMap();
    }

    public IConnectionProfile getDatabaseConnection() {
        return this.databaseConnection;
    }

    public void setDatabaseConnection(IConnectionProfile databaseConnection) {
        this.databaseConnection = databaseConnection;
    }

    public List getSelectedTables() {
        return this.selectedTables;
    }

    public void setSelectedTables(List newSelectedTables) {
        if (this.selectedTables != null && !this.selectedTables.isEmpty()) {
            this.selectedTables.clear();
        }
        this.selectedTables.addAll(newSelectedTables);
    }

    public EGLDataPartsPagesWizardTableFieldConfiguration getTableFields(Object targetTable) {
        EGLDataPartsPagesWizardTableFieldConfiguration tableFields = (EGLDataPartsPagesWizardTableFieldConfiguration)this.tableFieldHashMap.get(targetTable);
        if (tableFields == null) {
            tableFields = new EGLDataPartsPagesWizardTableFieldConfiguration();
            this.setTableFieldHashMap(targetTable, tableFields);
        }
        return tableFields;
    }

    public void setTableFieldHashMap(Object targetTable, EGLDataPartsPagesWizardTableFieldConfiguration newFieldValue) {
        this.tableFieldHashMap.put(targetTable, newFieldValue);
    }

    public List getKeyFields(Object targetTable) {
        EGLDataPartsPagesWizardTableFieldConfiguration fieldObject = this.getTableFields(targetTable);
        if (fieldObject != null) {
            return fieldObject.getKeyFieldList();
        }
        return new ArrayList();
    }

    public List getSelectionConditionFields(Object targetTable) {
        EGLDataPartsPagesWizardTableFieldConfiguration fieldObject = this.getTableFields(targetTable);
        if (fieldObject != null) {
            return fieldObject.getSelectionConditionFieldList();
        }
        return new ArrayList();
    }

    public EGLDataPartsPagesWizardTablePageConfiguration getTablePages(Object targetTable) {
        EGLDataPartsPagesWizardTablePageConfiguration tablePages = (EGLDataPartsPagesWizardTablePageConfiguration)this.tablePageDataHashMap.get(targetTable);
        if (tablePages == null) {
            tablePages = new EGLDataPartsPagesWizardTablePageConfiguration();
            this.setTablePageDataHashMap(targetTable, tablePages);
        }
        return tablePages;
    }

    public void setTablePageDataHashMap(Object targetTable, EGLDataPartsPagesWizardTablePageConfiguration newPageValue) {
        this.tablePageDataHashMap.put(targetTable, newPageValue);
    }

    public HashMap getDisplayName(Object targetTable) {
        EGLDataPartsPagesWizardTablePageConfiguration fieldObject = this.getTablePages(targetTable);
        if (fieldObject != null) {
            return fieldObject.getDisplayNameFieldHash();
        }
        return new HashMap();
    }

    public List getSummaryFields(Object targetTable) {
        EGLDataPartsPagesWizardTablePageConfiguration fieldObject = this.getTablePages(targetTable);
        if (fieldObject != null) {
            return fieldObject.getSummaryFieldList();
        }
        return new ArrayList();
    }

    public String getDatabaseName() {
        ConnectionDisplayProperty[] properties = EGLSQLUtility.getConnectionDisplayProperties((IConnectionProfile)this.databaseConnection);
        return properties[1].getValue();
    }

    public boolean isQualifiedTableNames() {
        return this.qualifiedTableNames;
    }

    public void setQualifiedTableNames(boolean qualifiedTableNames) {
        this.qualifiedTableNames = qualifiedTableNames;
    }

    public boolean isUseDelimitedIdentifiers() {
        return this.useDelimitedIdentifiers;
    }

    public void setUseDelimitedIdentifiers(boolean useDelimitedIdentifiers) {
        this.useDelimitedIdentifiers = useDelimitedIdentifiers;
    }

    public boolean isSaveConnectionToDeploymentDescriptor() {
        return this.saveConnectionToDeploymentDescriptor;
    }

    public void setSaveConnectionToDeploymentDescriptor(boolean saveConnectionToDeploymentDescriptor) {
        this.saveConnectionToDeploymentDescriptor = saveConnectionToDeploymentDescriptor;
    }

    class EGLDataPartsPagesWizardTableFieldConfiguration {
        private List keyFieldList = new ArrayList();
        private List selectionConditionFieldList = new ArrayList();

        EGLDataPartsPagesWizardTableFieldConfiguration() {
        }

        public List getKeyFieldList() {
            return this.keyFieldList;
        }

        public void setKeyFieldList(List keyFieldList) {
            this.keyFieldList = keyFieldList;
        }

        public List getSelectionConditionFieldList() {
            return this.selectionConditionFieldList;
        }

        public void setSelectionConditionFieldList(List selectionConditionFieldList) {
            this.selectionConditionFieldList = selectionConditionFieldList;
        }
    }

    class EGLDataPartsPagesWizardTablePageConfiguration {
        private HashMap displayNameList = new HashMap();
        private List summaryList = new ArrayList();

        EGLDataPartsPagesWizardTablePageConfiguration() {
        }

        public HashMap getDisplayNameFieldHash() {
            return this.displayNameList;
        }

        public void setDisplayNameFieldList(HashMap displayNameList) {
            this.displayNameList = displayNameList;
        }

        public List getSummaryFieldList() {
            return this.summaryList;
        }

        public void setSummaryFieldList(List summaryList) {
            this.summaryList = summaryList;
        }
    }
}

