/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.core.Logger;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizardPages;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizardProvider;
import org.eclipse.edt.ide.ui.wizards.BindingEGLConfiguration;
import org.eclipse.ui.forms.IDetailsPage;

public class EGLDDBindingProviderRegistry {
    private boolean initialized;
    private List contributions = new ArrayList();
    private int counter = 0;
    EGLDDBindingWizardProvider[] providers;
    public static final EGLDDBindingProviderRegistry singleton = new EGLDDBindingProviderRegistry();

    private EGLDDBindingProviderRegistry() {
    }

    public void finish() {
        this.counter = 0;
        this.providers = null;
    }

    private void initialize() {
        this.initialized = true;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] conf = reg.getConfigurationElementsFor("org.eclipse.edt.ide.ui.eglDDEditorBindingProvider");
        int i = 0;
        while (i < conf.length) {
            IConfigurationElement currentConf = conf[i];
            this.contributions.add(currentConf);
            ++i;
        }
    }

    public List getContributions() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.contributions;
    }

    public String getIdForContribution(IConfigurationElement contribution) {
        if (!this.initialized) {
            this.initialize();
        }
        return contribution.getAttribute("id");
    }

    public String getDescriptionForContribution(IConfigurationElement contribution) {
        if (!this.initialized) {
            this.initialize();
        }
        return contribution.getAttribute("description");
    }

    public String getNameForContribution(IConfigurationElement contribution) {
        if (!this.initialized) {
            this.initialize();
        }
        return contribution.getAttribute("name");
    }

    public EGLDDBindingWizardProvider[] getEGLDDBindingWizardProviders() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.providers == null) {
            EGLDDBindingWizardProvider[] providers = new EGLDDBindingWizardProvider[this.contributions.size()];
            try {
                int i = 0;
                while (i < this.contributions.size()) {
                    IConfigurationElement contribution = (IConfigurationElement)this.contributions.get(i);
                    providers[i] = new EGLDDBindingWizardProvider();
                    providers[i].id = this.getIdForContribution(contribution);
                    providers[i].description = this.getDescriptionForContribution(contribution);
                    ++this.counter;
                    providers[i].bindingId = providers[i].bindingId;
                    providers[i].bindingconfigurationClass = (BindingEGLConfiguration)contribution.createExecutableExtension("bindingconfigurationClass");
                    IConfigurationElement[] children = contribution.getChildren();
                    EGLDDBindingWizardPages[] eglDDBindingWizardPages = new EGLDDBindingWizardPages[children.length];
                    int j = 0;
                    while (j < children.length) {
                        eglDDBindingWizardPages[j] = new EGLDDBindingWizardPages();
                        eglDDBindingWizardPages[j].name = this.getNameForContribution(children[j]);
                        eglDDBindingWizardPages[j].wizardpage = (EGLDDBindingWizardPage)((Object)children[j].createExecutableExtension("class"));
                        ++j;
                    }
                    providers[i].eglDDBindingWizardPages = eglDDBindingWizardPages;
                    ++i;
                }
            }
            catch (Exception exc) {
                Logger.log((Object)exc, (String)"Failed to create an instance of IDeploymentSolution");
            }
            this.providers = providers;
        }
        return this.providers;
    }

    public IDetailsPage getDetailsPageFor(String type) {
        if (!this.initialized) {
            this.initialize();
        }
        try {
            int i = 0;
            while (i < this.contributions.size()) {
                IConfigurationElement contribution = (IConfigurationElement)this.contributions.get(i);
                String id = this.getIdForContribution(contribution);
                if (id.equals(type.trim())) {
                    return (IDetailsPage)contribution.createExecutableExtension("bindingdetailsPageClass");
                }
                ++i;
            }
        }
        catch (Exception exc) {
            Logger.log((Object)exc, (String)"Failed to create an instance of bindingdetailsPageClass");
        }
        return null;
    }
}

