/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.ui.internal.templates.TemplateEngine;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLFileOperation;
import org.eclipse.edt.ide.ui.wizards.EGLPartConfiguration;
import org.eclipse.edt.ide.ui.wizards.PartTemplateException;

public abstract class PartOperation
extends EGLFileOperation {
    protected String templateName;
    protected EGLPartConfiguration configuration;

    public PartOperation(EGLPartConfiguration configuration) {
        super(configuration);
        this.configuration = configuration;
    }

    public PartOperation(EGLPartConfiguration configuration, ISchedulingRule rule) {
        super(configuration, rule);
        this.configuration = configuration;
    }

    protected String getFileContents(String templateName, String templateId, String[] templateVariablesToReplace, String[] valuesToReplaceWith) throws PartTemplateException {
        String outputString = "";
        if (this.configuration.getChosenTemplateSelection() == 1) {
            outputString = TemplateEngine.getCustomizedTemplateString(templateName, templateId);
        } else if (this.configuration.getChosenTemplateSelection() == 0) {
            outputString = TemplateEngine.getDefaultTemplateString(templateName, templateId);
        }
        if (outputString.compareTo("") != 0) {
            int i = 0;
            while (i < templateVariablesToReplace.length) {
                if ((outputString = this.replaceTemplateWithString(outputString, templateVariablesToReplace[i], valuesToReplaceWith[i])) == null) {
                    throw new PartTemplateException(templateName, templateId, EGLFileConfiguration.TEMPLATE_CORRUPTED);
                }
                ++i;
            }
            while (outputString.indexOf("${") != -1) {
                int tagStart = outputString.indexOf("${");
                int tagEnd = outputString.indexOf("}", tagStart);
                String firstHalfOutputString = outputString.substring(0, tagStart);
                String secondHalfOutputString = outputString.substring(tagStart + 2, outputString.length());
                outputString = String.valueOf(firstHalfOutputString) + secondHalfOutputString;
                firstHalfOutputString = outputString.substring(0, tagEnd - 2);
                secondHalfOutputString = outputString.substring(tagEnd - 1, outputString.length());
                if (firstHalfOutputString.endsWith("cursor")) {
                    firstHalfOutputString = firstHalfOutputString.substring(0, firstHalfOutputString.length() - "cursor".length());
                }
                outputString = String.valueOf(firstHalfOutputString) + secondHalfOutputString;
            }
            return outputString;
        }
        throw new PartTemplateException(templateName, templateId, EGLFileConfiguration.TEMPLATE_NOT_FOUND);
    }

    protected String replaceTemplateWithString(String templateString, String templateVariableName, String newVariableValue) throws PartTemplateException {
        int variableBegin = templateString.indexOf(templateVariableName);
        if (variableBegin == -1) {
            return null;
        }
        String firstHalfOutputString = templateString.substring(0, variableBegin);
        String secondHalfOutputString = templateString.substring(variableBegin + templateVariableName.length(), templateString.length());
        return String.valueOf(firstHalfOutputString) + newVariableValue + secondHalfOutputString;
    }
}

