/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.compiler.internal.eglar.EglarFile;
import org.eclipse.edt.compiler.internal.eglar.EglarManifest;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.wizards.EGLProjectUtility;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ProjectConfigurationOperation
extends WorkspaceModifyOperation {
    private ProjectConfiguration configuration;
    private final String WEB_LIB_FOLDER = "/WebContent/WEB-INF/lib/";

    public ProjectConfigurationOperation(ProjectConfiguration configuration) {
        this.configuration = configuration;
    }

    public ProjectConfigurationOperation(ProjectConfiguration configuration, ISchedulingRule rule) {
        super(rule);
        this.configuration = configuration;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(this.configuration.getProjectName());
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int nSteps = 6;
        monitor.beginTask(NewWizardMessages.CapabilityConfigurationPageOp_desc_egl, nSteps);
        try {
            if (!this.configuration.configureEGLPathOnly()) {
                if (this.configuration.isJavaPlatform()) {
                    EGLProjectUtility.createJavaConfiguration(project, monitor);
                }
                if (this.configuration.isJavaScriptPlatform()) {
                    EGLProjectUtility.createRUIWebContentAndSubFolders(project);
                }
            }
            EGLProjectUtility.addEGLNature(project, monitor);
            this.configuration.isJavaScriptPlatform();
            monitor.setTaskName(NewWizardMessages.BuildPathsBlockOperationdesc_egl);
            monitor.beginTask("", 10);
            try {
                IEGLProject fCurrEProject = EGLCore.create((IProject)project);
                IEGLPathEntry[] oldClassPath = fCurrEProject.getRawEGLPath();
                IEGLPathEntry[] classpath = EGLProjectUtility.createEGLConfiguration(this.configuration, monitor);
                HashSet<IEGLPathEntry> addedEntries = new HashSet<IEGLPathEntry>();
                HashSet<IEGLPathEntry> removedEntries = new HashSet<IEGLPathEntry>(Arrays.asList(oldClassPath));
                HashSet<IEGLPathEntry> remainEntries = new HashSet<IEGLPathEntry>();
                ArrayList<IEGLPathEntry> beforeChangeEntries = new ArrayList<IEGLPathEntry>();
                ArrayList<IEGLPathEntry> afterChangeEntries = new ArrayList<IEGLPathEntry>();
                int i = 0;
                while (i < classpath.length) {
                    IEGLPathEntry entry = classpath[i];
                    int count = 0;
                    int j = i;
                    boolean entryExist = false;
                    while (count < oldClassPath.length) {
                        IEGLPathEntry oldEntry;
                        if (j >= oldClassPath.length) {
                            j = 0;
                        }
                        if ((oldEntry = oldClassPath[j]).getPath().equals((Object)entry.getPath()) && oldEntry.getEntryKind() == entry.getEntryKind()) {
                            entryExist = true;
                            remainEntries.add(oldEntry);
                            if (oldEntry.equals(entry)) break;
                            beforeChangeEntries.add(oldEntry);
                            afterChangeEntries.add(entry);
                            break;
                        }
                        j = j < oldClassPath.length - 1 ? ++j : 0;
                        ++count;
                    }
                    if (!entryExist) {
                        addedEntries.add(entry);
                    }
                    ++i;
                }
                removedEntries.removeAll(remainEntries);
                this.postModifyingEGLEntries(beforeChangeEntries.toArray(new IEGLPathEntry[beforeChangeEntries.size()]), afterChangeEntries.toArray(new IEGLPathEntry[afterChangeEntries.size()]), fCurrEProject);
                this.postRemovingEglarLibraries(removedEntries.toArray(new IEGLPathEntry[removedEntries.size()]), fCurrEProject);
                this.postAddingEglarLibraries(addedEntries.toArray(new IEGLPathEntry[addedEntries.size()]), fCurrEProject);
                this.postAddingJavaBuildPathEntry(classpath, project, monitor);
            }
            finally {
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void postAddingJavaBuildPathEntry(IEGLPathEntry[] selectedEntries, IProject curProject, IProgressMonitor monitor) {
        try {
            if (curProject.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)curProject);
                IClasspathEntry[] javaClassPathEntries = javaProject.getRawClasspath();
                ArrayList<IClasspathEntry> afterChangeEntries = new ArrayList<IClasspathEntry>();
                HashSet<IPath> ipathSet = new HashSet<IPath>();
                IClasspathEntry[] iClasspathEntryArray = javaClassPathEntries;
                int n = javaClassPathEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry icpEntry = iClasspathEntryArray[n2];
                    ipathSet.add(icpEntry.getPath());
                    afterChangeEntries.add(icpEntry);
                    ++n2;
                }
                iClasspathEntryArray = selectedEntries;
                n = selectedEntries.length;
                n2 = 0;
                while (n2 < n) {
                    IClasspathEntry iEGLpathEntry = iClasspathEntryArray[n2];
                    if (iEGLpathEntry.getEntryKind() == 2) {
                        IPath eglProjectPath = iEGLpathEntry.getPath();
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(eglProjectPath);
                        if (resource != null && resource.exists() && resource.getProject().hasNature("org.eclipse.jdt.core.javanature") && !ipathSet.contains(eglProjectPath)) {
                            ipathSet.add(eglProjectPath);
                            afterChangeEntries.add(JavaCore.newProjectEntry((IPath)eglProjectPath));
                        }
                    }
                    ++n2;
                }
                javaProject.setRawClasspath(afterChangeEntries.toArray(new IClasspathEntry[afterChangeEntries.size()]), monitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void postAddingEglarLibraries(IEGLPathEntry[] addedEntries, IEGLProject eglProject) {
        IProject project = eglProject.getProject();
        ArrayList<IClasspathEntry> allAddedLibEntries = new ArrayList<IClasspathEntry>();
        IEGLPathEntry[] iEGLPathEntryArray = addedEntries;
        int n = addedEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IEGLPathEntry pathEntry = iEGLPathEntryArray[n2];
            try {
                EglarFile eglar;
                if (this.isEntryRepresentingEGLAR(eglProject, pathEntry) && (eglar = EGLProjectUtility.createEglarFileFromPathEntry(eglProject, pathEntry)) != null) {
                    EglarManifest manifest = eglar.getManifest();
                    if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                        IFolder webLib = project.getFolder((IPath)new Path("/WebContent/WEB-INF/lib/"));
                        String[] generatedJars = manifest.getJavaJars();
                        IFile[] generatedJarFiles = null;
                        if (generatedJars != null) {
                            generatedJarFiles = JavaEEProjectUtilities.isDynamicWebProject((IProject)project) || EGLProject.hasRUINature((IProject)project) ? EGLProjectUtility.createFilesFromEglar((IResource)webLib, eglar, generatedJars, false) : EGLProjectUtility.createFilesFromEglar((IResource)project, eglar, generatedJars);
                        }
                        if (generatedJarFiles != null) {
                            int i = 0;
                            while (i < generatedJarFiles.length) {
                                IFile jarFile = generatedJarFiles[i];
                                IPath generatedJarPath = jarFile.getFullPath();
                                allAddedLibEntries.add(JavaCore.newLibraryEntry((IPath)generatedJarPath, null, null, (boolean)pathEntry.isExported()));
                                ++i;
                            }
                        }
                    }
                    if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project) || EGLProject.hasRUINature((IProject)project)) {
                        String webLibFolder = "/WebContent/WEB-INF/lib/";
                        Enumeration entries = eglar.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry entry = (ZipEntry)entries.nextElement();
                            if (!entry.getName().startsWith(webLibFolder) || entry.isDirectory() || !(entry instanceof JarEntry)) continue;
                            EGLProjectUtility.createFileFromEglar((IResource)project, eglar, entry.getName(), entry.getName());
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        try {
            EGLProjectUtility.addClasspathEntriesIfNecessary(project, allAddedLibEntries.toArray(new IClasspathEntry[allAddedLibEntries.size()]));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void postRemovingEglarLibraries(IEGLPathEntry[] removedEntries, IEGLProject eglProject) {
        IProject project = eglProject.getProject();
        ArrayList<IPath> allRemovedLibEntries = new ArrayList<IPath>();
        IEGLPathEntry[] iEGLPathEntryArray = removedEntries;
        int n = removedEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IEGLPathEntry pathEntry = iEGLPathEntryArray[n2];
            try {
                EglarFile eglar;
                if (this.isEntryRepresentingEGLAR(eglProject, pathEntry) && (eglar = EGLProjectUtility.createEglarFileFromPathEntry(eglProject, pathEntry)) != null) {
                    EglarManifest manifest = eglar.getManifest();
                    if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                        IFolder webLib = project.getFolder((IPath)new Path("/WebContent/WEB-INF/lib/"));
                        String[] generatedJars = manifest.getJavaJars();
                        IFile[] generatedJarFiles = null;
                        if (generatedJars != null) {
                            generatedJarFiles = JavaEEProjectUtilities.isDynamicWebProject((IProject)project) || EGLProject.hasRUINature((IProject)project) ? EGLProjectUtility.removeFilesFromEglar((IResource)webLib, eglar, generatedJars, false) : EGLProjectUtility.removeFilesFromEglar((IResource)project, eglar, generatedJars);
                        }
                        if (generatedJarFiles != null) {
                            int i = 0;
                            while (i < generatedJarFiles.length) {
                                IFile jarFile = generatedJarFiles[i];
                                if (jarFile != null) {
                                    allRemovedLibEntries.add(jarFile.getFullPath());
                                }
                                ++i;
                            }
                        }
                    }
                    if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project) || EGLProject.hasRUINature((IProject)project)) {
                        String webLibFolder = "/WebContent/WEB-INF/lib/";
                        Enumeration entries = eglar.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry entry = (ZipEntry)entries.nextElement();
                            if (!entry.getName().startsWith(webLibFolder) || entry.isDirectory() || !(entry instanceof JarEntry)) continue;
                            EGLProjectUtility.removeFileFromEglar((IResource)project, eglar, entry.getName(), entry.getName());
                        }
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        try {
            EGLProjectUtility.removeClasspathLibraryEntriesIfNecessary(project, allRemovedLibEntries.toArray(new IPath[allRemovedLibEntries.size()]));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void postModifyingEGLEntries(IEGLPathEntry[] beforeChangeEntries, IEGLPathEntry[] afterChangeEntries, IEGLProject eglProject) {
        IProject project = eglProject.getProject();
        ArrayList<IClasspathEntry> allModifiedLibEntries = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < beforeChangeEntries.length) {
            IEGLPathEntry beforeEntry = beforeChangeEntries[i];
            IEGLPathEntry afterEntry = afterChangeEntries[i];
            if (beforeEntry.isExported() != afterEntry.isExported()) {
                try {
                    EglarFile eglar;
                    if (this.isEntryRepresentingEGLAR(eglProject, beforeEntry) && (eglar = EGLProjectUtility.createEglarFileFromPathEntry(eglProject, beforeEntry)) != null) {
                        EglarManifest manifest = eglar.getManifest();
                        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                            String[] generatedJars = manifest.getJavaJars();
                            boolean isExported = afterEntry.isExported();
                            if (generatedJars != null) {
                                int j = 0;
                                while (j < generatedJars.length) {
                                    IResource jarFile;
                                    Path jarRelativePath = null;
                                    if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project) || EGLProject.hasRUINature((IProject)project)) {
                                        String jarName = generatedJars[j];
                                        int index = jarName.lastIndexOf("/");
                                        if (index > -1) {
                                            jarName = jarName.substring(index + 1);
                                        }
                                        jarRelativePath = new Path("/WebContent/WEB-INF/lib/").append(jarName);
                                    } else {
                                        jarRelativePath = new Path(generatedJars[j]);
                                    }
                                    if (jarRelativePath != null && (jarFile = project.findMember((IPath)jarRelativePath)) != null && jarFile.exists() && jarFile instanceof IFile) {
                                        IPath jarPath = jarFile.getFullPath();
                                        IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)jarPath, null, null, (boolean)isExported);
                                        allModifiedLibEntries.add(entry);
                                    }
                                    ++j;
                                }
                            }
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        try {
            EGLProjectUtility.modifyClasspathLibraryEntry(project, allModifiedLibEntries.toArray(new IClasspathEntry[allModifiedLibEntries.size()]));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private boolean isEntryRepresentingEGLAR(IEGLProject eProject, IEGLPathEntry entry) {
        if (entry.getEntryKind() == 1) {
            IPath entryPath;
            if (eProject.isBinary() && (entryPath = entry.getPath()).getDevice() == null && entryPath.segmentCount() == 2) {
                String eglarName = entryPath.lastSegment().toString();
                String containerName = entryPath.segment(0).toString();
                String extension = entryPath.getFileExtension();
                if (extension.toLowerCase().equals("eglar")) {
                    String projName;
                    int index = eglarName.toLowerCase().lastIndexOf(".eglar");
                    if (index > -1) {
                        eglarName = eglarName.substring(0, index);
                    }
                    if (eglarName.equals(projName = eProject.getElementName()) && containerName.equals(projName)) {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }
}

