/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ProjectRemoveOperation
extends WorkspaceModifyOperation {
    private ProjectConfiguration configuration;

    public ProjectRemoveOperation(ProjectConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject fCurrProject = null;
        Path fCurrProjectLocation = null;
        fCurrProject = fWorkspaceRoot.getProject(this.configuration.getProjectName());
        fCurrProjectLocation = this.configuration.isUseDefaults() ? new Path(this.configuration.getInitialProjectLocation()) : new Path(this.configuration.getCustomProjectLocation());
        if (fCurrProject == null || !fCurrProject.exists()) {
            return;
        }
        boolean noProgressMonitor = Platform.getLocation().equals((Object)fCurrProjectLocation);
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.NewProjectCreationWizardPageRemoveprojectDesc, 3);
        try {
            try {
                fCurrProject.delete(true, false, monitor);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            fCurrProject = null;
        }
    }
}

