/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.operation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.utils.EclipseUtilities;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.deployment.operation.AbstractDeploymentOperation;
import org.eclipse.edt.ide.deployment.results.DeploymentResultMessageRequestor;
import org.eclipse.edt.ide.deployment.results.IDeploymentResultsCollector;
import org.eclipse.edt.ide.deployment.services.generators.DeploymentDescUtil;
import org.eclipse.edt.ide.deployment.solution.DeploymentContext;
import org.eclipse.edt.ide.deployment.utilities.DeploymentUtilities;

public class GenerateServiceBindXMLFileOperation
extends AbstractDeploymentOperation {
    public static final String BIND_XML_FILE_SUFFIX = "-bnd.xml";
    private DeploymentContext context;

    public void preCheck(DeploymentContext context, IDeploymentResultsCollector resultsCollector, IProgressMonitor monitor) throws CoreException {
        DeploymentDesc desc;
        if (context.getStatus() != 1 && (desc = context.getDeploymentDesc()).getBindings() != null && desc.getBindings().size() > 0) {
            context.setStatus(1);
        }
    }

    public void execute(DeploymentContext context, IDeploymentResultsCollector resultsCollector, IProgressMonitor monitor) throws CoreException {
        this.context = context;
        DeploymentResultMessageRequestor messageRequestor = new DeploymentResultMessageRequestor(resultsCollector);
        String javaSourceFolder = EclipseUtilities.getJavaSourceFolderName((IProject)context.getTargetProject());
        this.generateBindFile(context.getDeploymentDesc(), javaSourceFolder, monitor, messageRequestor);
        for (DeploymentDesc egldd : context.getDependentModels()) {
            this.generateBindFile(egldd, javaSourceFolder, monitor, messageRequestor);
        }
    }

    private void generateBindFile(DeploymentDesc egldd, String javaSourceFolder, IProgressMonitor monitor, DeploymentResultMessageRequestor messageRequestor) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(DeploymentDescUtil.convertToBindXML(egldd, this.context.getTargetProject()).getBytes("UTF-8"));
            Path targetFilePath = new Path("/" + this.context.getTargetProject().getName() + "/" + javaSourceFolder + "/" + egldd.getName().toLowerCase() + BIND_XML_FILE_SUFFIX);
            IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)targetFilePath);
            if (targetFile.exists()) {
                targetFile.setContents((InputStream)is, true, true, monitor);
            } else {
                targetFile.create((InputStream)is, true, monitor);
            }
            ((InputStream)is).close();
            messageRequestor.addMessage(DeploymentUtilities.createEGLDeploymentInformationalMessage((String)"8316", null, (String[])new String[]{targetFile.getProjectRelativePath().toPortableString()}));
        }
        catch (Exception e) {
            messageRequestor.addMessage(DeploymentUtilities.createEGLDeploymentInformationalMessage((String)"8306", null, (String[])new String[]{DeploymentUtilities.createExceptionMessage((Throwable)e)}));
        }
    }
}

