/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.serialization.binary;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.MofFactory;
import org.eclipse.edt.mof.impl.EObjectImpl;
import org.eclipse.edt.mof.impl.NullableSlot;
import org.eclipse.edt.mof.impl.Slot;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Deserializer;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.edt.mof.serialization.ProxyEClass;
import org.eclipse.edt.mof.serialization.ProxyEObject;
import org.eclipse.edt.mof.utils.EList;

public class BinaryDeserializer
implements Deserializer {
    List constantPoolList;
    EObject[] eObjectArray;
    Map<ProxyEObject, Integer> proxies;
    InputStream inputStream;
    MofFactory factory = MofFactory.INSTANCE;
    IEnvironment env;
    int majorVersion;
    int minorVersion;
    boolean readMinimal = false;
    boolean doInstantiateOnRead = true;

    public BinaryDeserializer(InputStream input, IEnvironment env) {
        this.inputStream = input;
        this.proxies = new HashMap<ProxyEObject, Integer>();
        this.env = env;
    }

    @Override
    public EObject deserialize() throws DeserializationException {
        if (this.inputStream == null) {
            throw new DeserializationException("Input not set");
        }
        this.readMagic();
        this.readVersion();
        this.readPool();
        int size = (int)this.readUint4();
        this.eObjectArray = new EObject[size];
        EObject obj = (EObject)this.readObject();
        for (Map.Entry<ProxyEObject, Integer> entry : this.proxies.entrySet()) {
            ProxyEObject proxy = entry.getKey();
            EObject eObject = this.eObjectArray[entry.getValue()];
            proxy.updateReferences(eObject);
        }
        return obj;
    }

    private List getConstantPoolList() {
        if (this.constantPoolList == null) {
            this.constantPoolList = new ArrayList();
        }
        return this.constantPoolList;
    }

    private byte[] getMD5HashKey(BufferedInputStream stream) throws DeserializationException {
        this.inputStream = stream;
        this.readMagic();
        this.readVersion();
        return this.readBytes();
    }

    private void readMagic() throws DeserializationException {
        long magic = this.readUint4();
        if (magic != 3405700781L) {
            throw new DeserializationException("Not a valid Type to deserialize");
        }
    }

    private boolean hasUint2PoolSize() {
        if (this.majorVersion > 7) {
            return false;
        }
        return this.minorVersion <= 1;
    }

    public long readUint4() throws DeserializationException {
        byte[] bytes = new byte[4];
        this.readBytes(bytes);
        long l = 0L;
        l |= (long)(bytes[0] & 0xFF);
        l <<= 8;
        l |= (long)(bytes[1] & 0xFF);
        l <<= 8;
        l |= (long)(bytes[2] & 0xFF);
        l <<= 8;
        return l |= (long)(bytes[3] & 0xFF);
    }

    public int readUint2() throws DeserializationException {
        byte[] bytes = new byte[2];
        this.readBytes(bytes);
        int i = 0;
        i |= bytes[0] & 0xFF;
        i <<= 8;
        return i |= bytes[1] & 0xFF;
    }

    public void readBytes(byte[] bytes) throws DeserializationException {
        try {
            this.inputStream.read(bytes);
        }
        catch (IOException e) {
            throw new DeserializationException(e.getMessage(), e);
        }
    }

    public byte[] readBytes() throws DeserializationException {
        int len = this.readUint2();
        byte[] bytes = new byte[len];
        this.readBytes(bytes);
        return bytes;
    }

    private void readVersion() throws DeserializationException {
        this.majorVersion = this.readUint2();
        this.minorVersion = this.readUint2();
        if (this.majorVersion < 9) {
            return;
        }
        if (this.majorVersion > 9 || this.minorVersion > 10000) {
            throw new DeserializationException("Incompatible version");
        }
    }

    private void readPool() throws DeserializationException {
        int length = this.hasUint2PoolSize() ? this.readUint2() - 1 : (int)this.readUint4() - 1;
        int i = 0;
        while (i < length) {
            this.getConstantPoolList().add(this.readPoolEntry());
            ++i;
        }
    }

    private Object readPoolEntry() throws DeserializationException {
        int kind = this.readUint2();
        switch (kind) {
            case 998: {
                return null;
            }
            case 650: {
                return this.readString();
            }
            case 997: {
                return this.readString();
            }
        }
        throw new DeserializationException("Unknown Pool entry type");
    }

    private String readString() throws DeserializationException {
        try {
            byte[] bytes = this.readBytes();
            return new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new DeserializationException(e.getMessage(), e);
        }
    }

    private Object readObjectAtPoolOffset() throws DeserializationException {
        int index = (int)this.readUint4();
        if (index > this.getConstantPoolList().size() - 1) {
            throw new DeserializationException("Constant pool index access out of range: " + Integer.toString(index));
        }
        return this.getConstantPoolList().get(index);
    }

    private EObject readEObjectAtIndex() throws DeserializationException {
        int index = (int)this.readUint4();
        if (index > this.eObjectArray.length - 1) {
            throw new DeserializationException("EObject list index access out of range: " + Integer.toString(index));
        }
        EObject obj = this.eObjectArray[index];
        if (obj == null) {
            this.eObjectArray[index] = obj = new ProxyEObject();
            this.proxies.put((ProxyEObject)obj, index);
        }
        return obj;
    }

    private Object readObject() throws DeserializationException {
        Object obj = this.readObject(this.readUint2());
        return obj;
    }

    private Object readObject(int kind) throws DeserializationException {
        switch (kind) {
            case 998: {
                return null;
            }
            case 999: {
                return this.readObjectAtPoolOffset();
            }
            case 997: {
                String typeSignature = (String)this.readObjectAtPoolOffset();
                EObject type = null;
                try {
                    type = this.env.find(typeSignature);
                }
                catch (MofObjectNotFoundException e) {
                    throw new DeserializationException(e);
                }
                return type;
            }
            case 648: {
                return this.readEObjectAtIndex();
            }
            case 649: {
                EObject obj;
                int index = (int)this.readUint4();
                Slot[] slots = (Slot[])this.readObject();
                if (slots[0].get() instanceof ProxyEClass) {
                    ProxyEClass type = (ProxyEClass)slots[0].get();
                    obj = new ProxyEObject();
                    type.getProxyObjects().add((ProxyEObject)obj);
                    obj.slots = slots;
                } else if (this.doInstantiateOnRead) {
                    EClass type = (EClass)slots[0].get();
                    obj = type.newInstance(false);
                    ((EObjectImpl)obj).setSlots(slots);
                } else {
                    obj = null;
                }
                this.eObjectArray[index] = obj;
                return obj;
            }
            case 673: {
                Slot slot = new Slot();
                slot.set(this.readObject());
                return slot;
            }
            case 674: {
                NullableSlot slot = new NullableSlot();
                slot.setIsNull((Boolean)this.readObjectAtPoolOffset());
                slot.set(this.readObject());
                return slot;
            }
            case 651: {
                return new BigInteger((String)this.readObjectAtPoolOffset());
            }
            case 652: {
                return new Long((String)this.readObjectAtPoolOffset());
            }
            case 653: {
                return new Integer((String)this.readObjectAtPoolOffset());
            }
            case 654: {
                return new Float((String)this.readObjectAtPoolOffset());
            }
            case 655: {
                return new Double((String)this.readObjectAtPoolOffset());
            }
            case 656: {
                return new BigDecimal((String)this.readObjectAtPoolOffset());
            }
            case 18: {
                Class<?> enumClass;
                String name = (String)this.readObjectAtPoolOffset();
                String entry = (String)this.readObjectAtPoolOffset();
                try {
                    enumClass = Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                return Enum.valueOf(enumClass, entry);
            }
            case 659: {
                return Boolean.TRUE;
            }
            case 660: {
                return Boolean.FALSE;
            }
            case 662: {
                return this.readIntegerArray();
            }
            case 663: {
                return this.readIntegerArrayArray();
            }
            case 664: {
                return this.readStringArray();
            }
            case 665: {
                return this.readStringArrayArray();
            }
            case 672: {
                return this.readSlotArray();
            }
            case 666: {
                return this.readObjectArray();
            }
            case 671: {
                return this.readList();
            }
        }
        throw new DeserializationException("Unknown Object type: " + Integer.toString(kind));
    }

    private boolean readBoolean() throws DeserializationException {
        byte[] value = new byte[1];
        this.readBytes(value);
        return (value[0] & 0xFF) != 0;
    }

    private Integer[] readIntegerArray() throws DeserializationException {
        int len = this.readUint2();
        Integer[] arr = new Integer[len];
        int i = 0;
        while (i < len) {
            arr[i] = new Integer((String)this.readObjectAtPoolOffset());
            ++i;
        }
        return arr;
    }

    private Integer[][] readIntegerArrayArray() throws DeserializationException {
        int len = this.readUint2();
        Integer[][] arr = new Integer[len][];
        int i = 0;
        while (i < len) {
            arr[i] = this.readIntegerArray();
            ++i;
        }
        return arr;
    }

    private String[] readStringArray() throws DeserializationException {
        int len = this.readUint2();
        String[] arr = new String[len];
        int i = 0;
        while (i < len) {
            arr[i] = (String)this.readObjectAtPoolOffset();
            ++i;
        }
        return arr;
    }

    private String[][] readStringArrayArray() throws DeserializationException {
        int len = this.readUint2();
        String[][] arr = new String[len][];
        int i = 0;
        while (i < len) {
            arr[i] = this.readStringArray();
            ++i;
        }
        return arr;
    }

    private Slot[] readSlotArray() throws DeserializationException {
        int len = this.readUint2();
        Slot[] arr = new Slot[len];
        if (this.doInstantiateOnRead) {
            arr[0] = (Slot)this.readObject();
            int i = 1;
            while (i < len) {
                Object o;
                if (this.readMinimal) {
                    if (arr[0].get() instanceof EClass) {
                        EClass eClass = (EClass)arr[0].get();
                        eClass.getEField(i);
                    } else {
                        o = this.readObject();
                        if (o == null) {
                            o = new Slot();
                        }
                        arr[i] = (Slot)o;
                        if (arr[i].get() instanceof ProxyEObject) {
                            ((ProxyEObject)arr[i].get()).registerReference(arr, i);
                        }
                    }
                } else {
                    o = this.readObject();
                    if (o == null) {
                        o = new Slot();
                    }
                    arr[i] = (Slot)o;
                    if (arr[i].get() instanceof ProxyEObject) {
                        ((ProxyEObject)arr[i].get()).registerReference(arr, i);
                    }
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < len) {
                this.readObject();
                ++i;
            }
        }
        return arr;
    }

    private Object[] readObjectArray() throws DeserializationException {
        int len = this.readUint2();
        Object[] arr = new Object[len];
        int i = 0;
        while (i < len) {
            arr[i] = this.readObject();
            ++i;
        }
        return arr;
    }

    private List readList() throws DeserializationException {
        int len = this.readUint2();
        EList<Object> list = new EList<Object>();
        int i = 0;
        while (i < len) {
            Object obj = this.readObject();
            list.add(i, obj);
            ++i;
        }
        return list;
    }

    private int getMajorVersion() {
        return this.majorVersion;
    }

    private int getMinorVersion() {
        return this.minorVersion;
    }
}

