/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.ast.rewrite;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.core.ast.AbstractASTNodeVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTPartVisitor;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.IOStatementClauseInfo;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.ide.core.ast.rewrite.ASTEdit;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewriteVisitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ASTRewrite {
    private static String TAB = "\t";
    private int importsRemovedCount;
    private boolean importsAdded = false;
    private AddImportEdit lastAddImportEdit = null;
    private File fileAST;
    private Map edits = new HashMap();

    private ASTRewrite(File fileAST) {
        this.fileAST = fileAST;
    }

    private static String getLineDelimiter(IDocument document) throws BadLocationException {
        String lineDelimiter = document.getLineDelimiter(0);
        return lineDelimiter == null ? System.getProperty("line.separator") : lineDelimiter;
    }

    public static ASTRewrite create(File fileAST) {
        return new ASTRewrite(fileAST);
    }

    private void addEdit(Node node, ASTEdit edit) {
        ArrayList<ASTEdit> editsForNode = (ArrayList<ASTEdit>)this.edits.get(node);
        if (editsForNode == null) {
            editsForNode = new ArrayList<ASTEdit>();
            this.edits.put(node, editsForNode);
        } else {
            Iterator iter = editsForNode.iterator();
            while (iter.hasNext()) {
                ((ASTEdit)iter.next()).editAdded(edit);
            }
        }
        editsForNode.add(edit);
        Collections.sort(editsForNode);
    }

    public void addClassField(Part part, String fieldName, String fieldType) {
        this.addClassFieldAtIndex(part, fieldName, fieldType, null, -1);
    }

    public void addClassField(Part part, String fieldName, String fieldType, String initialValue) {
        this.addClassFieldAtIndex(part, fieldName, fieldType, initialValue, -1);
    }

    public void addClassFieldAtIndex(Part part, String fieldName, String fieldType, int index) {
        this.addClassFieldAtIndex(part, fieldName, fieldType, null, index);
    }

    public void addClassFieldAtIndex(Part part, String fieldName, String fieldType, String initialValue, int index) {
        this.addEdit((Node)part, new AddClassFieldEdit(part, fieldName, fieldType, initialValue, index));
    }

    public void addFunction(Part part, String functionText) {
        this.addEdit((Node)part, new AddFunctionEdit(part, functionText));
    }

    public void addImport(File file, String packageOrPartName, boolean isOnDemand) {
        this.addImport(file, packageOrPartName, isOnDemand, null);
    }

    public void addImport(File file, String packageOrPartName, boolean isOnDemand, Comparator importComparator) {
        AddImportEdit addImportEdit = new AddImportEdit(file, packageOrPartName, isOnDemand, importComparator);
        this.addEdit((Node)file, addImportEdit);
        this.importsAdded = true;
        this.lastAddImportEdit = addImportEdit;
    }

    public void addIOStatementClause(Statement statement, IOStatementClauseInfo clauseInfo, Object clauseContent) {
        this.addEdit((Node)statement, new InsertStatementClauseEdit(statement, clauseInfo, clauseContent));
    }

    public void completeIOStatement(Statement statement, String clauseContent) {
        this.addEdit((Node)statement, new ComplementStatementClauseEdit(statement, clauseContent));
    }

    public void addPackage(File file, String packageName) {
        this.addEdit((Node)file, new AddPackageEdit(packageName));
    }

    public void addPart(File file, String partText) {
        this.addEdit((Node)file, new AddPartEdit(file, partText));
    }

    public void addSimpleSetting(FunctionDataDeclaration dataDecl, String settingName, String settingValue) {
        this.addSimpleSettings(dataDecl, new String[]{settingName}, new String[]{settingValue});
    }

    public void addSimpleSettings(FunctionDataDeclaration dataDecl, String[] settingNames, String[] settingValues) {
        this.addEdit((Node)dataDecl, new AddSimpleSettingsEdit(new FunctionDataDeclarationSettingsBlockContainer(dataDecl), settingNames, settingValues));
    }

    public void addSimpleSetting(ClassDataDeclaration dataDecl, String settingName, String settingValue) {
        this.addSimpleSettings(dataDecl, new String[]{settingName}, new String[]{settingValue});
    }

    public void addSimpleSettings(ClassDataDeclaration dataDecl, String[] settingNames, String[] settingValues) {
        this.addEdit((Node)dataDecl, new AddSimpleSettingsEdit(new ClassDataDeclarationSettingsBlockContainer(dataDecl), settingNames, settingValues));
    }

    public void addSimpleSetting(NewExpression newExpr, String settingName, String settingValue) {
        this.addSimpleSettings(newExpr, new String[]{settingName}, new String[]{settingValue});
    }

    public void addSimpleSettings(NewExpression newExpr, String[] settingNames, String[] settingValues) {
        this.addEdit((Node)newExpr, new AddSimpleSettingsEdit(new NewExpressionSettingsBlockContainer(newExpr), settingNames, settingValues));
    }

    public void addSimpleSetting(SetValuesExpression setValuesExpression, String settingName, String settingValue) {
        this.addSimpleSettings(setValuesExpression, new String[]{settingName}, new String[]{settingValue});
    }

    public void addSimpleSettings(SetValuesExpression setValuesExpression, String[] settingNames, String[] settingValues) {
        this.addEdit((Node)setValuesExpression, new AddSimpleSettingsEdit(new SetValuesExpressionSettingsBlockContainer(setValuesExpression), settingNames, settingValues));
    }

    public void removeNode(Node node) {
        this.addEdit(node, new RemoveNodeEdit(node));
        node.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(ImportDeclaration importDeclaration) {
                ASTRewrite aSTRewrite = ASTRewrite.this;
                aSTRewrite.importsRemovedCount = aSTRewrite.importsRemovedCount + 1;
                return false;
            }
        });
    }

    public void removeSetting(FunctionDataDeclaration dataDecl, Node setting) {
        this.removeSettings(dataDecl, new Node[]{setting});
    }

    public void removeSettings(FunctionDataDeclaration dataDecl, Node[] settings) {
        this.addEdit((Node)dataDecl, new RemoveSettingsEdit(new FunctionDataDeclarationSettingsBlockContainer(dataDecl), settings));
    }

    public void removeSetting(ClassDataDeclaration dataDecl, Node setting) {
        this.removeSettings(dataDecl, new Node[]{setting});
    }

    public void removeSettings(ClassDataDeclaration dataDecl, Node[] settings) {
        this.addEdit((Node)dataDecl, new RemoveSettingsEdit(new ClassDataDeclarationSettingsBlockContainer(dataDecl), settings));
    }

    public void removeSetting(NewExpression newExpr, Node setting) {
        this.removeSettings(newExpr, new Node[]{setting});
    }

    public void removeSettings(NewExpression newExpr, Node[] settings) {
        this.addEdit((Node)newExpr, new RemoveSettingsEdit(new NewExpressionSettingsBlockContainer(newExpr), settings));
    }

    public void removeSetting(SetValuesExpression newExpr, Node setting) {
        this.removeSettings(newExpr, new Node[]{setting});
    }

    public void removeSettings(SetValuesExpression newExpr, Node[] settings) {
        this.addEdit((Node)newExpr, new RemoveSettingsEdit(new SetValuesExpressionSettingsBlockContainer(newExpr), settings));
    }

    public void removeText(int offset, int length) {
        this.addEdit((Node)this.fileAST, new RemoveTextEdit(offset, length));
    }

    public void rename(Name nameNode, String newName) {
        this.setText((Node)nameNode, newName);
    }

    public void setText(Node node, String newText) {
        this.addEdit(node, new SetTextEdit(node, newText));
    }

    public TextEdit rewriteAST(IDocument document) {
        MultiTextEdit rootEdit = new MultiTextEdit();
        this.fileAST.accept((IASTVisitor)new ASTRewriteVisitor(document, (TextEdit)rootEdit, this.edits));
        return rootEdit;
    }

    private static String getLeadingWhitespaceOnLine(IDocument document, int offset) throws BadLocationException {
        int lineOfOffset = document.getLineOfOffset(offset);
        int offsetOfLine = document.getLineOffset(lineOfOffset);
        String leadingText = document.get(offsetOfLine, offset - offsetOfLine);
        return leadingText.replaceFirst("\\S.*", "");
    }

    private static int offsetOfClosestCharToLeft(IDocument document, char ch, int startOffset) throws BadLocationException {
        int currentOffset = startOffset - 1;
        while (currentOffset != 0) {
            if (document.getChar(currentOffset) == ch) {
                return currentOffset;
            }
            --currentOffset;
        }
        return startOffset;
    }

    private static String precedingWhitespaceCharacters(IDocument document, Node node) throws BadLocationException {
        int offset = node.getOffset();
        StringBuffer sb = new StringBuffer();
        --offset;
        boolean inBlockComent = false;
        while (offset - sb.length() > -1) {
            char ch = document.getChar(offset - sb.length());
            if (!Character.isWhitespace(ch)) {
                boolean characterIsWhitespace = false;
                if ('/' == ch && ASTRewrite.isPartOrChildOfPart(node)) {
                    if (!inBlockComent && '*' == (ch = document.getChar(offset - sb.length() - 1))) {
                        inBlockComent = true;
                        characterIsWhitespace = true;
                        sb.append('/');
                    }
                } else if ('*' == ch && inBlockComent && '/' == (ch = document.getChar(offset - sb.length() - 1))) {
                    inBlockComent = false;
                    characterIsWhitespace = true;
                    sb.append('*');
                }
                if (!characterIsWhitespace && !inBlockComent) {
                    int lineNum = document.getLineOfOffset(offset - sb.length());
                    IRegion lineInfo = document.getLineInformation(lineNum);
                    String lineContents = document.get(lineInfo.getOffset(), offset - sb.length() - lineInfo.getOffset());
                    int indexOfSingleLineCommentStart = lineContents.indexOf("//");
                    if (indexOfSingleLineCommentStart == -1) break;
                    sb.append(ch);
                    sb.append(new StringBuffer(lineContents.substring(indexOfSingleLineCommentStart)).reverse());
                    continue;
                }
            }
            sb.append(ch);
        }
        return sb.reverse().toString();
    }

    private static boolean isPartOrChildOfPart(Node node) {
        return node instanceof Part || node.getParent() instanceof Part;
    }

    private static void appendLines(StringBuffer sb, String prefix, String str, String NL) {
        StringTokenizer st = new StringTokenizer(str, NL);
        while (st.hasMoreTokens()) {
            sb.append(prefix);
            sb.append(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            sb.append(NL);
        }
    }

    private static class AddClassFieldEdit
    extends DefaultASTEdit {
        private Part part;
        private String fieldName;
        private String fieldType;
        private String initialValue;
        private String fieldDeclaration;
        private int index;

        public AddClassFieldEdit(Part part, String fieldName, String fieldType, String initialValue, int index) {
            this.part = part;
            this.fieldName = fieldName;
            this.fieldType = fieldType;
            this.initialValue = initialValue;
            this.index = index;
        }

        @Override
        public TextEdit toTextEdit(IDocument document) throws BadLocationException {
            String NL = ASTRewrite.getLineDelimiter(document);
            OffsetFinder offsetFinder = new OffsetFinder(document, this.part, this.index);
            StringBuffer insertText = new StringBuffer();
            if (this.fieldDeclaration == null) {
                insertText.append(NL);
                insertText.append(offsetFinder.getPrefixForNewDataDeclaration());
                insertText.append(this.fieldName);
                insertText.append(" ");
                insertText.append(this.fieldType);
                if (this.initialValue != null) {
                    insertText.append(" = ");
                    insertText.append(this.initialValue);
                }
                insertText.append(";");
            } else {
                insertText.append(this.fieldDeclaration);
            }
            return new InsertEdit(offsetFinder.getOffsetForNewDataDeclaration(), insertText.toString());
        }

        @Override
        public boolean isInsertEdit() {
            return true;
        }

        private static class OffsetFinder
        extends AbstractASTPartVisitor {
            private IDocument document;
            private Part part;
            private SettingsBlock lastLeadingSettingsBlock;
            private ClassDataDeclaration lastClassDataDeclaration;
            private boolean readingLeadingSettingsBlocks = true;
            private boolean visitedPart;
            private int numFieldsVisited = 0;
            private int index;

            OffsetFinder(IDocument document, Part part, int index) {
                this.document = document;
                this.part = part;
                this.index = index;
            }

            private void visitPart() {
                if (!this.visitedPart) {
                    this.part.accept((IASTVisitor)this);
                }
            }

            public String getPrefixForNewDataDeclaration() {
                this.visitPart();
                if (this.lastClassDataDeclaration == null) {
                    return TAB;
                }
                try {
                    return ASTRewrite.getLeadingWhitespaceOnLine(this.document, this.lastClassDataDeclaration.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    return "";
                }
            }

            public int getOffsetForNewDataDeclaration() {
                this.visitPart();
                if (this.lastClassDataDeclaration == null) {
                    if (this.lastLeadingSettingsBlock == null) {
                        if (this.part.hasSubType()) {
                            return this.part.getSubType().getOffset() + this.part.getSubType().getLength();
                        }
                        return this.part.getName().getOffset() + this.part.getName().getLength();
                    }
                    return this.lastLeadingSettingsBlock.getOffset() + this.lastLeadingSettingsBlock.getLength();
                }
                return this.lastClassDataDeclaration.getOffset() + this.lastClassDataDeclaration.getLength();
            }

            public void visitPart(Part part) {
                Iterator iter = part.getContents().iterator();
                while (iter.hasNext()) {
                    ((Node)iter.next()).accept((IASTVisitor)new AbstractASTNodeVisitor(){

                        public boolean visitNode(Node node) {
                            OffsetFinder.this.readingLeadingSettingsBlocks = false;
                            return false;
                        }

                        public void endVisitNode(Node node) {
                        }

                        public boolean visit(ClassDataDeclaration classDataDeclaration) {
                            if (OffsetFinder.this.index == -1 || OffsetFinder.this.numFieldsVisited < OffsetFinder.this.index) {
                                OffsetFinder.this.lastClassDataDeclaration = classDataDeclaration;
                            }
                            return this.visitNode((Node)classDataDeclaration);
                        }

                        public void endVisit(ClassDataDeclaration classDataDeclaration) {
                            OffsetFinder offsetFinder = OffsetFinder.this;
                            offsetFinder.numFieldsVisited = offsetFinder.numFieldsVisited + 1;
                        }

                        public boolean visit(SettingsBlock settingsBlock) {
                            if (OffsetFinder.this.readingLeadingSettingsBlocks) {
                                OffsetFinder.this.lastLeadingSettingsBlock = settingsBlock;
                            }
                            return false;
                        }
                    });
                    this.visitedPart = true;
                }
            }
        }
    }

    private static class AddFunctionEdit
    extends DefaultASTEdit {
        private Part part;
        private String functionText;

        public AddFunctionEdit(Part part, String functionText) {
            this.part = part;
            this.functionText = functionText;
        }

        @Override
        public TextEdit toTextEdit(IDocument document) throws BadLocationException {
            String NL = ASTRewrite.getLineDelimiter(document);
            OffsetFinder offsetFinder = new OffsetFinder(document, this.part);
            StringBuffer insertText = new StringBuffer();
            String prefix = offsetFinder.getPrefixForNewFunctionDeclaration();
            insertText.append(NL);
            insertText.append(prefix);
            insertText.append(NL);
            insertText.append(prefix);
            insertText.append(this.functionText.replaceAll(NL, String.valueOf(NL) + prefix));
            return new InsertEdit(offsetFinder.getOffsetForNewDataDeclaration(), insertText.toString());
        }

        @Override
        public boolean isInsertEdit() {
            return true;
        }

        private static class OffsetFinder
        extends AbstractASTPartVisitor {
            private IDocument document;
            private Part part;
            private SettingsBlock lastLeadingSettingsBlock;
            private ClassDataDeclaration lastClassDataDeclaration;
            private NestedFunction lastNestedFunction;
            private boolean readingLeadingSettingsBlocks = true;
            private boolean visitedPart;

            OffsetFinder(IDocument document, Part part) {
                this.document = document;
                this.part = part;
            }

            private void visitPart() {
                if (!this.visitedPart) {
                    this.part.accept((IASTVisitor)this);
                }
            }

            public String getPrefixForNewFunctionDeclaration() {
                this.visitPart();
                if (this.lastNestedFunction == null) {
                    if (this.lastClassDataDeclaration == null) {
                        return TAB;
                    }
                    try {
                        return ASTRewrite.getLeadingWhitespaceOnLine(this.document, this.lastClassDataDeclaration.getOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        return "";
                    }
                }
                try {
                    return ASTRewrite.getLeadingWhitespaceOnLine(this.document, this.lastNestedFunction.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    return "";
                }
            }

            public int getOffsetForNewDataDeclaration() {
                this.visitPart();
                if (this.lastNestedFunction == null) {
                    if (this.lastClassDataDeclaration == null) {
                        if (this.lastLeadingSettingsBlock == null) {
                            if (this.part.hasSubType()) {
                                return this.part.getSubType().getOffset() + this.part.getSubType().getLength();
                            }
                            return this.part.getName().getOffset() + this.part.getName().getLength();
                        }
                        return this.lastLeadingSettingsBlock.getOffset() + this.lastLeadingSettingsBlock.getLength();
                    }
                    return this.lastClassDataDeclaration.getOffset() + this.lastClassDataDeclaration.getLength();
                }
                return this.lastNestedFunction.getOffset() + this.lastNestedFunction.getLength();
            }

            public void visitPart(Part part) {
                Iterator iter = part.getContents().iterator();
                while (iter.hasNext()) {
                    ((Node)iter.next()).accept((IASTVisitor)new AbstractASTNodeVisitor(){

                        public boolean visitNode(Node node) {
                            OffsetFinder.this.readingLeadingSettingsBlocks = false;
                            return false;
                        }

                        public void endVisitNode(Node node) {
                        }

                        public boolean visit(ClassDataDeclaration classDataDeclaration) {
                            OffsetFinder.this.lastClassDataDeclaration = classDataDeclaration;
                            return this.visitNode((Node)classDataDeclaration);
                        }

                        public boolean visit(NestedFunction nestedFunction) {
                            OffsetFinder.this.lastNestedFunction = nestedFunction;
                            return this.visitNode((Node)nestedFunction);
                        }

                        public boolean visit(SettingsBlock settingsBlock) {
                            if (OffsetFinder.this.readingLeadingSettingsBlocks) {
                                OffsetFinder.this.lastLeadingSettingsBlock = settingsBlock;
                            }
                            return false;
                        }
                    });
                    this.visitedPart = true;
                }
            }
        }
    }

    private class AddImportEdit
    extends DefaultASTEdit {
        private boolean isOnDemand;
        private String packageOrPartName;
        private File file;
        private boolean isFirstNewImport;
        private Comparator importComparator;

        public AddImportEdit(File file, String packageOrPartName, boolean isOnDemand, Comparator importComparator) {
            super(1);
            this.isFirstNewImport = true;
            this.file = file;
            this.packageOrPartName = packageOrPartName;
            this.isOnDemand = isOnDemand;
            List importDeclarations = file.getImportDeclarations();
            this.isFirstNewImport = (importDeclarations.isEmpty() || ASTRewrite.this.importsRemovedCount == importDeclarations.size()) && !ASTRewrite.this.importsAdded;
            this.importComparator = importComparator;
        }

        @Override
        public TextEdit toTextEdit(IDocument document) throws BadLocationException {
            String NL = ASTRewrite.getLineDelimiter(document);
            StringBuffer textToInsert = new StringBuffer();
            textToInsert.append("import");
            textToInsert.append(" ");
            textToInsert.append(this.packageOrPartName);
            if (this.isOnDemand) {
                if (this.packageOrPartName.length() > 0) {
                    textToInsert.append(".");
                }
                textToInsert.append("*");
            }
            textToInsert.append(";");
            String prefix = new String();
            String suffix = new String();
            List importDeclarationsInFile = this.file.getImportDeclarations();
            if (this.isFirstNewImport || importDeclarationsInFile.isEmpty() || ASTRewrite.this.importsRemovedCount == importDeclarationsInFile.size()) {
                if (this.file.hasPackageDeclaration()) {
                    prefix = this.isFirstNewImport ? String.valueOf(NL) + NL : NL;
                    return new InsertEdit(this.file.getPackageDeclaration().getOffset() + this.file.getPackageDeclaration().getLength(), String.valueOf(prefix) + textToInsert + suffix);
                }
                prefix = this.isFirstNewImport ? "" : NL;
                try {
                    if (ASTRewrite.this.lastAddImportEdit == this && document.getLineInformation(0).getLength() != 0 && importDeclarationsInFile.isEmpty()) {
                        suffix = String.valueOf(NL) + NL;
                    }
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
                return new InsertEdit(0, String.valueOf(prefix) + textToInsert + suffix);
            }
            ImportDeclaration importBeforeDecl = this.getInsertBeforeDecl(String.valueOf(this.packageOrPartName) + (this.isOnDemand ? ".*" : ""));
            if (importBeforeDecl == null) {
                prefix = NL;
                ImportDeclaration lastImportDecl = (ImportDeclaration)importDeclarationsInFile.get(importDeclarationsInFile.size() - 1);
                return new InsertEdit(lastImportDecl.getOffset() + lastImportDecl.getLength(), String.valueOf(prefix) + textToInsert + suffix);
            }
            prefix = "";
            suffix = NL;
            return new InsertEdit(importBeforeDecl.getOffset(), String.valueOf(prefix) + textToInsert + suffix);
        }

        private ImportDeclaration getInsertBeforeDecl(String importText) {
            if (this.importComparator != null) {
                List importDeclarationsInFile = this.file.getImportDeclarations();
                for (ImportDeclaration next : importDeclarationsInFile) {
                    String nextName = String.valueOf(next.getName().getCanonicalName()) + (next.isOnDemand() ? ".*" : "");
                    if (this.importComparator.compare(nextName, importText) <= 0) continue;
                    return next;
                }
            }
            return null;
        }

        @Override
        public boolean isInsertEdit() {
            return true;
        }
    }

    private static class AddPackageEdit
    extends DefaultASTEdit {
        private String packageName;

        public AddPackageEdit(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public TextEdit toTextEdit(IDocument document) throws BadLocationException {
            String NL = ASTRewrite.getLineDelimiter(document);
            StringBuffer textToInsert = new StringBuffer();
            textToInsert.append("package");
            textToInsert.append(" ");
            textToInsert.append(this.packageName);
            textToInsert.append(";");
            return new InsertEdit(0, String.valueOf(textToInsert.toString()) + NL + NL);
        }

        @Override
        public boolean isInsertEdit() {
            return true;
        }
    }

    private class AddPartEdit
    extends DefaultASTEdit {
        private File file;
        private Object partText;
        private boolean addTrailingSpace;
        private boolean addLeadingSpace;

        public AddPartEdit(File file, String partText) {
            this.file = file;
            this.partText = partText;
        }

        @Override
        public TextEdit toTextEdit(IDocument document) throws BadLocationException {
            String trailingSpace;
            String NL = ASTRewrite.getLineDelimiter(document);
            List partDeclarationsInFile = this.file.getParts();
            String string = trailingSpace = this.addTrailingSpace ? String.valueOf(NL) + NL : new String();
            String leadingSpace = this.addLeadingSpace ? (this.file.getImportDeclarations().isEmpty() && ASTRewrite.this.importsAdded ? String.valueOf(NL) + NL : NL) : new String();
            if (partDeclarationsInFile == Collections.EMPTY_LIST) {
                List importDeclarationsInFile = this.file.getImportDeclarations();
                if (importDeclarationsInFile == Collections.EMPTY_LIST) {
                    if (this.file.hasPackageDeclaration()) {
                        return new InsertEdit(this.file.getPackageDeclaration().getOffset() + this.file.getPackageDeclaration().getLength(), String.valueOf(NL) + NL + this.partText);
                    }
                    return new InsertEdit(0, String.valueOf(leadingSpace) + this.partText.toString() + trailingSpace);
                }
                ImportDeclaration lastImportDecl = (ImportDeclaration)importDeclarationsInFile.get(importDeclarationsInFile.size() - 1);
                return new InsertEdit(lastImportDecl.getOffset() + lastImportDecl.getLength(), String.valueOf(NL) + NL + this.partText);
            }
            Part lastPart = (Part)partDeclarationsInFile.get(partDeclarationsInFile.size() - 1);
            return new InsertEdit(lastPart.getOffset() + lastPart.getLength(), String.valueOf(NL) + NL + this.partText);
        }

        @Override
        public boolean isInsertEdit() {
            return true;
        }

        @Override
        public void editAdded(ASTEdit newEdit) {
            if (newEdit.isInsertEdit() && newEdit.compareTo(this) >= 0) {
                this.addTrailingSpace = true;
            } else {
                this.addLeadingSpace = true;
            }
        }
    }

    private static class AddSimpleSettingsEdit
    extends DefaultASTEdit {
        private SettingsBlockContainer blockContainer;
        private String[] settingNames;
        private String[] settingValues;

        public AddSimpleSettingsEdit(SettingsBlockContainer blockContainer, String[] settingNames, String[] settingValues) {
            this.blockContainer = blockContainer;
            this.settingNames = settingNames;
            this.settingValues = settingValues;
        }

        @Override
        public TextEdit toTextEdit(IDocument document) throws BadLocationException {
            int insertPosition;
            String dataDeclPrefix;
            String NL = ASTRewrite.getLineDelimiter(document);
            StringBuffer textToInsert = new StringBuffer();
            try {
                dataDeclPrefix = ASTRewrite.getLeadingWhitespaceOnLine(document, this.blockContainer.getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                dataDeclPrefix = "";
            }
            if (this.blockContainer.hasSettingsBlock()) {
                SettingsBlock settingsBlock = this.blockContainer.getSettingsBlock();
                if (settingsBlock.getSettings().isEmpty()) {
                    insertPosition = settingsBlock.getOffset() + 1;
                    textToInsert.append(NL);
                    textToInsert.append(this.getSettingsText(String.valueOf(dataDeclPrefix) + TAB, NL));
                    textToInsert.append(NL);
                    textToInsert.append(dataDeclPrefix);
                } else {
                    Node lastSetting = (Node)settingsBlock.getSettings().get(settingsBlock.getSettings().size() - 1);
                    try {
                        dataDeclPrefix = ASTRewrite.getLeadingWhitespaceOnLine(document, lastSetting.getOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        dataDeclPrefix = "";
                    }
                    int lineOfSettingsBlock = document.getLineOfOffset(settingsBlock.getOffset());
                    int lineOfLastSetting = document.getLineOfOffset(lastSetting.getOffset());
                    if (lineOfSettingsBlock == lineOfLastSetting) {
                        dataDeclPrefix = String.valueOf(dataDeclPrefix) + TAB;
                    }
                    insertPosition = lastSetting.getOffset() + lastSetting.getLength();
                    textToInsert.append(",");
                    textToInsert.append(NL);
                    textToInsert.append(this.getSettingsText(dataDeclPrefix, NL));
                }
            } else {
                insertPosition = this.blockContainer.getOffsetToInsertNewSettingsBlock();
                textToInsert.append(" {");
                textToInsert.append(NL);
                textToInsert.append(this.getSettingsText(String.valueOf(dataDeclPrefix) + TAB, NL));
                textToInsert.append(NL);
                textToInsert.append(dataDeclPrefix);
                textToInsert.append("}");
            }
            return new InsertEdit(insertPosition, textToInsert.toString());
        }

        private String getSettingsText(String prefix, String NL) {
            StringBuffer settingsText = new StringBuffer();
            int i = 0;
            while (i < this.settingNames.length) {
                settingsText.append(prefix);
                settingsText.append(this.settingNames[i]);
                settingsText.append(" = ");
                settingsText.append(this.settingValues[i]);
                if (i != this.settingNames.length - 1) {
                    settingsText.append(",");
                    settingsText.append(NL);
                }
                ++i;
            }
            return settingsText.toString();
        }

        @Override
        public boolean isInsertEdit() {
            return true;
        }
    }

    private static class ClassDataDeclarationSettingsBlockContainer
    implements SettingsBlockContainer {
        private ClassDataDeclaration classDataDecl;

        public ClassDataDeclarationSettingsBlockContainer(ClassDataDeclaration classDataDecl) {
            this.classDataDecl = classDataDecl;
        }

        @Override
        public int getStartOffset() {
            return this.classDataDecl.getOffset();
        }

        @Override
        public boolean hasSettingsBlock() {
            return this.classDataDecl.hasSettingsBlock();
        }

        @Override
        public SettingsBlock getSettingsBlock() {
            return this.classDataDecl.getSettingsBlockOpt();
        }

        @Override
        public int getOffsetToInsertNewSettingsBlock() {
            return this.classDataDecl.getType().getOffset() + this.classDataDecl.getType().getLength();
        }

        @Override
        public boolean isSettingsBlockRemovable() {
            return false;
        }
    }

    private static class ComplementStatementClauseEdit
    extends DefaultASTEdit {
        Statement statement;
        String clauseContent;

        public ComplementStatementClauseEdit(Statement statement, String clauseContent) {
            this.statement = statement;
            this.clauseContent = clauseContent;
        }

        @Override
        public TextEdit toTextEdit(IDocument document) throws BadLocationException {
            int offset = -1;
            if (this.statement.getIOClauses().isEmpty()) {
                NoClauseOrIOTargetOffsetFinder offsetFinder = new NoClauseOrIOTargetOffsetFinder();
                this.statement.accept((IASTVisitor)offsetFinder);
                offset = offsetFinder.offset;
                if (offset == -1 && !this.statement.getIOObjects().isEmpty()) {
                    Node lastTarget = (Node)this.statement.getIOObjects().get(this.statement.getIOObjects().size() - 1);
                    offset = lastTarget.getOffset() + lastTarget.getLength();
                }
                if (offset == -1) {
                    throw new RuntimeException("Can't locate offset to insert clause for " + this.statement.getClass().getName());
                }
            } else {
                Node lastClause = (Node)this.statement.getIOClauses().get(this.statement.getIOClauses().size() - 1);
                offset = lastClause.getOffset() + lastClause.getLength();
            }
            if (-1 != offset) {
                InsertEdit result = new InsertEdit(offset, this.clauseContent);
                return result;
            }
            return null;
        }

        @Override
        public boolean isInsertEdit() {
            return true;
        }

        private static class NoClauseOrIOTargetOffsetFinder
        extends DefaultASTVisitor {
            int offset = -1;
            int optionSize = -1;

            private NoClauseOrIOTargetOffsetFinder() {
            }

            public boolean visit(ExecuteStatement executeStatement) {
                this.offset = executeStatement.getOffset() + "execute".length();
                return false;
            }

            public boolean visit(DeleteStatement deleteStatement) {
                Node usingClause;
                if (deleteStatement.getOptions() != null && deleteStatement.getOptions().size() > 0 && (usingClause = (Node)deleteStatement.getOptions().get(0)) != null && usingClause instanceof UsingClause) {
                    this.offset = usingClause.getOffset() + usingClause.getLength();
                }
                if (this.offset == -1) {
                    FromOrToExpressionClause dataSourceExpression = deleteStatement.getDataSource();
                    this.offset = dataSourceExpression.getOffset() + dataSourceExpression.getLength();
                }
                return false;
            }

            public boolean visit(GetByKeyStatement getByKeyStatement) {
                this.optionSize = getByKeyStatement.getGetByKeyOptions().size();
                if (this.optionSize > 0) {
                    Node lastClause = (Node)getByKeyStatement.getGetByKeyOptions().get(this.optionSize - 1);
                    this.offset = lastClause.getOffset() + lastClause.getLength();
                }
                return false;
            }

            public boolean visit(ReplaceStatement replaceStatement) {
                this.optionSize = replaceStatement.getReplaceOptions().size();
                if (this.optionSize > 0) {
                    Node lastClause = (Node)replaceStatement.getReplaceOptions().get(this.optionSize - 1);
                    this.offset = lastClause.getOffset() + lastClause.getLength();
                }
                return false;
            }
        }
    }

    private static abstract class DefaultASTEdit
    implements ASTEdit {
        private int sortOrder;

        protected DefaultASTEdit(int sortOrder) {
            this.sortOrder = sortOrder;
        }

        protected DefaultASTEdit() {
            this(0);
        }

        public int compareTo(Object o) {
            return ((DefaultASTEdit)o).sortOrder - this.sortOrder;
        }

        @Override
        public void editAdded(ASTEdit newEdit) {
        }
    }

    private static class FunctionDataDeclarationSettingsBlockContainer
    implements SettingsBlockContainer {
        private FunctionDataDeclaration functionDataDecl;

        public FunctionDataDeclarationSettingsBlockContainer(FunctionDataDeclaration functionDataDecl) {
            this.functionDataDecl = functionDataDecl;
        }

        @Override
        public int getStartOffset() {
            return this.functionDataDecl.getOffset();
        }

        @Override
        public boolean hasSettingsBlock() {
            return this.functionDataDecl.hasSettingsBlock();
        }

        @Override
        public SettingsBlock getSettingsBlock() {
            return this.functionDataDecl.getSettingsBlockOpt();
        }

        @Override
        public int getOffsetToInsertNewSettingsBlock() {
            return this.functionDataDecl.getType().getOffset() + this.functionDataDecl.getType().getLength();
        }

        @Override
        public boolean isSettingsBlockRemovable() {
            return false;
        }
    }

    private static class InsertStatementClauseEdit
    extends DefaultASTEdit {
        Statement statement;
        IOStatementClauseInfo clauseInfo;
        Object clauseContent;

        InsertStatementClauseEdit(Statement statement, IOStatementClauseInfo clauseInfo, Object clauseContent) {
            this.statement = statement;
            this.clauseInfo = clauseInfo;
            this.clauseContent = clauseContent;
        }

        @Override
        public TextEdit toTextEdit(IDocument document) throws BadLocationException {
            String NL = ASTRewrite.getLineDelimiter(document);
            try {
                StringBuffer sb = new StringBuffer();
                int offset = -1;
                if (this.statement.getIOClauses().isEmpty()) {
                    if (this.statement.getIOObjects().isEmpty()) {
                        NoClauseOrIOTargetOffsetFinder offsetFinder = new NoClauseOrIOTargetOffsetFinder();
                        this.statement.accept((IASTVisitor)offsetFinder);
                        offset = offsetFinder.offset;
                        if (offset == -1) {
                            throw new RuntimeException("Can't locate offset to insert clause for " + this.statement.getClass().getName());
                        }
                    } else {
                        Node lastTarget = (Node)this.statement.getIOObjects().get(this.statement.getIOObjects().size() - 1);
                        offset = lastTarget.getOffset() + lastTarget.getLength();
                    }
                } else {
                    Node lastClause = (Node)this.statement.getIOClauses().get(this.statement.getIOClauses().size() - 1);
                    offset = lastClause.getOffset() + lastClause.getLength();
                }
                String prefix = ASTRewrite.getLeadingWhitespaceOnLine(document, this.statement.getOffset());
                if (1 == this.clauseInfo.getContentType()) {
                    sb.append(" ");
                    sb.append(this.clauseInfo.getClauseKeyword());
                    sb.append(NL);
                    sb.append(prefix);
                    sb.append(TAB);
                } else {
                    sb.append(NL);
                    sb.append(prefix);
                    sb.append(TAB);
                    sb.append(this.clauseInfo.getClauseKeyword());
                    sb.append(" ");
                }
                if (this.clauseInfo.getContentPrefix() != null) {
                    sb.append(this.clauseInfo.getContentPrefix());
                    sb.append(NL);
                    switch (this.clauseInfo.getContentType()) {
                        case 1: {
                            ASTRewrite.appendLines(sb, String.valueOf(prefix) + TAB + TAB, (String)this.clauseContent, NL);
                        }
                    }
                    sb.append(NL);
                    sb.append(prefix);
                    sb.append(TAB);
                    sb.append(this.clauseInfo.getContentSuffix());
                } else if (3 != this.clauseInfo.getContentType()) {
                    switch (this.clauseInfo.getContentType()) {
                        case 1: 
                        case 2: {
                            sb.append((String)this.clauseContent);
                            break;
                        }
                        case 0: {
                            Iterator iter = ((List)this.clauseContent).iterator();
                            while (iter.hasNext()) {
                                sb.append((String)iter.next());
                                if (!iter.hasNext()) continue;
                                sb.append(", ");
                            }
                            break;
                        }
                    }
                }
                InsertEdit result = new InsertEdit(offset, sb.toString());
                return result;
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isInsertEdit() {
            return true;
        }

        private static class NoClauseOrIOTargetOffsetFinder
        extends DefaultASTVisitor {
            int offset = -1;

            private NoClauseOrIOTargetOffsetFinder() {
            }

            public boolean visit(ExecuteStatement executeStatement) {
                this.offset = executeStatement.getOffset() + "execute".length();
                return false;
            }
        }
    }

    private static class NewExpressionSettingsBlockContainer
    implements SettingsBlockContainer {
        private NewExpression newExpr;

        public NewExpressionSettingsBlockContainer(NewExpression newExpr) {
            this.newExpr = newExpr;
        }

        @Override
        public int getStartOffset() {
            return this.newExpr.getOffset();
        }

        @Override
        public boolean hasSettingsBlock() {
            return this.newExpr.hasSettingsBlock();
        }

        @Override
        public SettingsBlock getSettingsBlock() {
            return this.newExpr.getSettingsBlock();
        }

        @Override
        public int getOffsetToInsertNewSettingsBlock() {
            return this.newExpr.getOffset() + this.newExpr.getLength();
        }

        @Override
        public boolean isSettingsBlockRemovable() {
            return true;
        }
    }

    private static class RemoveNodeEdit
    extends DefaultASTEdit {
        Node nodeToRemove;

        RemoveNodeEdit(Node nodeToRemove) {
            this.nodeToRemove = nodeToRemove;
        }

        @Override
        public TextEdit toTextEdit(IDocument document) {
            try {
                int leadingWhitespace = ASTRewrite.precedingWhitespaceCharacters(document, this.nodeToRemove).length();
                int lastNonWhitespacePos = this.nodeToRemove.getOffset() - leadingWhitespace;
                return new DeleteEdit(lastNonWhitespacePos, this.nodeToRemove.getLength() + leadingWhitespace);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isInsertEdit() {
            return false;
        }
    }

    private static class RemoveSettingsEdit
    extends DefaultASTEdit {
        private SettingsBlockContainer blockContainer;
        private Node[] settings;

        public RemoveSettingsEdit(SettingsBlockContainer blockContainer, Node[] settings) {
            this.blockContainer = blockContainer;
            this.settings = settings;
        }

        @Override
        public TextEdit toTextEdit(IDocument document) {
            MultiTextEdit rootEdit = new MultiTextEdit();
            if (this.blockContainer.hasSettingsBlock() && !this.blockContainer.getSettingsBlock().getSettings().isEmpty()) {
                Node firstSetting = (Node)this.blockContainer.getSettingsBlock().getSettings().get(0);
                if (this.settings.length == this.blockContainer.getSettingsBlock().getSettings().size()) {
                    if (this.blockContainer.isSettingsBlockRemovable()) {
                        return new RemoveNodeEdit((Node)this.blockContainer.getSettingsBlock()).toTextEdit(document);
                    }
                    SettingsBlock settingsBlock = this.blockContainer.getSettingsBlock();
                    rootEdit.addChild((TextEdit)new DeleteEdit(settingsBlock.getOffset() + 1, settingsBlock.getLength() - 2));
                } else {
                    int i = 0;
                    while (i < this.settings.length) {
                        if (this.settings[i] == firstSetting) {
                            int endDelete = ((Node)this.blockContainer.getSettingsBlock().getSettings().get(1)).getOffset();
                            rootEdit.addChild((TextEdit)new DeleteEdit(this.settings[i].getOffset(), endDelete - this.settings[i].getOffset()));
                        } else {
                            try {
                                int startDelete = ASTRewrite.offsetOfClosestCharToLeft(document, ',', this.settings[i].getOffset());
                                rootEdit.addChild((TextEdit)new DeleteEdit(startDelete, this.settings[i].getLength() + this.settings[i].getOffset() - startDelete));
                            }
                            catch (BadLocationException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        ++i;
                    }
                }
            }
            return rootEdit;
        }

        @Override
        public boolean isInsertEdit() {
            return false;
        }
    }

    private static class RemoveTextEdit
    extends DefaultASTEdit {
        private int offset;
        private int length;

        RemoveTextEdit(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        @Override
        public TextEdit toTextEdit(IDocument document) {
            return new DeleteEdit(this.offset, this.length);
        }

        @Override
        public boolean isInsertEdit() {
            return false;
        }
    }

    private static class SetTextEdit
    extends DefaultASTEdit {
        Node node;
        String newText;

        SetTextEdit(Node node, String newText) {
            this.node = node;
            this.newText = newText;
        }

        @Override
        public TextEdit toTextEdit(IDocument document) {
            return new ReplaceEdit(this.node.getOffset(), this.node.getLength(), this.newText);
        }

        @Override
        public boolean isInsertEdit() {
            return false;
        }
    }

    private static class SetValuesExpressionSettingsBlockContainer
    implements SettingsBlockContainer {
        private SetValuesExpression setValuesExpr;

        public SetValuesExpressionSettingsBlockContainer(SetValuesExpression setValuesExpr) {
            this.setValuesExpr = setValuesExpr;
        }

        @Override
        public int getStartOffset() {
            return this.setValuesExpr.getOffset();
        }

        @Override
        public boolean hasSettingsBlock() {
            return true;
        }

        @Override
        public SettingsBlock getSettingsBlock() {
            return this.setValuesExpr.getSettingsBlock();
        }

        @Override
        public int getOffsetToInsertNewSettingsBlock() {
            return this.setValuesExpr.getOffset() + this.setValuesExpr.getLength();
        }

        @Override
        public boolean isSettingsBlockRemovable() {
            return false;
        }
    }

    private static interface SettingsBlockContainer {
        public int getStartOffset();

        public boolean hasSettingsBlock();

        public boolean isSettingsBlockRemovable();

        public SettingsBlock getSettingsBlock();

        public int getOffsetToInsertNewSettingsBlock();
    }
}

