/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.model.document.EGLNodeNameUtility;

public class TerminalNode
extends ParseNode {
    public int terminalType;
    public String text;
    public int line;
    public int column;
    public int offset;

    public TerminalNode(int terminalType, String text) {
        this.terminalType = terminalType;
        this.text = text;
    }

    public TerminalNode(int terminalType, String text, int line, int column) {
        this.terminalType = terminalType;
        this.text = text;
        this.line = line;
        this.column = column;
    }

    public TerminalNode(int terminalType, String text, int line, int column, int offset) {
        this.terminalType = terminalType;
        this.text = text;
        this.line = line;
        this.column = column;
        this.offset = offset;
    }

    @Override
    public boolean isNonTerminal() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    public String toString() {
        String terminalName = EGLNodeNameUtility.getTerminalName(this.terminalType);
        if (terminalName.equalsIgnoreCase(this.text)) {
            return terminalName;
        }
        return String.valueOf(terminalName) + " " + this.text;
    }

    @Override
    public boolean isWhiteSpace() {
        switch (this.terminalType) {
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public String getText() {
        return this.text;
    }
}

