/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.generation;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.sse.core.internal.encoding.ContentTypeEncodingPreferences;

public class CommandFile {
    private static final String EGLCOMMANDS_ELEMENT = "EGLCOMMANDS";
    private static final String DOCTYPE_PUBLID_ID = "-//IBM//DTD EGLCOMMANDS 5.1//EN";
    private static final String DOCTYPE_SYSTEM_ID = "\"\"";
    private static final String XML_VERSION = "version=\"1.0\"";
    private static final String XML_ROOT_TAG = "<EGLCOMMANDS>\n</EGLCOMMANDS>";
    private static final String XML_DOCTYPE = "<!DOCTYPE EGLCOMMANDS PUBLIC \"-//IBM//DTD EGLCOMMANDS 5.1//EN\" \"\">";

    public static String createEmptyCommandFile() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(CommandFile.createXMLProlog());
        buffer.append("\n\n");
        buffer.append(XML_DOCTYPE);
        buffer.append("\n\n");
        buffer.append(XML_ROOT_TAG);
        return buffer.toString();
    }

    private static String getXMLEncoding() {
        String enc = ContentTypeEncodingPreferences.getUserSpecifiedDefaultEncodingPreference();
        if (enc != null && enc.trim().length() > 0) {
            return enc.trim();
        }
        if ((enc == null || enc.trim().length() == 0) && (enc = CommandFile.getWorkbenchSpecifiedDefaultEncoding()) != null && enc.trim().length() > 0) {
            return enc.trim();
        }
        return "UTF-8";
    }

    private static final String getWorkbenchSpecifiedDefaultEncoding() {
        ResourcesPlugin resourcePlugin = ResourcesPlugin.getPlugin();
        String enc = resourcePlugin.getPluginPreferences().getString("encoding");
        if (enc != null && enc.trim().length() == 0) {
            enc = null;
        }
        return enc;
    }

    private static String createXMLProlog() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml ");
        buffer.append(XML_VERSION);
        buffer.append(" ");
        buffer.append("encoding=\"" + CommandFile.getXMLEncoding() + "\"");
        buffer.append("?>");
        return buffer.toString();
    }
}

