/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.io.IIOBufferReader;

public abstract class ZipFileIOBufferReader
implements IIOBufferReader {
    public abstract File getFile();

    public Object readEntry(String name) throws IOException {
        Object result = null;
        File cacheFile = this.getFile();
        if (cacheFile.exists()) {
            ZipFile zipFile = new ZipFile(cacheFile);
            try {
                ZipEntry entry = zipFile.getEntry(name);
                if (entry == null) {
                    zipFile.close();
                    return null;
                }
                ObjectInputStream zipStream = new ObjectInputStream(new BufferedInputStream(zipFile.getInputStream(entry)));
                try {
                    try {
                        result = zipStream.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        throw new BuildException("Class Not Found", (Throwable)e);
                    }
                }
                finally {
                    zipStream.close();
                }
            }
            finally {
                zipFile.close();
            }
        }
        return result;
    }

    public List getEntries() throws IOException {
        ArrayList<String> entries = new ArrayList<String>();
        File file = this.getFile();
        if (file.exists()) {
            ZipFile zipFile = new ZipFile(file);
            try {
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    entries.add(enumeration.nextElement().getName());
                }
            }
            finally {
                zipFile.close();
            }
        }
        return entries;
    }

    public InputStream getInputStream(String name) throws IOException {
        throw new UnsupportedOperationException();
    }
}

