/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.edt.ide.core.internal.model.Buffer;
import org.eclipse.edt.ide.core.internal.model.BufferCache;
import org.eclipse.edt.ide.core.internal.model.NullBuffer;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IOpenable;

public class BufferManager
implements IBufferFactory {
    protected static BufferManager DEFAULT_BUFFER_MANAGER;
    protected BufferCache openBuffers = new BufferCache(60);

    protected void addBuffer(IBuffer buffer) {
        this.openBuffers.put(buffer.getOwner(), buffer);
    }

    @Override
    public IBuffer createBuffer(IOpenable owner) {
        IEGLElement element = (IEGLElement)((Object)owner);
        IResource resource = element.getResource();
        return new Buffer(resource instanceof IFile ? (IFile)resource : null, owner, element.isReadOnly());
    }

    public IBuffer getBuffer(IOpenable owner) {
        return (IBuffer)this.openBuffers.get(owner);
    }

    public static synchronized BufferManager getDefaultBufferManager() {
        if (DEFAULT_BUFFER_MANAGER == null) {
            DEFAULT_BUFFER_MANAGER = new BufferManager();
        }
        return DEFAULT_BUFFER_MANAGER;
    }

    public IBufferFactory getDefaultBufferFactory() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getOpenBuffers() {
        BufferCache bufferCache = this.openBuffers;
        synchronized (bufferCache) {
            this.openBuffers.shrink();
            return this.openBuffers.elements();
        }
    }

    protected void removeBuffer(IBuffer buffer) {
        this.openBuffers.remove(buffer.getOwner());
    }

    public static IBuffer createNullBuffer(IOpenable owner) {
        IEGLElement element = (IEGLElement)((Object)owner);
        IResource resource = element.getResource();
        return new NullBuffer(resource instanceof IFile ? (IFile)resource : null, owner, element.isReadOnly());
    }
}

