/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.internal.model.EGLElementDelta;
import org.eclipse.edt.ide.core.internal.model.EGLModelOperation;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLConventions;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;

public class CreatePackageFragmentOperation
extends EGLModelOperation {
    protected String fName;

    public CreatePackageFragmentOperation(IPackageFragmentRoot parentElement, String packageName, boolean force) {
        super(null, new IEGLElement[]{parentElement}, force);
        this.fName = packageName;
    }

    @Override
    protected void executeOperation() throws EGLModelException {
        EGLElementDelta delta = null;
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getParentElement();
        String[] names = Util.getTrimmedSimpleNames(this.fName);
        this.beginTask(EGLModelResources.operationCreatePackageFragmentProgress, names.length);
        IContainer parentFolder = (IContainer)root.getResource();
        String sideEffectPackageName = "";
        ArrayList<IPackageFragment> resultElements = new ArrayList<IPackageFragment>(names.length);
        char[][] exclusionPatterns = ((PackageFragmentRoot)root).fullExclusionPatternChars();
        int i = 0;
        while (i < names.length) {
            String subFolderName = names[i];
            sideEffectPackageName = String.valueOf(sideEffectPackageName) + subFolderName;
            IResource subFolder = parentFolder.findMember(subFolderName);
            if (subFolder == null) {
                this.createFolder(parentFolder, subFolderName, this.fForce);
                parentFolder = parentFolder.getFolder((IPath)new Path(subFolderName));
                IPackageFragment addedFrag = root.getPackageFragment(sideEffectPackageName);
                if (!Util.isExcluded((IResource)parentFolder, exclusionPatterns)) {
                    if (delta == null) {
                        delta = this.newEGLElementDelta();
                    }
                    delta.added(addedFrag);
                }
                resultElements.add(addedFrag);
            } else {
                parentFolder = (IContainer)subFolder;
            }
            sideEffectPackageName = String.valueOf(sideEffectPackageName) + '.';
            this.worked(1);
            ++i;
        }
        if (resultElements.size() > 0) {
            this.fResultElements = new IEGLElement[resultElements.size()];
            resultElements.toArray(this.fResultElements);
            if (delta != null) {
                this.addDelta(delta);
            }
        }
        this.done();
    }

    @Override
    public IEGLModelStatus verify() {
        if (this.getParentElement() == null) {
            return new EGLModelStatus(968);
        }
        if (this.fName == null || this.fName.length() > 0 && EGLConventions.validatePackageName(this.fName).getSeverity() == 4) {
            return new EGLModelStatus(983, this.fName);
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getParentElement();
        if (root.isReadOnly()) {
            return new EGLModelStatus(976, root);
        }
        String[] names = Util.getTrimmedSimpleNames(this.fName);
        IContainer parentFolder = (IContainer)root.getResource();
        int i = 0;
        while (i < names.length) {
            IResource subFolder = parentFolder.findMember(names[i]);
            if (subFolder != null) {
                if (subFolder.getType() != 2) {
                    return new EGLModelStatus(977, EGLModelResources.bind((String)EGLModelResources.statusNameCollision, (Object)subFolder.getFullPath().toString()));
                }
                parentFolder = (IContainer)subFolder;
            }
            ++i;
        }
        return EGLModelStatus.VERIFIED_OK;
    }
}

