/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.Map;
import org.eclipse.edt.ide.core.internal.model.EGLElementDelta;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLModelOperation;
import org.eclipse.edt.ide.core.internal.model.WorkingCopy;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;

public class DestroyWorkingCopyOperation
extends EGLModelOperation {
    public DestroyWorkingCopyOperation(IEGLElement workingCopy) {
        super(new IEGLElement[]{workingCopy});
    }

    @Override
    protected void executeOperation() throws EGLModelException {
        WorkingCopy workingCopy = this.getWorkingCopy();
        workingCopy.close();
        IEGLElement originalElement = workingCopy.getOriginalElement();
        if (!workingCopy.getParent().exists()) {
            ((EGLFile)originalElement).close();
        }
        EGLModelManager manager = EGLModelManager.getEGLModelManager();
        Map sharedWorkingCopies = manager.sharedWorkingCopies;
        Map perFactoryWorkingCopies = (Map)sharedWorkingCopies.get(workingCopy.bufferFactory);
        if (perFactoryWorkingCopies != null && perFactoryWorkingCopies.remove(originalElement) != null && EGLFile.SHARED_WC_VERBOSE) {
            System.out.println("Destroying shared working copy " + workingCopy.toStringWithAncestors());
        }
        EGLElementDelta delta = new EGLElementDelta(this.getEGLModel());
        delta.removed(workingCopy);
        this.addDelta(delta);
        this.removeReconcileDelta(workingCopy);
    }

    protected WorkingCopy getWorkingCopy() {
        return (WorkingCopy)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

