/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.OpenableElementInfo;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.SourceMapper;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;

class PackageFragmentRootInfo
extends OpenableElementInfo {
    protected SourceMapper sourceMapper = null;
    protected int fRootKind = 1;
    protected Object[] fNonEGLResources = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object[] computeFolderNonEGLResources(EGLProject project, IContainer folder, char[][] exclusionPatterns) throws EGLModelException {
        Object[] nonEGLResources = new IResource[5];
        int nonEGLResourcesCounter = 0;
        try {
            IEGLPathEntry[] classpath = project.getResolvedEGLPath(true);
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (true) {
                block10: {
                    if (i >= max) {
                        if (nonEGLResources.length != nonEGLResourcesCounter) {
                            Object[] objectArray = nonEGLResources;
                            nonEGLResources = new IResource[nonEGLResourcesCounter];
                            System.arraycopy(objectArray, 0, nonEGLResources, 0, nonEGLResourcesCounter);
                        }
                        return nonEGLResources;
                    }
                    IResource member = members[i];
                    switch (member.getType()) {
                        case 1: {
                            String fileName = member.getName();
                            if ((!Util.isValidEGLFileName(fileName) || Util.isExcluded(member, exclusionPatterns)) && !Util.isValidClassFileName(fileName) && (!Util.isArchiveFileName(fileName) || !PackageFragmentRootInfo.isEGLPathEntry(member.getFullPath(), classpath))) break;
                            break block10;
                        }
                        case 2: {
                            if (Util.isValidFolderNameForPackage(member.getName()) && (!Util.isExcluded(member, exclusionPatterns) || PackageFragmentRootInfo.isEGLPathEntry(member.getFullPath(), classpath))) break block10;
                        }
                    }
                    if (nonEGLResources.length == nonEGLResourcesCounter) {
                        Object[] objectArray = nonEGLResources;
                        nonEGLResources = new IResource[nonEGLResourcesCounter * 2];
                        System.arraycopy(objectArray, 0, nonEGLResources, 0, nonEGLResourcesCounter);
                    }
                    nonEGLResources[nonEGLResourcesCounter++] = member;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
    }

    private Object[] computeNonEGLResources(IEGLProject project, IResource underlyingResource, PackageFragmentRoot handle) {
        Object[] nonEGLResources = NO_NON_EGL_RESOURCES;
        if (underlyingResource == null) {
            return nonEGLResources;
        }
        try {
            if (underlyingResource.getType() == 2 || underlyingResource.getType() == 4) {
                nonEGLResources = PackageFragmentRootInfo.computeFolderNonEGLResources((EGLProject)project, (IContainer)underlyingResource, handle.fullExclusionPatternChars());
            }
        }
        catch (EGLModelException eGLModelException) {}
        return nonEGLResources;
    }

    synchronized Object[] getNonEGLResources(IEGLProject project, IResource underlyingResource, PackageFragmentRoot handle) {
        Object[] nonEGLResources = this.fNonEGLResources;
        if (nonEGLResources == null) {
            nonEGLResources = this.computeNonEGLResources(project, underlyingResource, handle);
            this.fNonEGLResources = nonEGLResources;
        }
        return nonEGLResources;
    }

    public int getRootKind() {
        return this.fRootKind;
    }

    protected synchronized SourceMapper getSourceMapper() {
        return this.sourceMapper;
    }

    private static boolean isEGLPathEntry(IPath path, IEGLPathEntry[] resolvedEGLPath) {
        int i = 0;
        int length = resolvedEGLPath.length;
        while (i < length) {
            IEGLPathEntry entry = resolvedEGLPath[i];
            if (entry.getPath().equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    synchronized void setNonEGLResources(Object[] resources) {
        this.fNonEGLResources = resources;
    }

    protected void setRootKind(int newRootKind) {
        this.fRootKind = newRootKind;
    }

    protected synchronized void setSourceMapper(SourceMapper mapper) {
        this.sourceMapper = mapper;
    }
}

