/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.indexing;

import java.io.IOException;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.index.IDocument;
import org.eclipse.edt.ide.core.internal.model.index.IIndexer;
import org.eclipse.edt.ide.core.internal.model.index.IIndexerOutput;
import org.eclipse.edt.ide.core.model.IIndexConstants;

public abstract class AbstractIndexer
implements IIndexer,
IIndexConstants {
    IIndexerOutput output;

    public void addPartDeclaration(char partType, int modifiers, char[] packageName, char[] name, char[][] enclosingPartNames, char[][] interfaceNames) {
        this.output.addRef(AbstractIndexer.encodePartEntry(partType, packageName, enclosingPartNames, name, true));
        if (interfaceNames != null) {
            int i = 0;
            int max = interfaceNames.length;
            while (i < max) {
                this.addPartReference(interfaceNames[i]);
                ++i;
            }
        }
    }

    public void addFieldDeclaration(char[] typeName, char[] fieldName) {
        this.output.addRef(CharOperation.concat((char[])FIELD_DECL, (char[])fieldName));
        this.addPartReference(typeName);
    }

    public void addFieldReference(char[] fieldName) {
        this.output.addRef(CharOperation.concat((char[])FIELD_REF, (char[])fieldName));
    }

    public void addFunctionDeclaration(char[] functionName, char[][] parameterParts, char[] returnPart) {
        int numberOfArguments = 0;
        if (parameterParts != null) {
            numberOfArguments = parameterParts.length;
            int i = 0;
            while (i < numberOfArguments) {
                this.addPartReference(parameterParts[i]);
                ++i;
            }
        }
        char[] countChars = numberOfArguments < 10 ? COUNTS[numberOfArguments] : String.valueOf(numberOfArguments).toCharArray();
        this.output.addRef(AbstractIndexer.concat(FUNCTION_DECL, functionName, countChars, '/'));
        if (returnPart != null) {
            this.addPartReference(returnPart);
        }
    }

    public void addFunctionReference(char[] functionName, int argCount) {
        char[] countChars = argCount < 10 ? COUNTS[argCount] : String.valueOf(argCount).toCharArray();
        this.output.addRef(AbstractIndexer.concat(FUNCTION_REF, functionName, countChars, '/'));
    }

    public void addNameReference(char[] name) {
        this.output.addRef(CharOperation.concat((char[])REF, (char[])name));
    }

    public void addPartReference(char[] typeName) {
        this.output.addRef(CharOperation.concat((char[])PART_REF, (char[])CharOperation.lastSegment((char[])typeName, (char)'.')));
    }

    public static final char[] bestFieldDeclarationPrefix(char[] name, int matchMode, boolean isCaseSensitive) {
        if (!isCaseSensitive || name == null) {
            return FIELD_DECL;
        }
        switch (matchMode) {
            case 0: 
            case 1: {
                return CharOperation.concat((char[])FIELD_DECL, (char[])name);
            }
            case 2: {
                int starPos = CharOperation.indexOf((char)'*', (char[])name);
                switch (starPos) {
                    case -1: {
                        return CharOperation.concat((char[])FIELD_DECL, (char[])name);
                    }
                    default: {
                        int refLength = FIELD_DECL.length;
                        char[] result = new char[refLength + starPos];
                        System.arraycopy(FIELD_DECL, 0, result, 0, refLength);
                        System.arraycopy(name, 0, result, refLength, starPos);
                        return result;
                    }
                    case 0: 
                }
            }
        }
        return FIELD_DECL;
    }

    public static final char[] bestFunctionDeclarationPrefix(char[] selector, int arity, int matchMode, boolean isCaseSensitive) {
        if (!isCaseSensitive || selector == null) {
            return FUNCTION_DECL;
        }
        switch (matchMode) {
            case 0: {
                if (arity >= 0) {
                    char[] countChars = arity < 10 ? COUNTS[arity] : String.valueOf(arity).toCharArray();
                    return AbstractIndexer.concat(FUNCTION_DECL, selector, countChars, '/');
                }
            }
            case 1: {
                return CharOperation.concat((char[])FUNCTION_DECL, (char[])selector);
            }
            case 2: {
                int starPos = CharOperation.indexOf((char)'*', (char[])selector);
                switch (starPos) {
                    case -1: {
                        return CharOperation.concat((char[])FUNCTION_DECL, (char[])selector);
                    }
                    default: {
                        int refLength = FUNCTION_DECL.length;
                        char[] result = new char[refLength + starPos];
                        System.arraycopy(FUNCTION_DECL, 0, result, 0, refLength);
                        System.arraycopy(selector, 0, result, refLength, starPos);
                        return result;
                    }
                    case 0: 
                }
            }
        }
        return FUNCTION_DECL;
    }

    public static final char[] bestMethodReferencePrefix(char[] selector, int arity, int matchMode, boolean isCaseSensitive) {
        if (!isCaseSensitive || selector == null) {
            return FUNCTION_REF;
        }
        switch (matchMode) {
            case 0: {
                if (arity >= 0) {
                    char[] countChars = arity < 10 ? COUNTS[arity] : String.valueOf(arity).toCharArray();
                    return AbstractIndexer.concat(FUNCTION_REF, selector, countChars, '/');
                }
            }
            case 1: {
                return CharOperation.concat((char[])FUNCTION_REF, (char[])selector);
            }
            case 2: {
                int starPos = CharOperation.indexOf((char)'*', (char[])selector);
                switch (starPos) {
                    case -1: {
                        return CharOperation.concat((char[])FUNCTION_REF, (char[])selector);
                    }
                    default: {
                        int refLength = FUNCTION_REF.length;
                        char[] result = new char[refLength + starPos];
                        System.arraycopy(FUNCTION_REF, 0, result, 0, refLength);
                        System.arraycopy(selector, 0, result, refLength, starPos);
                        return result;
                    }
                    case 0: 
                }
            }
        }
        return FUNCTION_REF;
    }

    public static final char[] bestReferencePrefix(char[] tag, char[] name, int matchMode, boolean isCaseSensitive) {
        if (!isCaseSensitive || name == null) {
            return tag;
        }
        switch (matchMode) {
            case 0: 
            case 1: {
                return CharOperation.concat((char[])tag, (char[])name);
            }
            case 2: {
                int starPos = CharOperation.indexOf((char)'*', (char[])name);
                switch (starPos) {
                    case -1: {
                        return CharOperation.concat((char[])tag, (char[])name);
                    }
                    default: {
                        int refLength = tag.length;
                        char[] result = new char[refLength + starPos];
                        System.arraycopy(tag, 0, result, 0, refLength);
                        System.arraycopy(name, 0, result, refLength, starPos);
                        return result;
                    }
                    case 0: 
                }
            }
        }
        return tag;
    }

    public static final char[] bestPartDeclarationPrefix(char[] packageName, char[] typeName, char partType, int matchMode, boolean isCaseSensitive) {
        if (!isCaseSensitive) {
            packageName = null;
            typeName = null;
        }
        if (partType != '\u0000') {
            return PART_DECL;
        }
        block0 : switch (matchMode) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (typeName == null) break;
                int starPos = CharOperation.indexOf((char)'*', (char[])typeName);
                switch (starPos) {
                    case -1: {
                        break block0;
                    }
                    case 0: {
                        typeName = null;
                        break block0;
                    }
                }
                typeName = CharOperation.subarray((char[])typeName, (int)0, (int)starPos);
            }
        }
        int packageLength = packageName.length;
        int typeLength = typeName == null ? 0 : typeName.length;
        char[] result = new char[9 + packageLength + typeLength + 3];
        int pos = 9;
        System.arraycopy(PART_DECL, 0, result, 0, 9);
        result[pos++] = partType;
        result[pos++] = 47;
        System.arraycopy(packageName, 0, result, pos, packageLength);
        pos += packageLength;
        result[pos++] = 47;
        if (typeLength > 0) {
            System.arraycopy(typeName, 0, result, pos, typeName.length);
        }
        return result;
    }

    protected static final char[] concat(char[] firstWithSeparator, char[] second, char[] third, char[] fourth, char[] fifth, char separator) {
        int length1 = firstWithSeparator.length;
        int length2 = second == null ? 0 : second.length;
        int length3 = third == null ? 0 : third.length;
        int length4 = fourth == null ? 0 : fourth.length;
        int length5 = fifth == null ? 0 : fifth.length;
        char[] result = new char[length1 + length2 + length3 + length4 + length5 + 3];
        System.arraycopy(firstWithSeparator, 0, result, 0, length1);
        if (second != null) {
            System.arraycopy(second, 0, result, length1, length2);
        }
        int pos = length1 + length2;
        result[pos] = separator;
        if (third != null) {
            System.arraycopy(third, 0, result, pos + 1, length3);
        }
        result[pos += length3 + 1] = separator;
        if (fourth != null) {
            System.arraycopy(fourth, 0, result, pos + 1, length4);
        }
        result[pos += length4 + 1] = separator;
        if (fifth != null) {
            System.arraycopy(fifth, 0, result, pos + 1, length5);
        }
        return result;
    }

    protected static final char[] concat(char[] firstWithSeparator, char[] second, char[] third, char separator) {
        int length1 = firstWithSeparator.length;
        int length2 = second == null ? 0 : second.length;
        int length3 = third == null ? 0 : third.length;
        char[] result = new char[length1 + length2 + length3 + 1];
        System.arraycopy(firstWithSeparator, 0, result, 0, length1);
        if (second != null) {
            System.arraycopy(second, 0, result, length1, length2);
        }
        result[length1 + length2] = separator;
        if (third != null) {
            System.arraycopy(third, 0, result, length1 + length2 + 1, length3);
        }
        return result;
    }

    protected static final char[] concat(char[] firstWithSeparator, char[] second, char[] third, char charAfterThird, char[] fourth, char[] fifth, char[] sixth, char charAfterSixth, char last, char separator) {
        int length1 = firstWithSeparator.length;
        int length2 = second == null ? 0 : second.length;
        int length3 = third == null ? 0 : third.length;
        int length4 = fourth == null ? 0 : fourth.length;
        int length5 = fifth == null ? 0 : fifth.length;
        int length6 = sixth == null ? 0 : sixth.length;
        char[] result = new char[length1 + length2 + length3 + length4 + length5 + length6 + 9];
        System.arraycopy(firstWithSeparator, 0, result, 0, length1);
        if (second != null) {
            System.arraycopy(second, 0, result, length1, length2);
        }
        int pos = length1 + length2;
        result[pos] = separator;
        if (third != null) {
            System.arraycopy(third, 0, result, pos + 1, length3);
        }
        result[pos += length3 + 1] = separator;
        result[++pos] = charAfterThird;
        result[++pos] = separator;
        if (fourth != null) {
            System.arraycopy(fourth, 0, result, pos + 1, length4);
        }
        result[pos += length4 + 1] = separator;
        if (fifth != null) {
            System.arraycopy(fifth, 0, result, pos + 1, length5);
        }
        result[pos += length5 + 1] = separator;
        if (sixth != null) {
            System.arraycopy(sixth, 0, result, pos + 1, length6);
        }
        result[pos += length6 + 1] = separator;
        result[++pos] = charAfterSixth;
        result[++pos] = last;
        return result;
    }

    protected static final char[] encodePartEntry(char partType, char[] packageName, char[][] enclosingPartNames, char[] typeName, boolean isClass) {
        int packageLength = packageName == null ? 0 : packageName.length;
        int enclosingPartNamesLength = 0;
        if (enclosingPartNames != null) {
            int i = 0;
            int length = enclosingPartNames.length;
            while (i < length) {
                enclosingPartNamesLength += enclosingPartNames[i].length + 1;
                ++i;
            }
        }
        char[] result = new char[9 + packageLength + typeName.length + enclosingPartNamesLength + 4];
        int pos = 9;
        System.arraycopy(PART_DECL, 0, result, 0, 9);
        result[pos++] = partType;
        result[pos++] = 47;
        if (packageName != null) {
            System.arraycopy(packageName, 0, result, pos, packageLength);
            pos += packageLength;
        }
        result[pos++] = 47;
        System.arraycopy(typeName, 0, result, pos, typeName.length);
        pos += typeName.length;
        result[pos++] = 47;
        if (enclosingPartNames != null) {
            int i = 0;
            int length = enclosingPartNames.length;
            while (i < length) {
                int enclosingPartNameLength = enclosingPartNames[i].length;
                System.arraycopy(enclosingPartNames[i], 0, result, pos, enclosingPartNameLength);
                pos += enclosingPartNameLength;
                result[pos++] = 47;
                ++i;
            }
        }
        return result;
    }

    @Override
    public abstract String[] getFileTypes();

    @Override
    public void index(IDocument document, IIndexerOutput output) throws IOException {
        this.output = output;
        if (this.shouldIndex(document)) {
            this.indexFile(document);
        }
    }

    protected abstract void indexFile(IDocument var1) throws IOException;

    @Override
    public boolean shouldIndex(IDocument document) {
        String type = document.getType();
        String[] supportedParts = this.getFileTypes();
        int i = 0;
        while (i < supportedParts.length) {
            if (supportedParts[i].equalsIgnoreCase(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

