/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.indexing;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.index.IIndex;
import org.eclipse.edt.ide.core.internal.model.index.IQueryResult;
import org.eclipse.edt.ide.core.internal.model.indexing.EGLReadWriteMonitor;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexManager;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexRequest;
import org.eclipse.edt.ide.core.internal.model.search.processing.JobManager;

class RemoveFolderFromIndex
extends IndexRequest {
    IPath folderPath;
    char[][] exclusionPatterns;
    IProject project;

    public RemoveFolderFromIndex(IPath folderPath, char[][] exclusionPatterns, IProject project, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.folderPath = folderPath;
        this.exclusionPatterns = exclusionPatterns;
        this.project = project;
    }

    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        IIndex index = this.manager.getIndex(this.indexPath, true, false);
        if (index == null) {
            return true;
        }
        EGLReadWriteMonitor monitor = this.manager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                IQueryResult[] results = index.queryInDocumentNames(this.folderPath.toString());
                int i = 0;
                int max = results == null ? 0 : results.length;
                while (i < max) {
                    String documentPath = results[i].getPath();
                    if (this.exclusionPatterns == null || !Util.isExcluded((IPath)new Path(documentPath), this.exclusionPatterns)) {
                        this.manager.remove(documentPath, this.indexPath);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                if (JobManager.VERBOSE) {
                    JobManager.verbose("-> failed to remove " + this.folderPath + " from index because of the following exception:");
                    e.printStackTrace();
                }
                monitor.exitRead();
                return false;
            }
        }
        finally {
            monitor.exitRead();
        }
        return true;
    }

    public String toString() {
        return "removing " + this.folderPath + " from index " + this.indexPath;
    }
}

