/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.indexing;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.core.internal.model.index.IIndex;
import org.eclipse.edt.ide.core.internal.model.indexing.EGLReadWriteMonitor;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexManager;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexRequest;
import org.eclipse.edt.ide.core.internal.model.search.processing.JobManager;

public class SaveIndex
extends IndexRequest {
    public SaveIndex(IPath indexPath, IndexManager manager) {
        super(indexPath, manager);
    }

    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        IIndex index = this.manager.getIndex(this.indexPath, true, false);
        if (index == null) {
            return true;
        }
        EGLReadWriteMonitor monitor = this.manager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterWrite();
                this.manager.saveIndex(index);
            }
            catch (IOException e) {
                if (JobManager.VERBOSE) {
                    JobManager.verbose("-> failed to save index " + this.indexPath + " because of the following exception:");
                    e.printStackTrace();
                }
                monitor.exitWrite();
                return false;
            }
        }
        finally {
            monitor.exitWrite();
        }
        return true;
    }

    public String toString() {
        return "saving index for " + this.indexPath;
    }
}

